/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash.plugin;

import com.android.build.gradle.api.ApplicationVariant;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.firebase.crash.plugin.MultiVersionMappingFileUploader;
import com.google.firebase.crash.plugin.NetworkConnectionProvider;
import com.google.firebase.crash.plugin.ParseJSON;
import com.google.firebase.crash.plugin.SingleVersionMappingFileUploader;
import com.google.firebase.crash.plugin.exceptions.InvalidInputException;
import com.google.firebase.crash.plugin.googleserviceobjects.ClientObj;
import com.google.firebase.crash.plugin.googleserviceobjects.GoogleServicesRootObj;
import com.google.firebase.crash.plugin.logging.Logging;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.tasks.TaskAction;

public class UploadProguardMappingTask
extends DefaultTask {
    public static final String API_KEY = "api_key";
    public static final String APP_NAME = "app_name";
    public static final String UPLOAD_URL = "upload_url";
    public static final String UPLOAD_KEY = "upload_key";
    public static final String MODULE_GROUP_FIREBASE = "com.google.firebase";
    public static final String MODULE_CRASH_FIREBASE = "firebase-crash";
    File mGoogleServicesJsonFile;
    String mPackageName;
    String mMappingFilePath;
    Map<String, Integer> mAppVersions;
    Project mProject;
    String mServiceAccountFilePath;
    String mApiKey;
    String mAppId;
    ApplicationVariant mVariant;
    private static final String FIREBASE_CRASH_DOCS_LINK = "https://firebase.google.com/docs/crash/android";
    private Logging mLogger;
    private File mServiceAccountFile;

    public void init(File googleServicesJsonFile, String mappingFilePath, String packageName, Map<String, Integer> versionCodes, Project project, String serviceAccountFilePath, ApplicationVariant applicationVariant) {
        this.mGoogleServicesJsonFile = googleServicesJsonFile;
        this.mMappingFilePath = mappingFilePath;
        this.mPackageName = packageName;
        this.mAppVersions = versionCodes;
        this.mProject = project;
        this.mServiceAccountFilePath = serviceAccountFilePath;
        this.mVariant = applicationVariant;
    }

    public void init(File googleServicesJsonFile, String mappingFilePath, String packageName, Map<String, Integer> versionCodes, Project project, String serviceAccountFilePath, ApplicationVariant applicationVariant, String apiKey, String appId) {
        this.mGoogleServicesJsonFile = googleServicesJsonFile;
        this.mMappingFilePath = mappingFilePath;
        this.mPackageName = packageName;
        this.mAppVersions = versionCodes;
        this.mProject = project;
        this.mServiceAccountFilePath = serviceAccountFilePath;
        this.mVariant = applicationVariant;
        this.mApiKey = apiKey;
        this.mAppId = appId;
    }

    @TaskAction
    public void action() throws IOException {
        this.mLogger = new Logging(this.mProject);
        this.isCrashPresent();
        this.verifyInput();
        this.verifyServiceAccountFile();
        this.verifyGoogleServicesOptionalInput();
        this.mLogger.logQuiet("Attempting to upload Proguard mapping file...");
        HashMap<String, String> resValues = new HashMap<String, String>();
        if (this.mApiKey == null && this.mAppId == null) {
            this.parseGoogleServicesFile(resValues);
        } else {
            resValues.put(APP_NAME, "apps/" + this.mAppId);
            resValues.put(API_KEY, this.mApiKey);
            this.uploadMappingFile(resValues);
        }
    }

    void isCrashPresent() throws ResolveException {
        Configuration configuration = this.mVariant.getCompileConfiguration();
        ArtifactView artifactView = configuration.getIncoming().artifactView(config -> config.attributes(container -> container.attribute(Attribute.of((String)"artifactType", String.class), (Object)"aar")));
        Set artifacts = artifactView.getArtifacts().getArtifacts();
        for (ResolvedArtifactResult artifact : artifacts) {
            ComponentIdentifier id = artifact.getId().getComponentIdentifier();
            if (!(id instanceof ModuleComponentIdentifier)) continue;
            ModuleComponentIdentifier moduleComponentId = (ModuleComponentIdentifier)id;
            String module = moduleComponentId.getModule();
            String group = moduleComponentId.getGroup();
            if (!MODULE_GROUP_FIREBASE.equalsIgnoreCase(group) || !MODULE_CRASH_FIREBASE.equalsIgnoreCase(module)) continue;
            return;
        }
        throw new GradleException("Must have a dependency on Firebase Crash Reporting to run task.  Please check the build.gradle to make sure the dependency is included");
    }

    void verifyGoogleServicesOptionalInput() {
        if (this.mApiKey == null && this.mAppId != null || this.mApiKey != null && this.mAppId == null) {
            throw new InvalidInputException("Both FirebaseCrashApiKey and FirebaseCrashAppId need to be specified.  If neither are specified, the default google-services.json file will be used");
        }
        if (this.mApiKey != null && this.mApiKey.isEmpty()) {
            throw new InvalidInputException("The specified value for FirebaseCrashApiKey is empty.  Please specify a value for FirebaseCrashApiKey");
        }
        if (this.mAppId != null && this.mAppId.isEmpty()) {
            throw new InvalidInputException("The specified value for FirebaseCrashAppId is empty.  Please specify a value for FirebaseCrashAppId");
        }
    }

    void parseGoogleServicesFile(Map<String, String> resValues) throws IOException {
        GoogleServicesRootObj root = null;
        try {
            Gson gson = new Gson();
            root = (GoogleServicesRootObj)gson.fromJson((Reader)Files.newReader((File)this.mGoogleServicesJsonFile, (Charset)Charsets.UTF_8), GoogleServicesRootObj.class);
        }
        catch (JsonSyntaxException e) {
            throw new GradleException("google-services.json file cannot be parsed", (Throwable)e);
        }
        if (root == null) {
            throw new GradleException("Unable to use google-services.json file to upload Proguard mapping file");
        }
        ClientObj clientObject = ParseJSON.getClientForPackageName(root, this.mPackageName);
        if (clientObject == null) {
            throw new GradleException("No matching client found for package name '" + this.mPackageName + "'");
        }
        String appId = ParseJSON.parseGoogleAppId(clientObject);
        resValues.put(APP_NAME, "apps/" + appId);
        String apiKey = ParseJSON.parseGoogleApiKey(clientObject);
        resValues.put(API_KEY, apiKey);
        this.uploadMappingFile(resValues);
    }

    void uploadMappingFile(Map<String, String> resValues) {
        NetworkConnectionProvider networkConnectionProvider = new NetworkConnectionProvider();
        SingleVersionMappingFileUploader singleVersionMappingFileUploader = new SingleVersionMappingFileUploader(resValues, this.mMappingFilePath, this.mLogger, this.mServiceAccountFile, networkConnectionProvider);
        MultiVersionMappingFileUploader fileUploader = new MultiVersionMappingFileUploader(this.mAppVersions, singleVersionMappingFileUploader);
        fileUploader.upload();
    }

    void verifyServiceAccountFile() {
        if (this.mServiceAccountFilePath == null || this.mServiceAccountFilePath.isEmpty()) {
            throw new InvalidInputException("Service account file path has not been defined! Service accounts are used to authorize your mapping file uploads.  Learn more at\nhttps://firebase.google.com/docs/crash/android.");
        }
        this.mServiceAccountFile = this.mProject.file((Object)this.mServiceAccountFilePath);
        if (!this.mServiceAccountFile.isFile() || !this.mServiceAccountFile.exists()) {
            throw new InvalidInputException("Service account file at path specified: " + this.mServiceAccountFilePath + " cannot be found. Service accounts are used to authorize your mapping file uploads.  Learn more at\n" + FIREBASE_CRASH_DOCS_LINK + ".");
        }
        if (!this.mServiceAccountFile.canRead()) {
            throw new InvalidInputException("Service account file at path specified: " + this.mServiceAccountFilePath + " cannot be read. Service accounts are used to authorize your mapping file uploads.  Learn more at\n" + FIREBASE_CRASH_DOCS_LINK + ".");
        }
        this.mLogger.logInfo("Using the following service account to upload ProGuard mappings files for Firebase Crash Reporting: " + this.mServiceAccountFilePath);
    }

    void verifyInput() {
        if (this.mMappingFilePath == null) {
            throw new InvalidInputException("Mapping file is not specified. Please check that the property FirebaseCrashMappingFilePath is specified. Learn more at\nhttps://firebase.google.com/docs/crash/android.");
        }
        File mappingFile = this.mProject.file((Object)this.mMappingFilePath);
        if (!mappingFile.exists() || !mappingFile.isFile()) {
            throw new InvalidInputException("Specified Mapping file path might not exist. Please check that the property FirebaseCrashMappingFilePath is specified. Learn more at\nhttps://firebase.google.com/docs/crash/android.");
        }
        if (!mappingFile.canRead()) {
            throw new InvalidInputException("Specified Mapping file cannot be read. Learn more at\nhttps://firebase.google.com/docs/crash/android.");
        }
        if (this.mPackageName == null) {
            throw new InvalidInputException("Package Name is not specified. Please check that the property FirebaseCrashPackageName is specified. Learn more at\nhttps://firebase.google.com/docs/crash/android.");
        }
        if (this.mAppVersions == null) {
            throw new InvalidInputException("App Version is not specified. Please check that the property FirebaseCrashVersionCode is specified. Learn more at\nhttps://firebase.google.com/docs/crash/android.");
        }
    }
}

