/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk;

import com.google.firebase.crashlytics.buildtools.ndk.internal.CodeMappingException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

public interface NativeSymbolGenerator {
    public static final String SO_FILE_SUFFIX = ".so";
    public static final IOFileFilter SO_FILE_FILTER = FileFilterUtils.suffixFileFilter((String)".so", (IOCase)IOCase.INSENSITIVE);
    public static final String LIB_PREFIX = "lib";

    public File generateSymbols(File var1, File var2) throws IOException, CodeMappingException;

    public static String createSymbolFileBasename(String libFilename, String arch, String uuid) {
        String moduleName = FilenameUtils.removeExtension((String)libFilename);
        if (moduleName.startsWith(LIB_PREFIX)) {
            moduleName = moduleName.substring(LIB_PREFIX.length());
        }
        return String.format("%s-%s-%s", moduleName, arch, uuid);
    }
}

