/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static final String GZIPPED_FILE_SUFFIX = ".gz";

    public static void verifyDirectory(File path) throws IOException {
        if (!path.exists()) {
            path.mkdirs();
        }
        if (!path.exists() || !path.isDirectory()) {
            throw new IOException("Could not create directory: " + path);
        }
    }

    public static void redirect(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
    }

    public static void gZipFile(File inputFile, File gZipOutputFile) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
             GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(gZipOutputFile));){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }
}

