/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.FcmBroadcastProcessor$$Lambda$0;
import com.google.firebase.iid.FcmBroadcastProcessor$$Lambda$1;
import com.google.firebase.iid.FcmBroadcastProcessor$$Lambda$2;
import com.google.firebase.iid.FcmBroadcastProcessor$$Lambda$3;
import com.google.firebase.iid.FcmBroadcastProcessor$$Lambda$4;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.ServiceStarter;
import com.google.firebase.iid.WithinAppServiceConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class FcmBroadcastProcessor {
    private static final Object lock;
    @GuardedBy(value="lock")
    private static WithinAppServiceConnection fcmServiceConn;
    private final Context context;
    private final Executor executor;

    public FcmBroadcastProcessor(Context context) {
        this.context = context;
        this.executor = FcmBroadcastProcessor$$Lambda$0.$instance;
    }

    public FcmBroadcastProcessor(Context context, ExecutorService executorService) {
        this.context = context;
        this.executor = executorService;
    }

    @KeepForSdk
    public Task<Integer> process(Intent intent) {
        String string = intent.getStringExtra("gcm.rawData64");
        if (string != null) {
            intent.putExtra("rawData", Base64.decode((String)string, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        return this.startMessagingService(this.context, intent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"InlinedApi"})
    public Task<Integer> startMessagingService(Context context, Intent intent) {
        boolean bl = PlatformVersion.isAtLeastO() ? context.getApplicationInfo().targetSdkVersion >= 26 : false;
        int n = intent.getFlags() & 0x10000000;
        if (bl && n == 0) {
            return FcmBroadcastProcessor.bindToMessagingService(context, intent);
        }
        Executor executor = ((FcmBroadcastProcessor)((Object)executor2)).executor;
        Object object = new FcmBroadcastProcessor$$Lambda$1(context, intent);
        executor = Tasks.call((Executor)executor, (Callable)object);
        Executor executor2 = ((FcmBroadcastProcessor)((Object)executor2)).executor;
        object = new FcmBroadcastProcessor$$Lambda$2(context, intent);
        return executor.continueWithTask(executor2, (Continuation)object);
    }

    private static Task<Integer> bindToMessagingService(Context context, Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Binding to service");
        }
        return FcmBroadcastProcessor.getServiceConnection(context, "com.google.firebase.MESSAGING_EVENT").sendIntent(intent).continueWith(FirebaseIidExecutors.directExecutor(), FcmBroadcastProcessor$$Lambda$3.$instance);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static WithinAppServiceConnection getServiceConnection(Context object, String string) {
        string = "com.google.firebase.MESSAGING_EVENT";
        Object object2 = lock;
        synchronized (object2) {
            WithinAppServiceConnection withinAppServiceConnection = fcmServiceConn;
            if (withinAppServiceConnection != null) return fcmServiceConn;
            fcmServiceConn = withinAppServiceConnection = new WithinAppServiceConnection((Context)object, string);
            return fcmServiceConn;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            fcmServiceConn = null;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static final /* synthetic */ Integer lambda$bindToMessagingService$3$FcmBroadcastProcessor(Task task) throws Exception {
        return -1;
    }

    static final /* synthetic */ Task lambda$startMessagingService$2$FcmBroadcastProcessor(Context context, Intent intent, Task task) throws Exception {
        if (!PlatformVersion.isAtLeastO() || (Integer)task.getResult() != 402) {
            return task;
        }
        return FcmBroadcastProcessor.bindToMessagingService(context, intent).continueWith(FirebaseIidExecutors.directExecutor(), FcmBroadcastProcessor$$Lambda$4.$instance);
    }

    static final /* synthetic */ Integer lambda$startMessagingService$1$FcmBroadcastProcessor(Task task) throws Exception {
        return 403;
    }

    static final /* synthetic */ Integer lambda$startMessagingService$0$FcmBroadcastProcessor(Context context, Intent intent) throws Exception {
        return ServiceStarter.getInstance().startMessagingService(context, intent);
    }

    static {
        Object object;
        lock = object = new Object();
    }
}

