/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.cloudmessaging.CloudMessage;
import com.google.android.gms.cloudmessaging.CloudMessagingReceiver;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.FcmBroadcastProcessor;
import java.util.concurrent.ExecutionException;

public final class FirebaseInstanceIdReceiver
extends CloudMessagingReceiver {
    private static Intent createServiceIntent(@NonNull Context context, @NonNull String string, @NonNull Bundle bundle) {
        context = new Intent(string);
        return context.putExtras(bundle);
    }

    @WorkerThread
    protected int onMessageReceive(@NonNull Context context, @NonNull CloudMessage cloudMessage) {
        try {
            Object object = new FcmBroadcastProcessor(context);
            object = ((FcmBroadcastProcessor)object).process(cloudMessage.getIntent());
            int n = (Integer)Tasks.await((Task)object);
            return n;
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to send message to service.", (Throwable)exception);
            return 500;
        }
    }

    @WorkerThread
    protected void onNotificationOpen(@NonNull Context context, @NonNull Bundle object) {
        try {
            Task<Integer> task = FirebaseInstanceIdReceiver.createServiceIntent(context, "com.google.firebase.messaging.NOTIFICATION_OPEN", (Bundle)object);
            object = new FcmBroadcastProcessor(context);
            task = ((FcmBroadcastProcessor)object).process((Intent)task);
            Tasks.await(task);
            return;
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to send notification open event to service.", (Throwable)exception);
            return;
        }
    }

    @WorkerThread
    protected void onNotificationDismissed(@NonNull Context context, @NonNull Bundle object) {
        try {
            Task<Integer> task = FirebaseInstanceIdReceiver.createServiceIntent(context, "com.google.firebase.messaging.NOTIFICATION_DISMISS", (Bundle)object);
            object = new FcmBroadcastProcessor(context);
            task = ((FcmBroadcastProcessor)object).process((Intent)task);
            Tasks.await(task);
            return;
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to send notification dismissed event to service.", (Throwable)exception);
            return;
        }
    }
}

