/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.TypeI;
import java.util.List;
import java.util.Map;

class CollapseProperties
implements CompilerPass {
    static final DiagnosticType UNSAFE_NAMESPACE_WARNING = DiagnosticType.warning("JSC_UNSAFE_NAMESPACE", "incomplete alias created for namespace {0}");
    static final DiagnosticType NAMESPACE_REDEFINED_WARNING = DiagnosticType.warning("JSC_NAMESPACE_REDEFINED", "namespace {0} should not be redefined");
    static final DiagnosticType UNSAFE_THIS = DiagnosticType.warning("JSC_UNSAFE_THIS", "dangerous use of 'this' in static method {0}");
    private AbstractCompiler compiler;
    private List<GlobalNamespace.Name> globalNames;
    private Map<String, GlobalNamespace.Name> nameMap;

    CollapseProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        GlobalNamespace namespace = new GlobalNamespace(this.compiler, root);
        this.nameMap = namespace.getNameIndex();
        this.globalNames = namespace.getNameForest();
        this.checkNamespaces();
        for (GlobalNamespace.Name name : this.globalNames) {
            this.flattenReferencesToCollapsibleDescendantNames(name, name.getBaseName());
        }
        for (GlobalNamespace.Name name : this.globalNames) {
            this.collapseDeclarationOfNameAndDescendants(name, name.getBaseName());
        }
    }

    private void checkNamespaces() {
        for (GlobalNamespace.Name name : this.nameMap.values()) {
            if (!name.isNamespaceObjectLit() || name.aliasingGets <= 0 && name.localSets + name.globalSets <= 1 && name.deleteProps <= 0) continue;
            boolean initialized = name.getDeclaration() != null;
            for (GlobalNamespace.Ref ref : name.getRefs()) {
                if (ref == name.getDeclaration()) continue;
                if (ref.type == GlobalNamespace.Ref.Type.DELETE_PROP) {
                    if (!initialized) continue;
                    this.warnAboutNamespaceRedefinition(name, ref);
                    continue;
                }
                if (ref.type == GlobalNamespace.Ref.Type.SET_FROM_GLOBAL || ref.type == GlobalNamespace.Ref.Type.SET_FROM_LOCAL) {
                    if (initialized && !this.isSafeNamespaceReinit(ref)) {
                        this.warnAboutNamespaceRedefinition(name, ref);
                    }
                    initialized = true;
                    continue;
                }
                if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET) continue;
                this.warnAboutNamespaceAliasing(name, ref);
            }
        }
    }

    private boolean isSafeNamespaceReinit(GlobalNamespace.Ref ref) {
        Node maybeName;
        Node valParent = CollapseProperties.getValueParent(ref);
        Node val = valParent.getLastChild();
        return val.isOr() && ref.node.matchesQualifiedName(maybeName = val.getFirstChild());
    }

    private static Node getValueParent(GlobalNamespace.Ref ref) {
        return ref.node.getParent() != null && ref.node.getParent().isVar() ? ref.node : ref.node.getParent();
    }

    private void warnAboutNamespaceAliasing(GlobalNamespace.Name nameObj, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.node, UNSAFE_NAMESPACE_WARNING, nameObj.getFullName()));
    }

    private void warnAboutNamespaceRedefinition(GlobalNamespace.Name nameObj, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.node, NAMESPACE_REDEFINED_WARNING, nameObj.getFullName()));
    }

    private void flattenReferencesToCollapsibleDescendantNames(GlobalNamespace.Name n, String alias) {
        if (n.props == null || n.isCollapsingExplicitlyDenied()) {
            return;
        }
        for (GlobalNamespace.Name p : n.props) {
            String propAlias = this.appendPropForAlias(alias, p.getBaseName());
            if (p.canCollapse()) {
                this.flattenReferencesTo(p, propAlias);
            } else if (p.isSimpleStubDeclaration() && !p.isCollapsingExplicitlyDenied()) {
                this.flattenSimpleStubDeclaration(p, propAlias);
            }
            this.flattenReferencesToCollapsibleDescendantNames(p, propAlias);
        }
    }

    private void flattenSimpleStubDeclaration(GlobalNamespace.Name name, String alias) {
        GlobalNamespace.Ref ref = (GlobalNamespace.Ref)Iterables.getOnlyElement(name.getRefs());
        Node nameNode = NodeUtil.newName(this.compiler, alias, ref.node, name.getFullName());
        Node varNode = IR.var(nameNode).useSourceInfoIfMissingFrom(nameNode);
        Preconditions.checkState((boolean)ref.node.getParent().isExprResult());
        Node parent = ref.node.getParent();
        Node grandparent = parent.getParent();
        grandparent.replaceChild(parent, varNode);
        this.compiler.reportChangeToEnclosingScope(varNode);
    }

    private void flattenReferencesTo(GlobalNamespace.Name n, String alias) {
        String originalName = n.getFullName();
        for (GlobalNamespace.Ref r : n.getRefs()) {
            if (r == n.getDeclaration()) continue;
            Node rParent = r.node.getParent();
            if (NodeUtil.isObjectLitKey(r.node) || r.getTwin() != null && !r.isSet()) continue;
            this.flattenNameRef(alias, r.node, rParent, originalName);
        }
        if (n.props != null) {
            for (GlobalNamespace.Name p : n.props) {
                this.flattenPrefixes(alias, p, 1);
            }
        }
    }

    private void flattenPrefixes(String alias, GlobalNamespace.Name n, int depth) {
        String originalName = n.getFullName();
        GlobalNamespace.Ref decl = n.getDeclaration();
        if (decl != null && decl.node != null && decl.node.isGetProp()) {
            this.flattenNameRefAtDepth(alias, decl.node, depth, originalName);
        }
        for (GlobalNamespace.Ref r : n.getRefs()) {
            if (r == decl || r.getTwin() != null && !r.isSet()) continue;
            this.flattenNameRefAtDepth(alias, r.node, depth, originalName);
        }
        if (n.props != null) {
            for (GlobalNamespace.Name p : n.props) {
                this.flattenPrefixes(alias, p, depth + 1);
            }
        }
    }

    private void flattenNameRefAtDepth(String alias, Node n, int depth, String originalName) {
        Token nType = n.getToken();
        boolean isQName = nType == Token.NAME || nType == Token.GETPROP;
        boolean isObjKey = NodeUtil.isObjectLitKey(n);
        Preconditions.checkState((isObjKey || isQName ? 1 : 0) != 0);
        if (isQName) {
            for (int i = 1; i < depth && n.hasChildren(); ++i) {
                n = n.getFirstChild();
            }
            if (n.isGetProp() && n.getFirstChild().isGetProp()) {
                this.flattenNameRef(alias, n.getFirstChild(), n, originalName);
            }
        }
    }

    private void flattenNameRef(String alias, Node n, Node parent, String originalName) {
        TypeI type;
        Preconditions.checkArgument((boolean)n.isGetProp(), (String)"Expected GETPROP, found %s. Node: %s", (Object)((Object)n.getToken()), (Object)n);
        Node ref = NodeUtil.newName(this.compiler, alias, n, originalName);
        NodeUtil.copyNameAnnotations(n.getLastChild(), ref);
        if (parent.isCall() && n == parent.getFirstChild()) {
            parent.putBooleanProp(50, true);
        }
        if ((type = n.getTypeI()) != null) {
            ref.setTypeI(type);
        }
        parent.replaceChild(n, ref);
        this.compiler.reportChangeToEnclosingScope(ref);
    }

    private void collapseDeclarationOfNameAndDescendants(GlobalNamespace.Name n, String alias) {
        boolean canCollapseChildNames = n.canCollapseUnannotatedChildNames();
        if (n.canCollapse()) {
            this.updateObjLitOrFunctionDeclaration(n, alias, canCollapseChildNames);
        }
        if (n.props == null) {
            return;
        }
        for (GlobalNamespace.Name p : n.props) {
            this.collapseDeclarationOfNameAndDescendants(p, this.appendPropForAlias(alias, p.getBaseName()));
            if (p.inExterns || !canCollapseChildNames || p.getDeclaration() == null || !p.canCollapse() || p.getDeclaration().node == null || p.getDeclaration().node.getParent() == null || !p.getDeclaration().node.getParent().isAssign()) continue;
            this.updateSimpleDeclaration(this.appendPropForAlias(alias, p.getBaseName()), p, p.getDeclaration());
        }
    }

    private void updateSimpleDeclaration(String alias, GlobalNamespace.Name refName, GlobalNamespace.Ref ref) {
        Node rvalue = ref.node.getNext();
        Node parent = ref.node.getParent();
        Node grandparent = parent.getParent();
        Node greatGrandparent = grandparent.getParent();
        if (rvalue != null && rvalue.isFunction()) {
            this.checkForHosedThisReferences(rvalue, refName.docInfo, refName);
        }
        Node nameNode = NodeUtil.newName(this.compiler, alias, grandparent.getFirstChild(), refName.getFullName());
        NodeUtil.copyNameAnnotations(ref.node.getLastChild(), nameNode);
        if (grandparent.isExprResult()) {
            parent.removeChild(rvalue);
            nameNode.addChildToFront(rvalue);
            Node varNode = IR.var(nameNode);
            greatGrandparent.replaceChild(grandparent, varNode);
            this.compiler.reportChangeToEnclosingScope(varNode);
        } else {
            Preconditions.checkNotNull((Object)ref.getTwin());
            Node current = grandparent;
            Node currentParent = grandparent.getParent();
            while (!currentParent.isScript() && !currentParent.isNormalBlock()) {
                current = currentParent;
                currentParent = currentParent.getParent();
            }
            Node stubVar = IR.var(nameNode.cloneTree()).useSourceInfoIfMissingFrom(nameNode);
            currentParent.addChildBefore(stubVar, current);
            parent.replaceChild(ref.node, nameNode);
            this.compiler.reportChangeToEnclosingScope(nameNode);
        }
    }

    private void updateObjLitOrFunctionDeclaration(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
        GlobalNamespace.Ref decl = n.getDeclaration();
        if (decl == null) {
            return;
        }
        if (decl.getTwin() != null) {
            return;
        }
        switch (decl.node.getParent().getToken()) {
            case ASSIGN: {
                this.updateObjLitOrFunctionDeclarationAtAssignNode(n, alias, canCollapseChildNames);
                break;
            }
            case VAR: {
                this.updateObjLitOrFunctionDeclarationAtVarNode(n, canCollapseChildNames);
                break;
            }
            case FUNCTION: {
                this.updateFunctionDeclarationAtFunctionNode(n, canCollapseChildNames);
                break;
            }
        }
    }

    private void updateObjLitOrFunctionDeclarationAtAssignNode(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
        GlobalNamespace.Ref ref = n.getDeclaration();
        Node rvalue = ref.node.getNext();
        Node varNode = new Node(Token.VAR);
        Node varParent = ref.node.getAncestor(3);
        Node grandparent = ref.node.getAncestor(2);
        boolean isObjLit = rvalue.isObjectLit();
        boolean insertedVarNode = false;
        if (isObjLit && n.canEliminate()) {
            varParent.replaceChild(grandparent, varNode);
            ref.node = null;
            insertedVarNode = true;
            this.compiler.reportChangeToEnclosingScope(varNode);
        } else if (!n.isSimpleName()) {
            if (rvalue.isFunction()) {
                this.checkForHosedThisReferences(rvalue, n.docInfo, n);
            }
            this.compiler.reportChangeToEnclosingScope(rvalue);
            ref.node.getParent().removeChild(rvalue);
            Node nameNode = NodeUtil.newName(this.compiler, alias, ref.node.getAncestor(2), n.getFullName());
            JSDocInfo info = NodeUtil.getBestJSDocInfo(ref.node.getParent());
            if (ref.node.getLastChild().getBooleanProp(43) || info != null && info.isConstant()) {
                nameNode.putBooleanProp(43, true);
            }
            if (info != null) {
                varNode.setJSDocInfo(info);
            }
            varNode.addChildToBack(nameNode);
            nameNode.addChildToFront(rvalue);
            varParent.replaceChild(grandparent, varNode);
            ref.node = nameNode;
            insertedVarNode = true;
            this.compiler.reportChangeToEnclosingScope(varNode);
        }
        if (canCollapseChildNames) {
            if (isObjLit) {
                this.declareVarsForObjLitValues(n, alias, rvalue, varNode, varNode.getPrevious(), varParent);
            }
            this.addStubsForUndeclaredProperties(n, alias, varParent, varNode);
        }
        if (insertedVarNode && !varNode.hasChildren()) {
            varParent.removeChild(varNode);
        }
    }

    private void checkForHosedThisReferences(Node function, JSDocInfo docInfo, final GlobalNamespace.Name name) {
        boolean isAllowedToReferenceThis;
        boolean bl = isAllowedToReferenceThis = docInfo != null && (docInfo.isConstructorOrInterface() || docInfo.hasThisType());
        if (!isAllowedToReferenceThis) {
            NodeTraversal.traverseEs6(this.compiler, function.getLastChild(), new NodeTraversal.AbstractShallowCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isThis()) {
                        CollapseProperties.this.compiler.report(JSError.make(n, UNSAFE_THIS, name.getFullName()));
                    }
                }
            });
        }
    }

    private void updateObjLitOrFunctionDeclarationAtVarNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
        if (!canCollapseChildNames) {
            return;
        }
        GlobalNamespace.Ref ref = n.getDeclaration();
        String name = ref.node.getString();
        Node rvalue = ref.node.getFirstChild();
        Node varNode = ref.node.getParent();
        Node grandparent = varNode.getParent();
        boolean isObjLit = rvalue.isObjectLit();
        if (isObjLit) {
            this.declareVarsForObjLitValues(n, name, rvalue, varNode, varNode.getPrevious(), grandparent);
        }
        this.addStubsForUndeclaredProperties(n, name, grandparent, varNode);
        if (isObjLit && n.canEliminate()) {
            varNode.removeChild(ref.node);
            this.compiler.reportChangeToEnclosingScope(varNode);
            if (!varNode.hasChildren()) {
                grandparent.removeChild(varNode);
            }
            ref.node = null;
        }
    }

    private void updateFunctionDeclarationAtFunctionNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
        if (!canCollapseChildNames || !n.canCollapse()) {
            return;
        }
        GlobalNamespace.Ref ref = n.getDeclaration();
        String fnName = ref.node.getString();
        this.addStubsForUndeclaredProperties(n, fnName, ref.node.getAncestor(2), ref.node.getParent());
    }

    private void declareVarsForObjLitValues(GlobalNamespace.Name objlitName, String alias, Node objlit, Node varNode, Node nameToAddAfter, Node varParent) {
        int arbitraryNameCounter = 0;
        boolean discardKeys = !objlitName.shouldKeepKeys();
        Node key = objlit.getFirstChild();
        while (key != null) {
            Node value = key.getFirstChild();
            Node nextKey = key.getNext();
            if (!key.isGetterDef() && !key.isSetterDef()) {
                boolean isJsIdentifier = !key.isNumber() && TokenStream.isJSIdentifier(key.getString());
                String propName = isJsIdentifier ? key.getString() : String.valueOf(++arbitraryNameCounter);
                String qName = objlitName.getFullName() + '.' + propName;
                GlobalNamespace.Name p = this.nameMap.get(qName);
                if (p == null || p.canCollapse()) {
                    String propAlias = this.appendPropForAlias(alias, propName);
                    Node refNode = null;
                    if (discardKeys) {
                        objlit.removeChild(key);
                        value.detach();
                    } else {
                        refNode = IR.name(propAlias);
                        if (key.getBooleanProp(43)) {
                            refNode.putBooleanProp(43, true);
                        }
                        key.replaceChild(value, refNode);
                        this.compiler.reportChangeToEnclosingScope(refNode);
                    }
                    Node nameNode = IR.name(propAlias);
                    nameNode.addChildToFront(value);
                    if (key.getBooleanProp(43)) {
                        nameNode.putBooleanProp(43, true);
                    }
                    Node newVar = IR.var(nameNode).useSourceInfoIfMissingFromForTree(key);
                    if (nameToAddAfter != null) {
                        varParent.addChildAfter(newVar, nameToAddAfter);
                    } else {
                        varParent.addChildBefore(newVar, varNode);
                    }
                    this.compiler.reportChangeToEnclosingScope(newVar);
                    nameToAddAfter = newVar;
                    if (isJsIdentifier && p != null) {
                        if (!discardKeys) {
                            GlobalNamespace.Ref newAlias = p.getDeclaration().cloneAndReclassify(GlobalNamespace.Ref.Type.ALIASING_GET);
                            newAlias.node = refNode;
                            p.addRef(newAlias);
                        }
                        p.getDeclaration().node = nameNode;
                        if (value.isFunction()) {
                            this.checkForHosedThisReferences(value, key.getJSDocInfo(), p);
                        }
                    }
                }
            }
            key = nextKey;
        }
    }

    private void addStubsForUndeclaredProperties(GlobalNamespace.Name n, String alias, Node parent, Node addAfter) {
        Preconditions.checkState((boolean)n.canCollapseUnannotatedChildNames(), (Object)n);
        Preconditions.checkArgument((boolean)NodeUtil.isStatementBlock(parent), (Object)parent);
        Preconditions.checkNotNull((Object)addAfter);
        if (n.props == null) {
            return;
        }
        for (GlobalNamespace.Name p : n.props) {
            if (!p.needsToBeStubbed()) continue;
            String propAlias = this.appendPropForAlias(alias, p.getBaseName());
            Node nameNode = IR.name(propAlias);
            Node newVar = IR.var(nameNode).useSourceInfoIfMissingFromForTree(addAfter);
            parent.addChildAfter(newVar, addAfter);
            addAfter = newVar;
            this.compiler.reportChangeToEnclosingScope(newVar);
            if (!p.getRefs().get((int)0).node.getLastChild().getBooleanProp(43)) continue;
            nameNode.putBooleanProp(43, true);
            this.compiler.reportChangeToEnclosingScope(nameNode);
        }
    }

    private String appendPropForAlias(String root, String prop) {
        if (prop.indexOf(36) != -1) {
            prop = prop.replace("$", "$0");
        }
        String result = root + '$' + prop;
        int id = 1;
        while (this.nameMap.containsKey(result)) {
            result = root + '$' + prop + '$' + id;
            ++id;
        }
        return result;
    }
}

