/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CrossModuleReferenceCollector;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

class CrossModuleCodeMotion
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(CrossModuleCodeMotion.class.getName());
    private final AbstractCompiler compiler;
    private final JSModuleGraph graph;
    private final Map<JSModule, Node> moduleVarParentMap = new HashMap<JSModule, Node>();
    private final Map<Var, NamedInfo> namedInfo = new LinkedHashMap<Var, NamedInfo>();
    private final Map<Node, InstanceofInfo> instanceofNodes = new LinkedHashMap<Node, InstanceofInfo>();
    private final boolean parentModuleCanSeeSymbolsDeclaredInChildren;

    CrossModuleCodeMotion(AbstractCompiler compiler, JSModuleGraph graph, boolean parentModuleCanSeeSymbolsDeclaredInChildren) {
        this.compiler = compiler;
        this.graph = graph;
        this.parentModuleCanSeeSymbolsDeclaredInChildren = parentModuleCanSeeSymbolsDeclaredInChildren;
    }

    @Override
    public void process(Node externs, Node root) {
        logger.fine("Moving functions + variable into deeper modules");
        if (this.graph != null && this.graph.getModuleCount() > 1) {
            this.collectReferences(root);
            this.moveCode();
            if (this.parentModuleCanSeeSymbolsDeclaredInChildren) {
                this.addInstanceofGuards();
            }
        }
    }

    private void moveCode() {
        for (NamedInfo info : this.namedInfo.values()) {
            if (!info.shouldBeMoved()) continue;
            JSModule preferredModule = info.getPreferredModule();
            Node destParent = this.moduleVarParentMap.get(preferredModule);
            if (destParent == null) {
                destParent = this.compiler.getNodeForCodeInsertion(preferredModule);
                this.moduleVarParentMap.put(preferredModule, destParent);
            }
            for (CrossModuleReferenceCollector.TopLevelStatement declaringStatement : info.movableDeclaringStatementStack) {
                Node statementNode = declaringStatement.getStatementNode();
                this.compiler.reportChangeToEnclosingScope(statementNode);
                statementNode.detach();
                destParent.addChildToFront(statementNode);
                this.compiler.reportChangeToEnclosingScope(statementNode);
            }
            info.wasMoved = true;
            info.declModule = preferredModule;
        }
    }

    private NamedInfo getNamedInfo(Var v) {
        NamedInfo info = this.namedInfo.get(v);
        if (info == null) {
            info = new NamedInfo();
            this.namedInfo.put(v, info);
        }
        return info;
    }

    private void collectReferences(Node root) {
        CrossModuleReferenceCollector collector = new CrossModuleReferenceCollector(this.compiler, new Es6SyntacticScopeCreator(this.compiler));
        collector.process(root);
        for (CrossModuleReferenceCollector.TopLevelStatement statement : collector.getTopLevelStatements()) {
            Var declaredVar = null;
            if (statement.isDeclarationStatement()) {
                declaredVar = statement.getDeclaredNameReference().getSymbol();
                NamedInfo declaredNameInfo = this.getNamedInfo(declaredVar);
                if (statement.isMovableDeclaration()) {
                    declaredNameInfo.addMovableDeclaringStatement(statement);
                } else {
                    declaredNameInfo.addReferringStatement(statement);
                }
            }
            for (Reference ref : statement.getNonDeclarationReferences()) {
                Var v = ref.getSymbol();
                if (Objects.equal((Object)declaredVar, (Object)v)) continue;
                NamedInfo info = this.getNamedInfo(v);
                if (!this.parentModuleCanSeeSymbolsDeclaredInChildren) {
                    info.addReferringStatement(statement);
                    continue;
                }
                Node n = ref.getNode();
                if (this.isUnguardedInstanceofReference(n)) {
                    this.instanceofNodes.put(n.getParent(), new InstanceofInfo(this.getModule(ref), info));
                    continue;
                }
                if (this.isUndefinedTypeofGuardReference(n) || this.isGuardedInstanceofReference(n)) continue;
                info.addReferringStatement(statement);
            }
        }
    }

    private boolean isUndefinedTypeofGuardReference(Node reference) {
        Node undefinedTypeofGuard = reference.getGrandparent();
        if (undefinedTypeofGuard != null && this.isUndefinedTypeofGuardFor(undefinedTypeofGuard, reference)) {
            Node andNode = undefinedTypeofGuard.getParent();
            return andNode != null && andNode.isAnd() && this.isInstanceofFor(andNode.getLastChild(), reference);
        }
        return false;
    }

    private boolean isUndefinedTypeofGuardFor(Node expression, Node reference) {
        if (expression.isNE()) {
            Node undefinedString = expression.getFirstChild();
            Node typeofNode = expression.getLastChild();
            return undefinedString.isString() && undefinedString.getString().equals("undefined") && typeofNode.isTypeOf() && typeofNode.getFirstChild().isEquivalentTo(reference);
        }
        return false;
    }

    private boolean isGuardedInstanceofReference(Node reference) {
        Node instanceofNode = reference.getParent();
        if (this.isInstanceofFor(instanceofNode, reference)) {
            Node andNode = instanceofNode.getParent();
            return andNode != null && andNode.isAnd() && this.isUndefinedTypeofGuardFor(andNode.getFirstChild(), reference);
        }
        return false;
    }

    private boolean isUnguardedInstanceofReference(Node reference) {
        Node instanceofNode = reference.getParent();
        if (this.isInstanceofFor(instanceofNode, reference)) {
            Node andNode = instanceofNode.getParent();
            return andNode == null || !andNode.isAnd() || !this.isUndefinedTypeofGuardFor(andNode.getFirstChild(), reference);
        }
        return false;
    }

    private boolean isInstanceofFor(Node expression, Node reference) {
        return expression.isInstanceOf() && expression.getLastChild().isEquivalentTo(reference);
    }

    private JSModule getModule(Reference ref) {
        return this.compiler.getInput(ref.getInputId()).getModule();
    }

    private void addInstanceofGuards() {
        Node tmp = IR.block();
        for (Map.Entry<Node, InstanceofInfo> entry : this.instanceofNodes.entrySet()) {
            Node n = entry.getKey();
            InstanceofInfo info = entry.getValue();
            if (!info.namedInfo.wasMoved || info.namedInfo.declModule.equals(info.module) || this.graph.dependsOn(info.module, info.namedInfo.declModule)) continue;
            Node originalReference = n.getLastChild();
            Preconditions.checkState((boolean)this.isUnguardedInstanceofReference(originalReference), (String)"instanceof Reference is already guarded: %s", (Object)originalReference);
            Node reference = originalReference.cloneNode();
            Preconditions.checkState((boolean)reference.isName());
            n.replaceWith(tmp);
            Node and = IR.and(new Node(Token.NE, IR.string("undefined"), new Node(Token.TYPEOF, reference)), n);
            and.useSourceInfoIfMissingFromForTree(n);
            tmp.replaceWith(and);
            this.compiler.reportChangeToEnclosingScope(and);
        }
    }

    private static class InstanceofInfo {
        private final JSModule module;
        private final NamedInfo namedInfo;

        InstanceofInfo(JSModule module, NamedInfo namedInfo) {
            this.module = (JSModule)Preconditions.checkNotNull((Object)module);
            this.namedInfo = (NamedInfo)Preconditions.checkNotNull((Object)namedInfo);
        }
    }

    private class NamedInfo {
        private boolean allowMove = true;
        private BitSet modulesWithReferences = null;
        private JSModule preferredModule = null;
        private JSModule declModule = null;
        private boolean wasMoved = false;
        private final Deque<CrossModuleReferenceCollector.TopLevelStatement> movableDeclaringStatementStack = new ArrayDeque<CrossModuleReferenceCollector.TopLevelStatement>();

        private NamedInfo() {
        }

        void addMovableDeclaringStatement(CrossModuleReferenceCollector.TopLevelStatement declaringStatement) {
            if (this.allowMove) {
                if (this.modulesWithReferences != null) {
                    this.addReferringStatement(declaringStatement);
                } else if (this.declModule == null) {
                    this.declModule = declaringStatement.getModule();
                    this.movableDeclaringStatementStack.push(declaringStatement);
                } else if (this.declModule.equals(declaringStatement.getModule())) {
                    this.movableDeclaringStatementStack.push(declaringStatement);
                } else {
                    this.addReferringStatement(declaringStatement);
                }
            }
        }

        void addReferringStatement(CrossModuleReferenceCollector.TopLevelStatement referringStatement) {
            if (this.allowMove) {
                if (this.declModule == null) {
                    this.allowMove = false;
                } else if (referringStatement.getModule().equals(this.declModule)) {
                    this.allowMove = false;
                    this.movableDeclaringStatementStack.clear();
                    this.modulesWithReferences = null;
                } else {
                    this.addUsedModule(referringStatement.getModule());
                }
            }
        }

        private void addUsedModule(JSModule m) {
            if (this.modulesWithReferences == null) {
                this.modulesWithReferences = new BitSet(CrossModuleCodeMotion.this.graph.getModuleCount());
            }
            this.modulesWithReferences.set(m.getIndex());
            this.preferredModule = null;
        }

        JSModule getPreferredModule() {
            if (this.preferredModule == null) {
                this.preferredModule = this.modulesWithReferences == null ? (JSModule)Preconditions.checkNotNull((Object)this.declModule) : CrossModuleCodeMotion.this.graph.getSmallestCoveringDependency(this.modulesWithReferences);
            }
            return this.preferredModule;
        }

        boolean shouldBeMoved() {
            return this.allowMove && this.declModule != null && CrossModuleCodeMotion.this.graph.dependsOn(this.getPreferredModule(), this.declModule);
        }
    }
}

