/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.util.Set;

public class Es6SyntacticScopeCreator
implements ScopeCreator {
    private final AbstractCompiler compiler;
    private final RedeclarationHandler redeclarationHandler;
    private final ScopeFactory scopeFactory;
    private static final String ARGUMENTS = "arguments";
    public static final RedeclarationHandler DEFAULT_REDECLARATION_HANDLER = new DefaultRedeclarationHandler();

    public Es6SyntacticScopeCreator(AbstractCompiler compiler) {
        this(compiler, DEFAULT_REDECLARATION_HANDLER);
    }

    public Es6SyntacticScopeCreator(AbstractCompiler compiler, ScopeFactory scopeFactory) {
        this(compiler, DEFAULT_REDECLARATION_HANDLER, scopeFactory);
    }

    Es6SyntacticScopeCreator(AbstractCompiler compiler, RedeclarationHandler redeclarationHandler) {
        this(compiler, redeclarationHandler, new DefaultScopeFactory());
    }

    Es6SyntacticScopeCreator(AbstractCompiler compiler, RedeclarationHandler redeclarationHandler, ScopeFactory scopeFactory) {
        this.compiler = compiler;
        this.redeclarationHandler = redeclarationHandler;
        this.scopeFactory = scopeFactory;
    }

    @Override
    public boolean hasBlockScope() {
        return true;
    }

    public Scope createScope(Node n, Scope parent) {
        Scope scope = this.scopeFactory.create(parent, n);
        new ScopeScanner(this.compiler, this.redeclarationHandler, scope, null).populate();
        return scope;
    }

    static class DefaultRedeclarationHandler
    implements RedeclarationHandler {
        DefaultRedeclarationHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
        }
    }

    static interface RedeclarationHandler {
        public void onRedeclaration(Scope var1, String var2, Node var3, CompilerInput var4);
    }

    static class ScopeScanner {
        private final Scope scope;
        private final AbstractCompiler compiler;
        private final RedeclarationHandler redeclarationHandler;
        private InputId inputId;
        private final Set<Node> changeRootSet;

        ScopeScanner(AbstractCompiler compiler, Scope scope) {
            this(compiler, DEFAULT_REDECLARATION_HANDLER, scope, null);
        }

        ScopeScanner(AbstractCompiler compiler, RedeclarationHandler redeclarationHandler, Scope scope, Set<Node> changeRootSet) {
            this.compiler = compiler;
            this.redeclarationHandler = redeclarationHandler;
            this.scope = scope;
            this.changeRootSet = changeRootSet;
            Preconditions.checkState((changeRootSet == null || scope.isGlobal() ? 1 : 0) != 0);
        }

        void populate() {
            Node n = this.scope.getRootNode();
            this.inputId = NodeUtil.getInputId(n);
            if (n.isFunction()) {
                Node fnNameNode = n.getFirstChild();
                Node args = fnNameNode.getNext();
                String fnName = fnNameNode.getString();
                if (!fnName.isEmpty() && NodeUtil.isFunctionExpression(n)) {
                    this.declareVar(fnNameNode);
                }
                Preconditions.checkState((boolean)args.isParamList());
                this.declareLHS(args);
            } else if (n.isClass()) {
                Node classNameNode = n.getFirstChild();
                if (!classNameNode.isEmpty() && NodeUtil.isClassExpression(n)) {
                    this.declareVar(classNameNode);
                }
            } else if (n.isRoot() || n.isNormalBlock() || NodeUtil.isAnyFor(n) || n.isSwitch() || n.isModuleBody()) {
                boolean scanInnerBlocks = n.isRoot() || NodeUtil.isFunctionBlock(n) || n.isModuleBody();
                this.scanVars(n, scanInnerBlocks, true);
            } else {
                Preconditions.checkState((boolean)this.scope.isGlobal(), (Object)this.scope);
                this.scanVars(n, true, true);
            }
        }

        private void declareLHS(Node n) {
            for (Node lhs : NodeUtil.getLhsNodesOfDeclaration(n)) {
                this.declareVar(lhs);
            }
        }

        private void scanVars(Node n, boolean scanInnerBlockScopes, boolean firstScan) {
            switch (n.getToken()) {
                case VAR: {
                    if (this.scope.isHoistScope()) {
                        this.declareLHS(n);
                    }
                    return;
                }
                case LET: 
                case CONST: {
                    if (!this.isNodeAtCurrentLexicalScope(n)) {
                        return;
                    }
                    this.declareLHS(n);
                    return;
                }
                case FUNCTION: {
                    if (NodeUtil.isFunctionExpression(n) || !this.isNodeAtCurrentLexicalScope(n)) {
                        return;
                    }
                    String fnName = n.getFirstChild().getString();
                    if (fnName.isEmpty()) {
                        return;
                    }
                    this.declareVar(n.getFirstChild());
                    return;
                }
                case CLASS: {
                    if (NodeUtil.isClassExpression(n) || !this.isNodeAtCurrentLexicalScope(n)) {
                        return;
                    }
                    String className = n.getFirstChild().getString();
                    if (className.isEmpty()) {
                        return;
                    }
                    this.declareVar(n.getFirstChild());
                    return;
                }
                case CATCH: {
                    Preconditions.checkState((boolean)n.hasTwoChildren(), (Object)n);
                    if (this.isNodeAtCurrentLexicalScope(n)) {
                        this.declareLHS(n);
                    }
                    Node block = n.getSecondChild();
                    this.scanVars(block, scanInnerBlockScopes, false);
                    return;
                }
                case SCRIPT: {
                    if (this.changeRootSet != null && !this.changeRootSet.contains(n)) {
                        return;
                    }
                    this.inputId = n.getInputId();
                    Preconditions.checkNotNull((Object)this.inputId);
                    break;
                }
                case MODULE_BODY: {
                    if (!this.scope.isGlobal()) break;
                    return;
                }
            }
            if (!scanInnerBlockScopes && !firstScan && NodeUtil.createsBlockScope(n)) {
                return;
            }
            if (NodeUtil.isControlStructure(n) || NodeUtil.isStatementBlock(n)) {
                Node child = n.getFirstChild();
                while (child != null) {
                    Node next = child.getNext();
                    this.scanVars(child, scanInnerBlockScopes, false);
                    child = next;
                }
            }
        }

        private void declareVar(Node n) {
            Preconditions.checkState((n.isName() || n.isStringKey() ? 1 : 0) != 0, (String)"Invalid node for declareVar: %s", (Object)n);
            String name = n.getString();
            Var v = this.scope.getOwnSlot(name);
            if (v != null && v.getNode() == n) {
                return;
            }
            CompilerInput input = this.compiler.getInput(this.inputId);
            if (v != null || this.isShadowingDisallowed(name) || (this.scope.isFunctionScope() || this.scope.isFunctionBlockScope()) && name.equals(Es6SyntacticScopeCreator.ARGUMENTS)) {
                this.redeclarationHandler.onRedeclaration(this.scope, name, n, input);
            } else {
                this.scope.declare(name, n, input);
            }
        }

        private boolean isShadowingDisallowed(String name) {
            if (this.scope.isFunctionBlockScope()) {
                Var maybeParam = this.scope.getParent().getOwnSlot(name);
                return maybeParam != null && maybeParam.isParam();
            }
            return false;
        }

        private boolean isNodeAtCurrentLexicalScope(Node n) {
            Node parent = n.getParent();
            Node grandparent = parent.getParent();
            switch (parent.getToken()) {
                case SCRIPT: {
                    return true;
                }
                case BLOCK: {
                    if (grandparent.isCase() || grandparent.isDefaultCase() || grandparent.isCatch()) {
                        return this.scope.getRootNode() == grandparent.getParent();
                    }
                }
                case MODULE_BODY: 
                case FOR: 
                case FOR_IN: 
                case FOR_OF: {
                    return parent == this.scope.getRootNode();
                }
                case LABEL: {
                    while (parent.isLabel()) {
                        if (parent.getParent() == this.scope.getRootNode()) {
                            return true;
                        }
                        parent = parent.getParent();
                    }
                    return false;
                }
            }
            throw new RuntimeException("Unsupported node parent: " + parent);
        }
    }

    private static class DefaultScopeFactory
    implements ScopeFactory {
        private DefaultScopeFactory() {
        }

        @Override
        public Scope create(Scope parent, Node n) {
            return parent == null ? Scope.createGlobalScope(n) : new Scope(parent, n);
        }
    }

    public static interface ScopeFactory {
        public Scope create(Scope var1, Node var2);
    }
}

