/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.InvalidatingTypes;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.HashMap;
import java.util.Map;

final class InlineProperties
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final PropertyInfo INVALIDATED = new PropertyInfo(null, null);
    private final Map<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();
    private final InvalidatingTypes invalidatingTypes;

    InlineProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.invalidatingTypes = new InvalidatingTypes.Builder(compiler.getTypeIRegistry()).addTypesInvalidForPropertyRenaming().addAllTypeMismatches(compiler.getTypeMismatches()).build();
        this.invalidateExternProperties();
    }

    private void invalidateExternProperties() {
        for (String name : this.compiler.getExternProperties()) {
            this.props.put(name, INVALIDATED);
        }
    }

    private TypeI getTypeI(Node n) {
        TypeI type = n.getTypeI();
        if (type == null) {
            return this.compiler.getTypeIRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return type;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, new GatherCandidates());
        NodeTraversal.traverseEs6(this.compiler, root, new ReplaceCandidates());
    }

    class ReplaceCandidates
    extends NodeTraversal.AbstractPostOrderCallback {
        ReplaceCandidates() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp() && !NodeUtil.isLValue(n)) {
                Node target = n.getFirstChild();
                String propName = n.getLastChild().getString();
                PropertyInfo info = (PropertyInfo)InlineProperties.this.props.get(propName);
                if (info != null && info != INVALIDATED && this.isMatchingType(target, info.type)) {
                    Node replacement = info.value.cloneTree();
                    if (NodeUtil.mayHaveSideEffects(n.getFirstChild(), InlineProperties.this.compiler)) {
                        replacement = IR.comma(n.removeFirstChild(), replacement).srcref(n);
                    }
                    parent.replaceChild(n, replacement);
                    InlineProperties.this.compiler.reportChangeToEnclosingScope(replacement);
                }
            }
        }

        private boolean isMatchingType(Node n, TypeI src) {
            src = src.restrictByNotNullOrUndefined();
            TypeI dest = InlineProperties.this.getTypeI(n).restrictByNotNullOrUndefined();
            if (!InlineProperties.this.invalidatingTypes.isInvalidating(dest)) {
                if (dest.isConstructor() || src.isConstructor()) {
                    return dest.equals(src);
                }
                return dest.isSubtypeOf(src);
            }
            return false;
        }
    }

    class GatherCandidates
    extends NodeTraversal.AbstractPostOrderCallback {
        GatherCandidates() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            boolean invalidatingPropRef = false;
            String propName = null;
            if (n.isGetProp()) {
                propName = n.getLastChild().getString();
                invalidatingPropRef = parent.isAssign() ? !this.isValidCandidateDefinition(t, n, parent) : (NodeUtil.isLValue(n) ? true : parent.isDelProp());
            } else if (n.isStringKey()) {
                propName = n.getString();
                invalidatingPropRef = true;
            }
            if (invalidatingPropRef) {
                Preconditions.checkNotNull((Object)propName);
                this.invalidateProperty(propName);
            }
        }

        private boolean isValidCandidateDefinition(NodeTraversal t, Node n, Node parent) {
            TypeI targetType;
            Preconditions.checkState((n.isGetProp() && parent.isAssign() ? 1 : 0) != 0, (Object)n);
            Node src = n.getFirstChild();
            String propName = n.getLastChild().getString();
            Node value = parent.getLastChild();
            if (src.isThis()) {
                if (this.inConstructor(t)) {
                    return this.maybeStoreCandidateValue(InlineProperties.this.getTypeI(src), propName, value);
                }
            } else if (t.inGlobalHoistScope() && src.isGetProp() && src.getLastChild().getString().equals("prototype")) {
                TypeI instanceType = this.maybeGetInstanceTypeFromPrototypeRef(src);
                if (instanceType != null) {
                    return this.maybeStoreCandidateValue(instanceType, propName, value);
                }
            } else if (t.inGlobalHoistScope() && (targetType = InlineProperties.this.getTypeI(src)) != null && targetType.isConstructor()) {
                return this.maybeStoreCandidateValue(targetType, propName, value);
            }
            return false;
        }

        private TypeI maybeGetInstanceTypeFromPrototypeRef(Node src) {
            TypeI ownerType = InlineProperties.this.getTypeI(src.getFirstChild());
            if (ownerType.isConstructor()) {
                FunctionTypeI functionType = ownerType.toMaybeFunctionType();
                return functionType.getInstanceType();
            }
            return null;
        }

        private void invalidateProperty(String propName) {
            InlineProperties.this.props.put(propName, INVALIDATED);
        }

        private boolean maybeStoreCandidateValue(TypeI type, String propName, Node value) {
            Preconditions.checkNotNull((Object)value);
            if (!InlineProperties.this.props.containsKey(propName) && !InlineProperties.this.invalidatingTypes.isInvalidating(type) && NodeUtil.isImmutableValue(value) && NodeUtil.isExecutedExactlyOnce(value)) {
                InlineProperties.this.props.put(propName, new PropertyInfo(type, value));
                return true;
            }
            return false;
        }

        private boolean inConstructor(NodeTraversal t) {
            Node root = t.getEnclosingFunction();
            if (root == null) {
                return false;
            }
            JSDocInfo info = NodeUtil.getBestJSDocInfo(root);
            return info != null && info.isConstructor();
        }
    }

    private static class PropertyInfo {
        final TypeI type;
        final Node value;

        PropertyInfo(TypeI type, Node value) {
            this.type = type;
            this.value = value;
        }
    }
}

