/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PureFunctionIdentifier;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class J2clClinitPrunerPass
implements CompilerPass {
    private final AbstractCompiler compiler;
    private boolean madeChange = false;
    private final List<Node> changedScopeNodes;

    J2clClinitPrunerPass(AbstractCompiler compiler, List<Node> changedScopeNodes) {
        this.compiler = compiler;
        this.changedScopeNodes = changedScopeNodes;
    }

    @Override
    public void process(Node externs, Node root) {
        if (!J2clSourceFileChecker.shouldRunJ2clPasses(this.compiler)) {
            return;
        }
        RedundantClinitPruner redundantClinitPruner = new RedundantClinitPruner();
        NodeTraversal.traverseEs6ScopeRoots(this.compiler, root, this.getNonNestedParentScopeNodes(), redundantClinitPruner, redundantClinitPruner, true);
        NodeTraversal.traverseEs6ScopeRoots(this.compiler, root, this.changedScopeNodes, new LookAheadRedundantClinitPruner(), false);
        NodeTraversal.traverseEs6ScopeRoots(this.compiler, root, this.changedScopeNodes, new EmptyClinitPruner(), false);
        if (this.madeChange) {
            new PureFunctionIdentifier.Driver(this.compiler, null).process(externs, root);
        }
    }

    private List<Node> getNonNestedParentScopeNodes() {
        return this.changedScopeNodes == null ? null : NodeUtil.removeNestedChangeScopeNodes(NodeUtil.getParentChangeScopeNodes(this.changedScopeNodes));
    }

    private static boolean isClinitMethod(Node node) {
        return node.isFunction() && J2clClinitPrunerPass.isClinitMethodName(NodeUtil.getName(node));
    }

    private static String getClinitMethodName(Node fnNode) {
        String fnName = fnNode.getQualifiedName();
        return J2clClinitPrunerPass.isClinitMethodName(fnName) ? fnName : null;
    }

    private static boolean isClinitMethodName(String fnName) {
        return fnName != null && (fnName.endsWith("$$0clinit") || fnName.endsWith(".$clinit"));
    }

    private static class HierarchicalSet<T> {
        private Set<T> currentSet = new HashSet<T>();
        @Nullable
        private final HierarchicalSet<T> parent;

        public HierarchicalSet(@Nullable HierarchicalSet<T> parent) {
            this.parent = parent;
        }

        public boolean add(T o) {
            return !this.parentsContains(o) && this.currentSet.add(o);
        }

        private boolean parentsContains(T o) {
            return this.parent != null && (this.parent.currentSet.contains(o) || super.parentsContains(o));
        }
    }

    private final class EmptyClinitPruner
    extends NodeTraversal.AbstractPostOrderCallback {
        private EmptyClinitPruner() {
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            if (!J2clClinitPrunerPass.isClinitMethod(node)) {
                return;
            }
            this.trySubstituteEmptyFunction(node);
        }

        private void trySubstituteEmptyFunction(Node fnNode) {
            String fnQualifiedName = NodeUtil.getName(fnNode);
            if (Strings.isNullOrEmpty((String)fnQualifiedName)) {
                return;
            }
            Node body = fnNode.getLastChild();
            if (!body.hasChildren()) {
                return;
            }
            Node firstExpr = body.getFirstChild();
            if (!this.isAssignToEmptyFn(firstExpr, fnQualifiedName) || firstExpr.getNext() != null) {
                return;
            }
            body.removeChild(firstExpr);
            NodeUtil.markFunctionsDeleted(firstExpr, J2clClinitPrunerPass.this.compiler);
            J2clClinitPrunerPass.this.compiler.reportChangeToEnclosingScope(body);
            J2clClinitPrunerPass.this.madeChange = true;
        }

        private boolean isAssignToEmptyFn(Node node, String enclosingFnName) {
            if (!NodeUtil.isExprAssign(node)) {
                return false;
            }
            Node lhs = node.getFirstFirstChild();
            Node rhs = node.getFirstChild().getLastChild();
            return NodeUtil.isEmptyFunctionExpression(rhs) && lhs.matchesQualifiedName(enclosingFnName);
        }
    }

    private final class LookAheadRedundantClinitPruner
    extends NodeTraversal.AbstractPostOrderCallback {
        private LookAheadRedundantClinitPruner() {
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            String clinitName;
            if (!node.isExprResult()) {
                return;
            }
            String string = clinitName = node.getFirstChild().isCall() ? J2clClinitPrunerPass.getClinitMethodName(node.getFirstFirstChild()) : null;
            if (clinitName == null) {
                return;
            }
            Node callOrNewNode = this.getCallOrNewNode(node.getNext());
            if (callOrNewNode == null || !callOrNewNode.getFirstChild().isName()) {
                return;
            }
            Node enclosingFunction = NodeUtil.getEnclosingFunction(node);
            if (enclosingFunction == null || callOrNewNode.getFirstChild().getString().equals(NodeUtil.getNearestFunctionName(enclosingFunction))) {
                return;
            }
            Var var = t.getScope().getVar(callOrNewNode.getFirstChild().getString());
            if (var == null || var.getInitialValue() == null || !var.getInitialValue().isFunction()) {
                return;
            }
            Node staticFnNode = var.getInitialValue();
            if (this.callsClinit(staticFnNode, clinitName) && this.hasSafeArguments(t, callOrNewNode)) {
                parent.removeChild(node);
                J2clClinitPrunerPass.this.compiler.reportChangeToEnclosingScope(parent);
                J2clClinitPrunerPass.this.madeChange = true;
            }
        }

        private boolean hasSafeArguments(NodeTraversal t, Node callOrNewNode) {
            for (Node child = callOrNewNode.getSecondChild(); child != null; child = child.getNext()) {
                if (NodeUtil.isLiteralValue(child, false) || this.isParameter(t, child)) continue;
                return false;
            }
            return true;
        }

        private boolean isParameter(NodeTraversal t, Node n) {
            if (!n.isName()) {
                return false;
            }
            Var var = t.getScope().getVar(n.getString());
            return var.getParentNode().isParamList();
        }

        private Node getCallOrNewNode(Node n) {
            if (n == null) {
                return null;
            }
            switch (n.getToken()) {
                case EXPR_RESULT: 
                case RETURN: {
                    return this.getCallOrNewNode(n.getFirstChild());
                }
                case CALL: 
                case NEW: {
                    return n;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    return n.hasOneChild() ? this.getCallOrNewNode(n.getFirstFirstChild()) : null;
                }
            }
            return null;
        }

        private boolean callsClinit(Node fnNode, String clinitName) {
            Preconditions.checkNotNull((Object)clinitName);
            Node child = fnNode.getLastChild().getFirstChild();
            return child != null && child.isExprResult() && child.getFirstChild().isCall() && clinitName.equals(J2clClinitPrunerPass.getClinitMethodName(child.getFirstFirstChild()));
        }
    }

    private final class RedundantClinitPruner
    implements NodeTraversal.Callback,
    NodeTraversal.FunctionCallback {
        private final Deque<HierarchicalSet<String>> stateStack = new ArrayDeque<HierarchicalSet<String>>();
        private HierarchicalSet<String> clinitsCalledAtBranch = new HierarchicalSet(null);

        private RedundantClinitPruner() {
        }

        @Override
        public void enterFunction(AbstractCompiler compiler, Node fnRoot) {
            this.clinitsCalledAtBranch = new HierarchicalSet(null);
            this.stateStack.clear();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node node, Node parent) {
            if (NodeUtil.isFunctionDeclaration(node)) {
                this.stateStack.addLast(this.clinitsCalledAtBranch);
                this.clinitsCalledAtBranch = new HierarchicalSet(null);
            }
            if (this.isNewControlBranch(parent)) {
                this.clinitsCalledAtBranch = new HierarchicalSet<String>(this.clinitsCalledAtBranch);
                if (J2clClinitPrunerPass.isClinitMethod(parent)) {
                    this.clinitsCalledAtBranch.add(NodeUtil.getName(parent));
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            this.tryRemovingClinit(node, parent);
            if (this.isNewControlBranch(parent)) {
                this.clinitsCalledAtBranch = ((HierarchicalSet)this.clinitsCalledAtBranch).parent;
            }
            if (parent != null && NodeUtil.isFunctionDeclaration(node)) {
                this.clinitsCalledAtBranch = this.stateStack.removeLast();
            }
        }

        private void tryRemovingClinit(Node node, Node parent) {
            String clinitName;
            String string = clinitName = node.isCall() ? J2clClinitPrunerPass.getClinitMethodName(node.getFirstChild()) : null;
            if (clinitName == null) {
                return;
            }
            if (this.clinitsCalledAtBranch.add(clinitName)) {
                return;
            }
            parent.replaceChild(node, NodeUtil.newUndefinedNode(node));
            J2clClinitPrunerPass.this.compiler.reportChangeToEnclosingScope(parent);
            J2clClinitPrunerPass.this.madeChange = true;
        }

        private boolean isNewControlBranch(Node n) {
            return n != null && (NodeUtil.isControlStructure(n) || n.isHook() || n.isAnd() || n.isOr() || n.isFunction());
        }
    }
}

