/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.List;

public class J2clEqualitySameRewriterPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final List<Node> changedScopeNodes;

    J2clEqualitySameRewriterPass(AbstractCompiler compiler, List<Node> changedScopeNodes) {
        this.compiler = compiler;
        this.changedScopeNodes = changedScopeNodes;
    }

    @Override
    public void process(Node externs, Node root) {
        if (!J2clSourceFileChecker.shouldRunJ2clPasses(this.compiler)) {
            return;
        }
        NodeTraversal.traverseEs6ScopeRoots(this.compiler, root, this.changedScopeNodes, this, false);
    }

    @Override
    public void visit(NodeTraversal t, Node node, Node parent) {
        if (J2clEqualitySameRewriterPass.isEqualitySameCall(node)) {
            this.trySubstituteEqualitySame(node);
        }
    }

    private void trySubstituteEqualitySame(Node callNode) {
        Node firstExpr = callNode.getSecondChild();
        Node secondExpr = callNode.getLastChild();
        if (NodeUtil.isNullOrUndefined(firstExpr) || NodeUtil.isNullOrUndefined(secondExpr)) {
            this.rewriteToEq(callNode, firstExpr, secondExpr, Eq.DOUBLE);
            return;
        }
        if (NodeUtil.isLiteralValue(firstExpr, true) || NodeUtil.isLiteralValue(secondExpr, true)) {
            this.rewriteToEq(callNode, firstExpr, secondExpr, Eq.TRIPLE);
            return;
        }
    }

    private void rewriteToEq(Node callNode, Node firstExpr, Node secondExpr, Eq eq) {
        Node parent = callNode.getParent();
        firstExpr.detach();
        secondExpr.detach();
        Node replacement = eq == Eq.DOUBLE ? IR.eq(firstExpr, secondExpr) : IR.sheq(firstExpr, secondExpr);
        parent.replaceChild(callNode, replacement.useSourceInfoIfMissingFrom(callNode));
        this.compiler.reportChangeToEnclosingScope(parent);
    }

    private static boolean isEqualitySameCall(Node node) {
        return node.isCall() && J2clEqualitySameRewriterPass.isEqualitySameMethodName(node.getFirstChild());
    }

    private static boolean isEqualitySameMethodName(Node fnName) {
        if (!fnName.isQualifiedName()) {
            return false;
        }
        String originalQname = fnName.getOriginalQualifiedName();
        return originalQname.endsWith(".$same") && originalQname.contains("Equality");
    }

    private static enum Eq {
        DOUBLE,
        TRIPLE;

    }
}

