/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.rhino.Node;

final class J2clSourceFileChecker
implements CompilerPass {
    private AbstractCompiler compiler;
    static final String HAS_J2CL_ANNOTATION_KEY = "HAS_J2CL";

    J2clSourceFileChecker(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private static Boolean hasJ2cl(Node root) {
        for (Node script : root.children()) {
            Preconditions.checkState((boolean)script.isScript());
            if (script.getSourceFileName() == null || !script.getSourceFileName().endsWith(".java.js") || !script.getSourceFileName().contains(".js.zip!")) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void process(Node externs, Node root) {
        this.compiler.setAnnotation(HAS_J2CL_ANNOTATION_KEY, J2clSourceFileChecker.hasJ2cl(root));
    }

    static boolean shouldRunJ2clPasses(AbstractCompiler compiler) {
        return compiler.getOptions().j2clPassMode.isExplicitlyOn() || Boolean.TRUE.equals(compiler.getAnnotation(HAS_J2CL_ANNOTATION_KEY));
    }
}

