/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class LazyParsedDependencyInfo
implements DependencyInfo {
    private final DependencyInfo delegate;
    private final JsAst ast;
    private final transient AbstractCompiler compiler;
    private ImmutableMap<String, String> loadFlags;

    public LazyParsedDependencyInfo(DependencyInfo delegate, JsAst ast, AbstractCompiler compiler) {
        this.delegate = (DependencyInfo)Preconditions.checkNotNull((Object)delegate);
        this.ast = (JsAst)Preconditions.checkNotNull((Object)ast);
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
    }

    @Override
    public ImmutableMap<String, String> getLoadFlags() {
        if (this.loadFlags == null) {
            String version;
            TreeMap<String, String> loadFlagsBuilder = new TreeMap<String, String>();
            loadFlagsBuilder.putAll((Map<String, String>)this.delegate.getLoadFlags());
            FeatureSet features = this.ast.getFeatures(this.compiler);
            if (features.has(FeatureSet.Feature.MODULES)) {
                String previousModule = (String)loadFlagsBuilder.get("module");
                if (previousModule != null && !previousModule.equals("es6")) {
                    this.compiler.report(JSError.make(ModuleLoader.MODULE_CONFLICT, this.getName()));
                }
                loadFlagsBuilder.put("module", "es6");
            }
            if (!(version = features.version()).equals("es3")) {
                loadFlagsBuilder.put("lang", version);
            }
            this.loadFlags = ImmutableMap.copyOf(loadFlagsBuilder);
        }
        return this.loadFlags;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getPathRelativeToClosureBase() {
        return this.delegate.getPathRelativeToClosureBase();
    }

    @Override
    public Collection<String> getRequires() {
        return this.delegate.getRequires();
    }

    @Override
    public Collection<String> getProvides() {
        return this.delegate.getProvides();
    }

    @Override
    public boolean isModule() {
        return "goog".equals(this.getLoadFlags().get((Object)"module"));
    }
}

