/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

final class ObjectPropertyStringPreprocess
implements CompilerPass {
    static final String OBJECT_PROPERTY_STRING = "goog.testing.ObjectPropertyString";
    static final DiagnosticType INVALID_NUM_ARGUMENTS_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_NUM_ARGS", "goog.testing.ObjectPropertyString instantiated with \"{0}\" arguments, expected 2.");
    static final DiagnosticType QUALIFIED_NAME_EXPECTED_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_QUALIFIED_NAME_EXPECTED", "goog.testing.ObjectPropertyString instantiated with invalid argument, qualified name expected. Was \"{0}\".");
    static final DiagnosticType STRING_LITERAL_EXPECTED_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_STRING_LITERAL_EXPECTED", "goog.testing.ObjectPropertyString instantiated with invalid argument, string literal expected. Was \"{0}\".");
    private final AbstractCompiler compiler;

    ObjectPropertyStringPreprocess(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        ObjectPropertyStringPreprocess.addExternDeclaration(externs, IR.var(IR.name("JSCompiler_ObjectPropertyString")));
        NodeTraversal.traverseEs6(this.compiler, root, new Callback());
    }

    private static void addExternDeclaration(Node externs, Node declarationStmt) {
        Node script = externs.getLastChild();
        if (script == null || !script.isScript()) {
            script = IR.script();
            externs.addChildToBack(script);
        }
        script.addChildToBack(declarationStmt);
    }

    private class Callback
    extends NodeTraversal.AbstractPostOrderCallback {
        private Callback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.matchesQualifiedName(ObjectPropertyStringPreprocess.OBJECT_PROPERTY_STRING)) {
                Node newName = IR.name("JSCompiler_ObjectPropertyString");
                newName.useSourceInfoIfMissingFrom(n);
                parent.replaceChild(n, newName);
                t.reportCodeChange();
                return;
            }
            if (!n.isNew()) {
                return;
            }
            Node objectName = n.getFirstChild();
            if (!objectName.matchesQualifiedName("JSCompiler_ObjectPropertyString")) {
                return;
            }
            if (n.getChildCount() != 3) {
                ObjectPropertyStringPreprocess.this.compiler.report(t.makeError(n, INVALID_NUM_ARGUMENTS_ERROR, "" + n.getChildCount()));
                return;
            }
            Node firstArgument = objectName.getNext();
            if (!firstArgument.isQualifiedName()) {
                ObjectPropertyStringPreprocess.this.compiler.report(t.makeError(firstArgument, QUALIFIED_NAME_EXPECTED_ERROR, firstArgument.getToken().toString()));
                return;
            }
            Node secondArgument = firstArgument.getNext();
            if (!secondArgument.isString()) {
                ObjectPropertyStringPreprocess.this.compiler.report(t.makeError(secondArgument, STRING_LITERAL_EXPECTED_ERROR, secondArgument.getToken().toString()));
                return;
            }
            Node newFirstArgument = NodeUtil.newQName(ObjectPropertyStringPreprocess.this.compiler, ObjectPropertyStringPreprocess.this.compiler.getCodingConvention().getGlobalObject()).srcrefTree(firstArgument);
            Node newSecondArgument = NodeUtil.newQName(ObjectPropertyStringPreprocess.this.compiler, firstArgument.getQualifiedName() + "." + firstArgument.getNext().getString()).srcrefTree(secondArgument);
            n.replaceChild(firstArgument, newFirstArgument);
            n.replaceChild(secondArgument, newSecondArgument);
            t.reportCodeChange();
        }
    }
}

