/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.regex.Pattern;

class PeepholeSubstituteAlternateSyntax
extends AbstractPeepholeOptimization {
    private static final CodeGenerator REGEXP_ESCAPER = CodeGenerator.forCostEstimation(null);
    private final boolean late;
    private static final int STRING_SPLIT_OVERHEAD = ".split('.')".length();
    static final DiagnosticType INVALID_REGULAR_EXPRESSION_FLAGS = DiagnosticType.warning("JSC_INVALID_REGULAR_EXPRESSION_FLAGS", "Invalid flags to RegExp constructor: {0}");
    private static final ImmutableSet<String> BUILTIN_EXTERNS = ImmutableSet.of((Object)"Object", (Object)"Array", (Object)"Error", (Object)"RegExp", (Object)"Math");
    private static final ImmutableSet<String> STANDARD_OBJECT_CONSTRUCTORS = ImmutableSet.of((Object)"Object", (Object)"Array", (Object)"Error");
    private static final Pattern REGEXP_FLAGS_RE = Pattern.compile("^[gmi]*$");

    PeepholeSubstituteAlternateSyntax(boolean late) {
        this.late = late;
    }

    @Override
    public Node optimizeSubtree(Node node) {
        switch (node.getToken()) {
            case ASSIGN_SUB: {
                return this.reduceSubstractionAssignment(node);
            }
            case TRUE: 
            case FALSE: {
                return this.reduceTrueFalse(node);
            }
            case NEW: {
                node = this.tryFoldStandardConstructors(node);
                if (!node.isCall()) {
                    return node;
                }
            }
            case CALL: {
                Node result = this.tryFoldLiteralConstructor(node);
                if (result == node && (result = this.tryFoldSimpleFunctionCall(node)) == node) {
                    result = this.tryFoldImmediateCallToBoundFunction(node);
                }
                return result;
            }
            case RETURN: {
                return this.tryReduceReturn(node);
            }
            case COMMA: {
                return this.trySplitComma(node);
            }
            case NAME: {
                return this.tryReplaceUndefined(node);
            }
            case ARRAYLIT: {
                return this.tryMinimizeArrayLiteral(node);
            }
            case GETPROP: {
                return this.tryMinimizeWindowRefs(node);
            }
            case MUL: 
            case AND: 
            case OR: 
            case BITOR: 
            case BITXOR: 
            case BITAND: {
                return this.tryRotateAssociativeOperator(node);
            }
        }
        return node;
    }

    private Node tryMinimizeWindowRefs(Node node) {
        if (!this.isASTNormalized() || !this.areDeclaredGlobalExternsOnWindow()) {
            return node;
        }
        Preconditions.checkArgument((boolean)node.isGetProp());
        if (node.getFirstChild().isName()) {
            Node nameNode = node.getFirstChild();
            Node stringNode = node.getLastChild();
            if ("window".equals(nameNode.getString()) && BUILTIN_EXTERNS.contains((Object)stringNode.getString())) {
                Node newNameNode = IR.name(stringNode.getString());
                Node parentNode = node.getParent();
                newNameNode.useSourceInfoFrom(stringNode);
                parentNode.replaceChild(node, newNameNode);
                if (parentNode.isCall()) {
                    parentNode.putBooleanProp(50, true);
                }
                this.reportCodeChange();
                return newNameNode;
            }
        }
        return node;
    }

    private Node tryRotateAssociativeOperator(Node n) {
        if (!this.late) {
            return n;
        }
        Preconditions.checkArgument((boolean)NodeUtil.isAssociative(n.getToken()));
        Node rhs = n.getLastChild();
        if (n.getToken() == rhs.getToken()) {
            Node first = n.getFirstChild().detach();
            Node second = rhs.getFirstChild().detach();
            Node third = rhs.getLastChild().detach();
            Node newLhs = new Node(n.getToken(), first, second).useSourceInfoIfMissingFrom(n);
            Node newRoot = new Node(rhs.getToken(), newLhs, third).useSourceInfoIfMissingFrom(rhs);
            n.replaceWith(newRoot);
            this.reportCodeChange();
            return newRoot;
        }
        if (NodeUtil.isCommutative(n.getToken()) && !NodeUtil.mayHaveSideEffects(n)) {
            Node lhs = n.getFirstChild();
            while (lhs.getToken() == n.getToken()) {
                lhs = lhs.getFirstChild();
            }
            int precedence = NodeUtil.precedence(n.getToken());
            int lhsPrecedence = NodeUtil.precedence(lhs.getToken());
            int rhsPrecedence = NodeUtil.precedence(rhs.getToken());
            if (rhsPrecedence == precedence && lhsPrecedence != precedence) {
                n.removeChild(rhs);
                lhs.replaceWith(rhs);
                n.addChildToBack(lhs);
                this.reportCodeChange();
                return n;
            }
        }
        return n;
    }

    private Node tryFoldSimpleFunctionCall(Node n) {
        String targetName;
        Preconditions.checkState((boolean)n.isCall(), (Object)n);
        Node callTarget = n.getFirstChild();
        if (callTarget == null || !callTarget.isName()) {
            return n;
        }
        switch (targetName = callTarget.getString()) {
            case "Boolean": {
                int paramCount = n.getChildCount() - 1;
                if (paramCount != 1) break;
                Node value = n.getLastChild().detach();
                Node replacement = NodeUtil.isBooleanResult(value) ? value : IR.not(IR.not(value).srcref(n));
                n.replaceWith(replacement);
                this.reportCodeChange();
                break;
            }
            case "String": {
                Node value = callTarget.getNext();
                if (value == null || value.getNext() != null || !NodeUtil.isImmutableValue(value)) break;
                Node addition = IR.add(IR.string("").srcref(callTarget), value.detach());
                n.replaceWith(addition);
                this.reportCodeChange();
                return addition;
            }
        }
        return n;
    }

    private Node tryFoldImmediateCallToBoundFunction(Node n) {
        Preconditions.checkState((boolean)n.isCall());
        Node callTarget = n.getFirstChild();
        CodingConvention.Bind bind = this.getCodingConvention().describeFunctionBind(callTarget, false, false);
        if (bind != null) {
            bind.target.detach();
            n.replaceChild(callTarget, bind.target);
            callTarget = bind.target;
            PeepholeSubstituteAlternateSyntax.addParameterAfter(bind.parameters, callTarget);
            if (bind.thisValue != null && !NodeUtil.isUndefined(bind.thisValue)) {
                Node newCallTarget = IR.getprop(callTarget.cloneTree(), IR.string("call").srcref(callTarget));
                NodeUtil.markNewScopesChanged(newCallTarget, this.compiler);
                n.replaceChild(callTarget, newCallTarget);
                NodeUtil.markFunctionsDeleted(callTarget, this.compiler);
                n.addChildAfter(bind.thisValue.cloneTree(), newCallTarget);
                n.putBooleanProp(50, false);
            } else {
                n.putBooleanProp(50, true);
            }
            this.reportCodeChange();
        }
        return n;
    }

    private static void addParameterAfter(Node parameterList, Node after) {
        if (parameterList != null) {
            PeepholeSubstituteAlternateSyntax.addParameterAfter(parameterList.getNext(), after);
            after.getParent().addChildAfter(parameterList.cloneTree(), after);
        }
    }

    private Node trySplitComma(Node n) {
        if (this.late) {
            return n;
        }
        Node parent = n.getParent();
        Node left = n.getFirstChild();
        Node right = n.getLastChild();
        if (parent.isExprResult() && !parent.getParent().isLabel()) {
            n.detachChildren();
            parent.replaceChild(n, left);
            Node newStatement = IR.exprResult(right);
            newStatement.useSourceInfoIfMissingFrom(n);
            parent.getParent().addChildAfter(newStatement, parent);
            this.reportCodeChange();
            return left;
        }
        return n;
    }

    private Node tryReplaceUndefined(Node n) {
        if (this.isASTNormalized() && NodeUtil.isUndefined(n) && !NodeUtil.isLValue(n)) {
            Node replacement = NodeUtil.newUndefinedNode(n);
            n.replaceWith(replacement);
            this.reportCodeChange();
            return replacement;
        }
        return n;
    }

    private Node tryReduceReturn(Node n) {
        Node result = n.getFirstChild();
        if (result != null) {
            switch (result.getToken()) {
                case VOID: {
                    Node operand = result.getFirstChild();
                    if (this.mayHaveSideEffects(operand)) break;
                    n.removeFirstChild();
                    this.reportCodeChange();
                    break;
                }
                case NAME: {
                    String name = result.getString();
                    if (!name.equals("undefined")) break;
                    n.removeFirstChild();
                    this.reportCodeChange();
                    break;
                }
            }
        }
        return n;
    }

    private Node tryFoldStandardConstructors(Node n) {
        Preconditions.checkState((boolean)n.isNew());
        if (this.canFoldStandardConstructors(n)) {
            n.setToken(Token.CALL);
            n.putBooleanProp(50, true);
            this.reportCodeChange();
        }
        return n;
    }

    private boolean canFoldStandardConstructors(Node n) {
        if (this.isASTNormalized() && n.getFirstChild().isName()) {
            String className = n.getFirstChild().getString();
            if (STANDARD_OBJECT_CONSTRUCTORS.contains((Object)className)) {
                return true;
            }
            if ("RegExp".equals(className) && (n.getSecondChild() == null || n.getSecondChild().isString())) {
                return true;
            }
        }
        return false;
    }

    private Node tryFoldLiteralConstructor(Node n) {
        Preconditions.checkArgument((n.isCall() || n.isNew() ? 1 : 0) != 0);
        Node constructorNameNode = n.getFirstChild();
        Node newLiteralNode = null;
        if (this.isASTNormalized() && constructorNameNode.isName()) {
            Node arg0;
            FoldArrayAction action;
            boolean constructorHasArgs;
            String className = constructorNameNode.getString();
            if ("RegExp".equals(className)) {
                return this.tryFoldRegularExpressionConstructor(n);
            }
            boolean bl = constructorHasArgs = constructorNameNode.getNext() != null;
            if ("Object".equals(className) && !constructorHasArgs) {
                newLiteralNode = IR.objectlit(new Node[0]);
            } else if ("Array".equals(className) && ((action = PeepholeSubstituteAlternateSyntax.isSafeToFoldArrayConstructor(arg0 = constructorNameNode.getNext())) == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS || action == FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS)) {
                newLiteralNode = IR.arraylit(new Node[0]);
                n.removeFirstChild();
                Node elements = n.removeChildren();
                if (action == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS) {
                    newLiteralNode.addChildrenToFront(elements);
                }
            }
            if (newLiteralNode != null) {
                n.replaceWith(newLiteralNode);
                this.reportCodeChange();
                return newLiteralNode;
            }
        }
        return n;
    }

    private static FoldArrayAction isSafeToFoldArrayConstructor(Node arg) {
        FoldArrayAction action = FoldArrayAction.NOT_SAFE_TO_FOLD;
        if (arg == null) {
            action = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
        } else if (arg.getNext() != null) {
            action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
        } else {
            switch (arg.getToken()) {
                case STRING: {
                    action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
                case NUMBER: {
                    if (arg.getDouble() != 0.0) break;
                    action = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
                    break;
                }
                case ARRAYLIT: {
                    action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
            }
        }
        return action;
    }

    private Node tryFoldRegularExpressionConstructor(Node n) {
        Node flags;
        Node parent = n.getParent();
        Node constructor = n.getFirstChild();
        Node pattern = constructor.getNext();
        Node node = flags = null != pattern ? pattern.getNext() : null;
        if (null == pattern || null != flags && null != flags.getNext()) {
            return n;
        }
        if (!(!pattern.isString() || "".equals(pattern.getString()) || null != flags && !flags.isString() || !this.isEcmaScript5OrGreater() && PeepholeSubstituteAlternateSyntax.containsUnicodeEscape(pattern.getString()))) {
            Node regexLiteral;
            pattern = PeepholeSubstituteAlternateSyntax.makeForwardSlashBracketSafe(pattern);
            if (null == flags || "".equals(flags.getString())) {
                regexLiteral = IR.regexp(pattern);
            } else {
                if (!PeepholeSubstituteAlternateSyntax.areValidRegexpFlags(flags.getString())) {
                    this.report(INVALID_REGULAR_EXPRESSION_FLAGS, flags);
                    return n;
                }
                if (!this.areSafeFlagsToFold(flags.getString())) {
                    return n;
                }
                n.removeChild(flags);
                regexLiteral = IR.regexp(pattern, flags);
            }
            parent.replaceChild(n, regexLiteral);
            this.reportCodeChange();
            return regexLiteral;
        }
        return n;
    }

    private Node reduceSubstractionAssignment(Node n) {
        Node right = n.getLastChild();
        if (right.isNumber()) {
            if (right.getDouble() == 1.0) {
                Node newNode = IR.dec(n.removeFirstChild(), false);
                n.replaceWith(newNode);
                this.reportCodeChange();
                return newNode;
            }
            if (right.getDouble() == -1.0) {
                Node newNode = IR.inc(n.removeFirstChild(), false);
                n.replaceWith(newNode);
                this.reportCodeChange();
                return newNode;
            }
        }
        return n;
    }

    private Node reduceTrueFalse(Node n) {
        if (this.late) {
            switch (n.getParent().getToken()) {
                case EQ: 
                case GT: 
                case GE: 
                case LE: 
                case LT: 
                case NE: {
                    Node number = IR.number(n.isTrue() ? 1.0 : 0.0);
                    n.getParent().replaceChild(n, number);
                    this.reportCodeChange();
                    return number;
                }
            }
            Node not = IR.not(IR.number(n.isTrue() ? 0.0 : 1.0));
            not.useSourceInfoIfMissingFromForTree(n);
            n.replaceWith(not);
            this.reportCodeChange();
            return not;
        }
        return n;
    }

    private Node tryMinimizeArrayLiteral(Node n) {
        boolean allStrings = true;
        for (Node cur = n.getFirstChild(); cur != null; cur = cur.getNext()) {
            if (cur.isString()) continue;
            allStrings = false;
        }
        if (allStrings) {
            return this.tryMinimizeStringArrayLiteral(n);
        }
        return n;
    }

    private Node tryMinimizeStringArrayLiteral(Node n) {
        if (!this.late) {
            return n;
        }
        int numElements = n.getChildCount();
        int saving = numElements * 2 - STRING_SPLIT_OVERHEAD;
        if (saving <= 0) {
            return n;
        }
        Object[] strings = new String[n.getChildCount()];
        int idx = 0;
        for (Node cur = n.getFirstChild(); cur != null; cur = cur.getNext()) {
            strings[idx++] = cur.getString();
        }
        String delimiter = PeepholeSubstituteAlternateSyntax.pickDelimiter((String[])strings);
        if (delimiter != null) {
            String template = Joiner.on((String)delimiter).join(strings);
            Node call = IR.call(IR.getprop(IR.string(template), IR.string("split")), IR.string("" + delimiter));
            call.useSourceInfoIfMissingFromForTree(n);
            n.replaceWith(call);
            this.reportCodeChange();
            return call;
        }
        return n;
    }

    private static String pickDelimiter(String[] strings) {
        boolean allLength1 = true;
        for (String s : strings) {
            if (s.length() == 1) continue;
            allLength1 = false;
            break;
        }
        if (allLength1) {
            return "";
        }
        String[] delimiters = new String[]{" ", ";", ",", "{", "}", null};
        int i = 0;
        block1: while (delimiters[i] != null) {
            for (String cur : strings) {
                if (!cur.contains(delimiters[i])) {
                    continue;
                }
                ++i;
                continue block1;
            }
        }
        return delimiters[i];
    }

    private static boolean areValidRegexpFlags(String flags) {
        return REGEXP_FLAGS_RE.matcher(flags).matches();
    }

    private boolean areSafeFlagsToFold(String flags) {
        return this.isEcmaScript5OrGreater() || flags.indexOf(103) < 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Node makeForwardSlashBracketSafe(Node n) {
        String s = n.getString();
        StringBuilder sb = null;
        int pos = 0;
        boolean isEscaped = false;
        boolean inCharset = false;
        block13: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    isEscaped = !isEscaped;
                    continue block13;
                }
                case '/': {
                    if (isEscaped || inCharset) break;
                    if (null == sb) {
                        sb = new StringBuilder(s.length() + 16);
                    }
                    sb.append(s, pos, i).append('\\');
                    pos = i;
                    break;
                }
                case '[': {
                    if (isEscaped) break;
                    inCharset = true;
                    break;
                }
                case ']': {
                    if (isEscaped) break;
                    inCharset = false;
                    break;
                }
                case '\n': 
                case '\r': 
                case '\u2028': 
                case '\u2029': {
                    if (null == sb) {
                        sb = new StringBuilder(s.length() + 16);
                    }
                    if (isEscaped) {
                        sb.append(s, pos, i - 1);
                    } else {
                        sb.append(s, pos, i);
                    }
                    switch (ch) {
                        case '\r': {
                            sb.append("\\r");
                            break;
                        }
                        case '\n': {
                            sb.append("\\n");
                            break;
                        }
                        case '\u2028': {
                            sb.append("\\u2028");
                            break;
                        }
                        case '\u2029': {
                            sb.append("\\u2029");
                            break;
                        }
                    }
                    pos = i + 1;
                }
            }
            isEscaped = false;
        }
        if (null == sb) {
            return n.cloneTree();
        }
        sb.append(s, pos, s.length());
        return IR.string(sb.toString()).srcref(n);
    }

    static boolean containsUnicodeEscape(String s) {
        String esc = REGEXP_ESCAPER.regexpEscape(s);
        int i = -1;
        while ((i = esc.indexOf("\\u", i + 1)) >= 0) {
            int nSlashes = 0;
            while (i - nSlashes > 0 && '\\' == esc.charAt(i - nSlashes - 1)) {
                ++nSlashes;
            }
            if (0 != (nSlashes & 1)) continue;
            return true;
        }
        return false;
    }

    private static enum FoldArrayAction {
        NOT_SAFE_TO_FOLD,
        SAFE_TO_FOLD_WITH_ARGS,
        SAFE_TO_FOLD_WITHOUT_ARGS;

    }
}

