/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceMap;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSymbolTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReferenceCollectingCallback
implements NodeTraversal.ScopedCallback,
HotSwapCompilerPass,
StaticSymbolTable<Var, Reference> {
    private final Map<Var, ReferenceCollection> referenceMap = new LinkedHashMap<Var, ReferenceCollection>();
    private List<BasicBlock> blockStack = new ArrayList<BasicBlock>();
    private final Behavior behavior;
    private final ScopeCreator scopeCreator;
    private final AbstractCompiler compiler;
    private final Predicate<Var> varFilter;
    private final Set<Var> startedFunctionTraverse = new HashSet<Var>();
    private final Set<Var> finishedFunctionTraverse = new HashSet<Var>();
    private Scope narrowScope;
    static final Behavior DO_NOTHING_BEHAVIOR = new Behavior(){

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceMap referenceMap) {
        }
    };

    public ReferenceCollectingCallback(AbstractCompiler compiler, Behavior behavior, ScopeCreator creator) {
        this(compiler, behavior, creator, (Predicate<Var>)Predicates.alwaysTrue());
    }

    ReferenceCollectingCallback(AbstractCompiler compiler, Behavior behavior, ScopeCreator creator, Predicate<Var> varFilter) {
        this.compiler = compiler;
        this.behavior = behavior;
        this.scopeCreator = creator;
        this.varFilter = varFilter;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal t = new NodeTraversal(this.compiler, this, this.scopeCreator);
        t.traverseRoots(externs, root);
    }

    public void process(Node root) {
        NodeTraversal t = new NodeTraversal(this.compiler, this, this.scopeCreator);
        t.traverse(root);
    }

    void processScope(Scope scope) {
        this.narrowScope = scope;
        new NodeTraversal(this.compiler, this, this.scopeCreator).traverseAtScope(scope);
        this.narrowScope = null;
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public Iterable<Var> getAllSymbols() {
        return this.referenceMap.keySet();
    }

    public Scope getScope(Var var) {
        return var.scope;
    }

    public ReferenceCollection getReferences(Var v) {
        return this.referenceMap.get(v);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Var v;
        if ((n.isName() || n.isStringKey() && !n.hasChildren()) && (v = t.getScope().getVar(n.getString())) != null) {
            if (this.varFilter.apply((Object)v)) {
                this.addReference(v, new Reference(n, t, ReferenceCollectingCallback.peek(this.blockStack)));
            }
            if (v.getParentNode() != null && NodeUtil.isHoistedFunctionDeclaration(v.getParentNode()) && (this.narrowScope == null || this.narrowScope.getDepth() <= v.getScope().getDepth())) {
                this.outOfBandTraversal(v);
            }
        }
        if (ReferenceCollectingCallback.isBlockBoundary(n, parent)) {
            ReferenceCollectingCallback.pop(this.blockStack);
        }
    }

    private void outOfBandTraversal(Var v) {
        if (this.startedFunctionTraverse.contains(v)) {
            return;
        }
        this.startedFunctionTraverse.add(v);
        Node fnNode = v.getParentNode();
        Preconditions.checkState((boolean)NodeUtil.isHoistedFunctionDeclaration(fnNode), (Object)fnNode);
        Scope containingScope = v.getScope();
        ArrayList<BasicBlock> newBlockStack = null;
        if (containingScope.isGlobal()) {
            newBlockStack = new ArrayList<BasicBlock>();
            newBlockStack.add(this.blockStack.get(0));
        } else {
            for (int i = 0; i < this.blockStack.size(); ++i) {
                if (this.blockStack.get(i).getRoot() != containingScope.getRootNode()) continue;
                newBlockStack = new ArrayList<BasicBlock>(this.blockStack.subList(0, i + 1));
            }
        }
        Preconditions.checkNotNull(newBlockStack);
        List<BasicBlock> oldBlockStack = this.blockStack;
        this.blockStack = newBlockStack;
        NodeTraversal outOfBandTraversal = new NodeTraversal(this.compiler, this, this.scopeCreator);
        outOfBandTraversal.traverseFunctionOutOfBand(fnNode, containingScope);
        this.blockStack = oldBlockStack;
        this.finishedFunctionTraverse.add(v);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        BasicBlock parent;
        Node n = t.getScopeRoot();
        BasicBlock basicBlock = parent = this.blockStack.isEmpty() ? null : ReferenceCollectingCallback.peek(this.blockStack);
        if (t.getScope().isHoistScope()) {
            this.blockStack.add(new BasicBlock(parent, n));
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (t.getScope().isHoistScope()) {
            ReferenceCollectingCallback.pop(this.blockStack);
        }
        if (t.inGlobalScope()) {
            this.compiler.updateGlobalVarReferences(this.referenceMap, t.getScopeRoot());
            this.behavior.afterExitScope(t, this.compiler.getGlobalVarReferences());
        } else {
            this.behavior.afterExitScope(t, new ReferenceMapWrapper(this.referenceMap));
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (NodeUtil.isHoistedFunctionDeclaration(n)) {
            Node nameNode = n.getFirstChild();
            Var functionVar = nodeTraversal.getScope().getVar(nameNode.getString());
            Preconditions.checkNotNull((Object)functionVar);
            if (this.finishedFunctionTraverse.contains(functionVar)) {
                return false;
            }
            this.startedFunctionTraverse.add(functionVar);
        }
        if (ReferenceCollectingCallback.isBlockBoundary(n, parent)) {
            this.blockStack.add(new BasicBlock(ReferenceCollectingCallback.peek(this.blockStack), n));
        }
        if ((n.isDefaultValue() || n.isDestructuringLhs()) && n.hasTwoChildren()) {
            Scope scope = nodeTraversal.getScope();
            nodeTraversal.traverseInnerNode(n.getSecondChild(), n, scope);
            nodeTraversal.traverseInnerNode(n.getFirstChild(), n, scope);
            return false;
        }
        return true;
    }

    private static <T> T pop(List<T> list) {
        return list.remove(list.size() - 1);
    }

    private static <T> T peek(List<T> list) {
        return (T)Iterables.getLast(list);
    }

    private static boolean isBlockBoundary(Node n, Node parent) {
        if (parent != null) {
            switch (parent.getToken()) {
                case DO: 
                case FOR: 
                case FOR_IN: 
                case FOR_OF: 
                case TRY: 
                case WHILE: 
                case WITH: 
                case CLASS: {
                    return true;
                }
                case AND: 
                case HOOK: 
                case IF: 
                case OR: 
                case SWITCH: {
                    return n != parent.getFirstChild();
                }
            }
        }
        return n.isCase();
    }

    private void addReference(Var v, Reference reference) {
        ReferenceCollection referenceInfo = this.referenceMap.get(v);
        if (referenceInfo == null) {
            referenceInfo = new ReferenceCollection();
            this.referenceMap.put(v, referenceInfo);
        }
        referenceInfo.add(reference);
    }

    public static interface Behavior {
        public void afterExitScope(NodeTraversal var1, ReferenceMap var2);
    }

    private static class ReferenceMapWrapper
    implements ReferenceMap {
        private final Map<Var, ReferenceCollection> referenceMap;

        public ReferenceMapWrapper(Map<Var, ReferenceCollection> referenceMap) {
            this.referenceMap = referenceMap;
        }

        @Override
        public ReferenceCollection getReferences(Var var) {
            return this.referenceMap.get(var);
        }
    }
}

