/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.rhino.TypeI;

public enum TypeMatchingStrategy {
    LOOSE(true, true, true),
    STRICT_NULLABILITY(true, false, true),
    SUBTYPES(true, false, false),
    EXACT(false, false, false);

    private final boolean allowSubtypes;
    private final boolean ignoreNullability;
    private final boolean allowLooseMatches;

    private TypeMatchingStrategy(boolean allowSubtypes, boolean ignoreNullability, boolean allowLooseMatches) {
        this.allowSubtypes = allowSubtypes;
        this.ignoreNullability = ignoreNullability;
        this.allowLooseMatches = allowLooseMatches;
    }

    public MatchResult match(TypeI templateType, TypeI type) {
        boolean voidableMismatch;
        if (templateType.isUnknownType()) {
            return new MatchResult(true, false);
        }
        if (type == null || type.isUnknownType() || type.isTop()) {
            return new MatchResult(this.allowLooseMatches, this.allowLooseMatches);
        }
        if (this.allowSubtypes) {
            if (this.ignoreNullability) {
                type = type.restrictByNotNullOrUndefined();
            }
            if (type.isSubtypeOf(templateType)) {
                return new MatchResult(true, false);
            }
        }
        boolean nullableMismatch = templateType.isNullable() != type.isNullable();
        boolean bl = voidableMismatch = templateType.isVoidable() != type.isVoidable();
        if (!this.ignoreNullability && (nullableMismatch || voidableMismatch)) {
            return new MatchResult(false, false);
        }
        return new MatchResult(type.isEquivalentTo(templateType), false);
    }

    public static class MatchResult {
        private final boolean isMatch;
        private final boolean isLooseMatch;

        public MatchResult(boolean isMatch, boolean isLooseMatch) {
            this.isMatch = isMatch;
            this.isLooseMatch = isLooseMatch;
        }

        public boolean isMatch() {
            return this.isMatch;
        }

        public boolean isLooseMatch() {
            return this.isLooseMatch;
        }
    }
}

