/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSDocInfoPrinter;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

class TypedCodeGenerator
extends CodeGenerator {
    private final TypeIRegistry registry;
    private final JSDocInfoPrinter jsDocInfoPrinter;

    TypedCodeGenerator(CodeConsumer consumer, CompilerOptions options, TypeIRegistry registry) {
        super(consumer, options);
        Preconditions.checkNotNull((Object)registry);
        this.registry = registry;
        this.jsDocInfoPrinter = new JSDocInfoPrinter(options.getUseOriginalNamesInOutput());
    }

    @Override
    protected void add(Node n, CodeGenerator.Context context) {
        Node parent = n.getParent();
        if (parent != null && (parent.isNormalBlock() || parent.isScript())) {
            if (n.isFunction()) {
                this.add(this.getFunctionAnnotation(n));
            } else if (n.isExprResult() && n.getFirstChild().isAssign()) {
                Node assign = n.getFirstChild();
                if (NodeUtil.isNamespaceDecl(assign.getFirstChild())) {
                    this.add(this.jsDocInfoPrinter.print(assign.getJSDocInfo()));
                } else {
                    Node rhs = assign.getLastChild();
                    this.add(this.getTypeAnnotation(rhs));
                }
            } else if (n.isVar() && n.getFirstFirstChild() != null) {
                if (NodeUtil.isNamespaceDecl(n.getFirstChild())) {
                    this.add(this.jsDocInfoPrinter.print(n.getJSDocInfo()));
                } else {
                    this.add(this.getTypeAnnotation(n.getFirstFirstChild()));
                }
            }
        }
        super.add(n, context);
    }

    private String getTypeAnnotation(Node node) {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(node);
        if (jsdoc == null && !node.isFunction()) {
            return "";
        }
        TypeI type = node.getTypeI();
        if (type == null) {
            return "";
        }
        if (type.isFunctionType()) {
            return this.getFunctionAnnotation(node);
        }
        if (type.isEnumObject()) {
            return "/** @enum {" + type.toMaybeObjectType().getEnumeratedTypeOfEnumObject().toNonNullAnnotationString() + "} */\n";
        }
        if (!(type.isUnknownType() || type.isBottom() || type.isVoidType() || type.isPrototypeObject())) {
            return "/** @type {" + node.getTypeI().toNonNullAnnotationString() + "} */\n";
        }
        return "";
    }

    private String getFunctionAnnotation(Node fnNode) {
        TypeI type = fnNode.getTypeI();
        Preconditions.checkState((fnNode.isFunction() || type.isFunctionType() ? 1 : 0) != 0);
        if (type == null || type.isUnknownType()) {
            return "";
        }
        FunctionTypeI funType = type.toMaybeFunctionType();
        if (type.equals(this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE))) {
            return "/** @type {!Function} */\n";
        }
        StringBuilder sb = new StringBuilder("/**\n");
        Node paramNode = null;
        if (fnNode != null && fnNode.isFunction()) {
            paramNode = NodeUtil.getFunctionParameters(fnNode).getFirstChild();
        }
        int minArity = funType.getMinArity();
        int maxArity = funType.getMaxArity();
        ImmutableList formals = ImmutableList.copyOf(funType.getParameterTypes());
        for (int i = 0; i < formals.size(); ++i) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "param", this.getParameterJSDocType((List<TypeI>)formals, i, minArity, maxArity));
            sb.append(" ").append(paramNode == null ? "p" + i : paramNode.getString()).append("\n");
            if (paramNode == null) continue;
            paramNode = paramNode.getNext();
        }
        TypeI retType = funType.getReturnType();
        if (!(retType == null || retType.isBottom() || funType.isInterface() || funType.isConstructor() && retType.isVoidType())) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "return", retType.toNonNullAnnotationString());
            sb.append("\n");
        }
        if (funType.isConstructor()) {
            this.appendConstructorAnnotations(sb, funType);
        } else if (funType.isInterface()) {
            this.appendInterfaceAnnotations(sb, funType);
        } else {
            TypeI thisType = funType.getTypeOfThis();
            if (!(thisType == null || thisType.isUnknownType() || thisType.isVoidType() || fnNode != null && thisType.equals(this.findMethodOwner(fnNode)))) {
                sb.append(" * ");
                TypedCodeGenerator.appendAnnotation(sb, "this", thisType.toNonNullAnnotationString());
                sb.append("\n");
            }
        }
        Collection<String> typeParams = funType.getTypeParameters();
        if (!typeParams.isEmpty()) {
            sb.append(" * @template ");
            Joiner.on((String)",").appendTo(sb, typeParams);
            sb.append("\n");
        }
        sb.append(" */\n");
        return sb.toString();
    }

    private void appendConstructorAnnotations(StringBuilder sb, FunctionTypeI funType) {
        ObjectTypeI superInstance;
        FunctionTypeI superConstructor = funType.getInstanceType().getSuperClassConstructor();
        if (superConstructor != null && !(superInstance = superConstructor.getInstanceType()).toString().equals("Object")) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "extends", superInstance.toAnnotationString());
            sb.append("\n");
        }
        TreeSet<String> interfaces = new TreeSet<String>();
        for (ObjectTypeI objectTypeI : funType.getAncestorInterfaces()) {
            interfaces.add(objectTypeI.toAnnotationString());
        }
        for (String string : interfaces) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "implements", string);
            sb.append("\n");
        }
        sb.append(" * @constructor\n");
    }

    private void appendInterfaceAnnotations(StringBuilder sb, FunctionTypeI funType) {
        TreeSet<String> interfaces = new TreeSet<String>();
        for (ObjectTypeI interfaceType : funType.getAncestorInterfaces()) {
            interfaces.add(interfaceType.toAnnotationString());
        }
        for (String interfaze : interfaces) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "extends", interfaze);
            sb.append("\n");
        }
        if (funType.isStructuralInterface()) {
            sb.append(" * @record\n");
        } else {
            sb.append(" * @interface\n");
        }
    }

    private ObjectTypeI findMethodOwner(Node n) {
        if (n == null) {
            return null;
        }
        Node parent = n.getParent();
        FunctionTypeI ctor = null;
        if (parent.isAssign()) {
            Node target = parent.getFirstChild();
            if (NodeUtil.isPrototypeProperty(target)) {
                Object type = this.registry.getType(target.getFirstFirstChild().getQualifiedName());
                ctor = type != null ? ((ObjectTypeI)type).getConstructor() : null;
            }
        } else if (parent.isClass()) {
            ctor = parent.getTypeI().toMaybeFunctionType();
        }
        return ctor != null ? ctor.getInstanceType() : null;
    }

    private static void appendAnnotation(StringBuilder sb, String name, String type) {
        sb.append("@").append(name).append(" {").append(type).append("}");
    }

    private String getParameterJSDocType(List<TypeI> types, int index, int minArgs, int maxArgs) {
        boolean isRestArgument;
        TypeI type = types.get(index);
        if (index < minArgs) {
            return type.toNonNullAnnotationString();
        }
        boolean bl = isRestArgument = maxArgs == Integer.MAX_VALUE && index == types.size() - 1;
        if (isRestArgument) {
            return "..." + this.restrictByUndefined(type).toNonNullAnnotationString();
        }
        return this.restrictByUndefined(type).toNonNullAnnotationString() + "=";
    }

    private TypeI restrictByUndefined(TypeI type) {
        if (!type.isVoidable()) {
            return type;
        }
        TypeI restricted = type.restrictByNotNullOrUndefined();
        if (type.isNullable()) {
            Object nullType = this.registry.getNativeType(JSTypeNative.NULL_TYPE);
            return this.registry.createUnionType((List<? extends TypeI>)ImmutableList.of((Object)restricted, nullType));
        }
        return restricted.isBottom() ? type : restricted;
    }
}

