/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

public class WhitespaceWrapGoogModules
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;

    WhitespaceWrapGoogModules(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        for (Node c = root.getFirstChild(); c != null; c = c.getNext()) {
            Preconditions.checkState((boolean)c.isScript());
            this.hotSwapScript(c, null);
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        if (!NodeUtil.isGoogModuleFile(scriptRoot)) {
            return;
        }
        Node moduleBody = scriptRoot.getFirstChild();
        moduleBody.setToken(Token.BLOCK);
        NodeUtil.tryMergeBlock(moduleBody);
        this.compiler.reportChangeToEnclosingScope(scriptRoot);
        Node block = IR.block();
        block.addChildToBack(IR.exprResult(IR.string("use strict")));
        Node function = IR.function(IR.name(""), IR.paramList(IR.name("exports")), block);
        this.compiler.reportChangeToChangeScope(function);
        Node loadMod = IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("loadModule")), function)).srcrefTree(scriptRoot);
        if (scriptRoot.hasChildren()) {
            block.addChildrenToBack(scriptRoot.removeChildren());
        }
        block.addChildToBack(IR.returnNode(IR.name("exports")).srcrefTree(scriptRoot));
        scriptRoot.addChildToBack(loadMod);
        this.compiler.reportChangeToChangeScope(scriptRoot);
    }
}

