/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.SubtypeCache;
import com.google.javascript.jscomp.newtypes.ToStringContext;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class Property
implements Serializable {
    private final Node defSite;
    private final JSType inferredType;
    private final JSType declaredType;
    private final Attribute attribute;

    private Property(Node defSite, JSType inferredType, JSType declaredType, Attribute attribute) {
        Preconditions.checkArgument((inferredType != null ? 1 : 0) != 0);
        this.defSite = defSite;
        this.inferredType = inferredType;
        this.declaredType = declaredType;
        this.attribute = attribute;
    }

    static Property make(JSType inferredType, JSType declaredType) {
        return new Property(null, inferredType, declaredType, Attribute.REQUIRED);
    }

    static Property makeWithDefsite(Node defSite, JSType inferredType, JSType declaredType) {
        return new Property(defSite, inferredType, declaredType, Attribute.REQUIRED);
    }

    static Property makeConstant(Node defSite, JSType inferredType, JSType declaredType) {
        return new Property(defSite, inferredType, declaredType, Attribute.CONSTANT);
    }

    static Property makeOptional(Node defSite, JSType inferredType, JSType declaredType) {
        return new Property(defSite, inferredType, declaredType, Attribute.OPTIONAL);
    }

    boolean isRequired() {
        return this.attribute == Attribute.REQUIRED;
    }

    boolean isOptional() {
        return this.attribute == Attribute.OPTIONAL;
    }

    boolean isConstant() {
        return this.attribute == Attribute.CONSTANT;
    }

    boolean isDeclared() {
        return this.declaredType != null;
    }

    JSType getType() {
        return this.inferredType;
    }

    Node getDefSite() {
        return this.defSite;
    }

    JSType getDeclaredType() {
        return this.declaredType;
    }

    Property withOptional() {
        return this.isOptional() ? this : new Property(this.defSite, this.inferredType, this.declaredType, Attribute.OPTIONAL);
    }

    Property withRequired() {
        return this.isRequired() ? this : new Property(this.defSite, this.inferredType, this.declaredType, Attribute.REQUIRED);
    }

    private static Attribute meetAttributes(Attribute a1, Attribute a2) {
        if (a1 == Attribute.CONSTANT || a2 == Attribute.CONSTANT) {
            return Attribute.CONSTANT;
        }
        if (a1 == Attribute.REQUIRED || a2 == Attribute.REQUIRED) {
            return Attribute.REQUIRED;
        }
        return Attribute.OPTIONAL;
    }

    private static Attribute joinAttributes(Attribute a1, Attribute a2) {
        if (a1 == Attribute.OPTIONAL || a2 == Attribute.OPTIONAL) {
            return Attribute.OPTIONAL;
        }
        if (a1 == Attribute.REQUIRED || a2 == Attribute.REQUIRED) {
            return Attribute.REQUIRED;
        }
        return Attribute.CONSTANT;
    }

    Property specialize(Property other) {
        return new Property(this.defSite, this.inferredType.specialize(other.inferredType), this.declaredType, Property.meetAttributes(this.attribute, other.attribute));
    }

    static Property meet(Property p1, Property p2) {
        return new Property(p1.defSite == p2.defSite ? p1.defSite : null, JSType.meet(p1.inferredType, p2.inferredType), null, Property.meetAttributes(p1.attribute, p2.attribute));
    }

    static Property join(Property p1, Property p2) {
        JSType p1decl = p1.declaredType;
        JSType p2decl = p2.declaredType;
        JSType declType = p1decl == null || p2decl == null ? null : (p1decl.equals(p2decl) ? p1decl : null);
        return new Property(p1.defSite == p2.defSite ? p1.defSite : null, JSType.join(p1.inferredType, p2.inferredType), declType, Property.joinAttributes(p1.attribute, p2.attribute));
    }

    static Property unifyUnknowns(Property p1, Property p2) {
        JSType unifiedDeclaredType = null;
        if (p1.declaredType != null && p2.declaredType != null && (unifiedDeclaredType = JSType.unifyUnknowns(p1.declaredType, p2.declaredType)) == null) {
            return null;
        }
        JSType unifiedInferredType = JSType.unifyUnknowns(p1.inferredType, p2.inferredType);
        if (unifiedInferredType == null) {
            return null;
        }
        return new Property(p1.defSite == p2.defSite ? p1.defSite : null, unifiedInferredType, unifiedDeclaredType, Property.meetAttributes(p1.attribute, p2.attribute));
    }

    boolean unifyWithSubtype(Property other, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        if (!this.inferredType.unifyWithSubtype(other.inferredType, typeParameters, typeMultimap, subSuperMap)) {
            return false;
        }
        return this.declaredType == null || other.declaredType == null || this.declaredType.unifyWithSubtype(other.declaredType, typeParameters, typeMultimap, subSuperMap);
    }

    Property substituteGenerics(Map<String, JSType> concreteTypes) {
        if (concreteTypes.isEmpty()) {
            return this;
        }
        return new Property(this.defSite, this.inferredType.substituteGenerics(concreteTypes), this.declaredType == null ? null : this.declaredType.substituteGenerics(concreteTypes), this.attribute);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(), ToStringContext.TO_STRING).toString();
    }

    public StringBuilder appendTo(StringBuilder builder, ToStringContext ctx) {
        switch (this.attribute) {
            case CONSTANT: {
                return this.inferredType.appendTo(builder, ctx).append('^');
            }
            case REQUIRED: {
                return this.inferredType.appendTo(builder, ctx);
            }
            case OPTIONAL: {
                return this.inferredType.appendTo(builder, ctx).append('=');
            }
        }
        throw new RuntimeException("Unknown Attribute value " + (Object)((Object)this.attribute));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Preconditions.checkArgument((boolean)(o instanceof Property));
        Property p2 = (Property)o;
        return this.inferredType.equals(p2.inferredType) && this.attribute == p2.attribute;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inferredType, this.attribute});
    }

    private static enum Attribute {
        CONSTANT,
        OPTIONAL,
        REQUIRED;

    }
}

