/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class RawNominalType
extends Namespace {
    private boolean isFrozen;
    private PersistentMap<String, Property> classProps = PersistentMap.create();
    private PersistentMap<String, Property> protoProps = PersistentMap.create();
    private PersistentMap<String, Property> randomProps = PersistentMap.create();
    private NominalType superclass = null;
    private transient Set<RawNominalType> subtypes = new LinkedHashSet<RawNominalType>();
    private ImmutableSet<NominalType> interfaces = null;
    private final Kind kind;
    private final boolean isAbstractClass;
    private ImmutableSet<String> allProps = null;
    private final NominalType wrappedAsNominal;
    private final JSType wrappedAsJSType;
    private final JSType wrappedAsNullableJSType;
    private final ImmutableList<String> typeParameters;
    private ObjectKind objectKind;
    private FunctionType ctorFn;
    private JSType protoObject;

    private RawNominalType(JSTypes commonTypes, Node defSite, String name, ImmutableList<String> typeParameters, Kind kind, ObjectKind objectKind, boolean isAbstract) {
        super(commonTypes, name, defSite);
        Preconditions.checkNotNull((Object)objectKind);
        Preconditions.checkState((boolean)RawNominalType.isValidDefsite(defSite), (String)"Invalid defsite %s", (Object)defSite);
        if (typeParameters == null) {
            typeParameters = ImmutableList.of();
        }
        this.typeParameters = typeParameters;
        this.kind = RawNominalType.isBuiltinHelper(name, "IObject", defSite) ? Kind.RECORD : kind;
        this.objectKind = RawNominalType.isBuiltinHelper(name, "IObject", defSite) ? ObjectKind.UNRESTRICTED : objectKind;
        this.isAbstractClass = isAbstract;
        this.wrappedAsNominal = new NominalType((ImmutableMap<String, JSType>)ImmutableMap.of(), this);
        ObjectType objInstance = RawNominalType.isBuiltinHelper(name, "Function", defSite) ? ObjectType.fromFunction(this.commonTypes.TOP_FUNCTION, this.wrappedAsNominal) : ObjectType.fromNominalType(this.wrappedAsNominal);
        this.wrappedAsJSType = JSType.fromObjectType(objInstance);
        this.wrappedAsNullableJSType = JSType.join(this.commonTypes.NULL, this.wrappedAsJSType);
    }

    private static boolean isValidDefsite(Node defSite) {
        if (defSite == null) {
            return false;
        }
        if (defSite.isFunction()) {
            return true;
        }
        Node parent = defSite.getParent();
        if (defSite.isCall()) {
            return parent.isName() || parent.isAssign();
        }
        if (defSite.isName()) {
            return parent.isVar() && !defSite.hasChildren();
        }
        if (defSite.isGetProp()) {
            return parent.isExprResult();
        }
        return false;
    }

    public static RawNominalType makeClass(JSTypes commonTypes, Node defSite, String name, ImmutableList<String> typeParameters, ObjectKind objKind, boolean isAbstract) {
        return new RawNominalType(commonTypes, defSite, name, typeParameters, Kind.CLASS, objKind, isAbstract);
    }

    public static RawNominalType makeNominalInterface(JSTypes commonTypes, Node defSite, String name, ImmutableList<String> typeParameters, ObjectKind objKind) {
        if (objKind == ObjectKind.DICT) {
            objKind = ObjectKind.UNRESTRICTED;
        }
        return new RawNominalType(commonTypes, defSite, name, typeParameters, Kind.INTERFACE, objKind, false);
    }

    public static RawNominalType makeStructuralInterface(JSTypes commonTypes, Node defSite, String name, ImmutableList<String> typeParameters, ObjectKind objKind) {
        if (objKind == ObjectKind.DICT) {
            objKind = ObjectKind.UNRESTRICTED;
        }
        return new RawNominalType(commonTypes, defSite, name, typeParameters, Kind.RECORD, objKind, false);
    }

    JSTypes getCommonTypes() {
        return this.commonTypes;
    }

    JSType getPrototypeObject() {
        Preconditions.checkState((boolean)this.isFrozen);
        return this.protoObject;
    }

    private static boolean isBuiltinHelper(String nameToCheck, String builtinName, Node defSite) {
        return defSite != null && defSite.isFromExterns() && nameToCheck.equals(builtinName);
    }

    boolean isBuiltinWithName(String s) {
        return RawNominalType.isBuiltinHelper(this.name, s, this.defSite);
    }

    public boolean isBuiltinObject() {
        return RawNominalType.isBuiltinHelper(this.name, "Object", this.defSite);
    }

    public boolean isClass() {
        return this.kind == Kind.CLASS;
    }

    public boolean isInterface() {
        return this.kind != Kind.CLASS;
    }

    boolean isStructuralInterface() {
        return this.kind == Kind.RECORD;
    }

    boolean isGeneric() {
        return !this.typeParameters.isEmpty();
    }

    public boolean isStruct() {
        Preconditions.checkState((this.isFrozen() || this.isClass() ? 1 : 0) != 0);
        return this.objectKind.isStruct();
    }

    public boolean isDict() {
        return this.objectKind.isDict();
    }

    public boolean isAbstractClass() {
        return this.isAbstractClass;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    ImmutableList<String> getTypeParameters() {
        return this.typeParameters;
    }

    ObjectKind getObjectKind() {
        return this.objectKind;
    }

    public FunctionType getConstructorFunction() {
        return this.ctorFn;
    }

    public void setCtorFunction(FunctionType ctorFn) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        this.ctorFn = ctorFn;
    }

    boolean hasAncestorClass(RawNominalType ancestor) {
        Preconditions.checkState((boolean)ancestor.isClass());
        if (this == ancestor) {
            return true;
        }
        if (this.superclass == null) {
            return false;
        }
        return this.superclass.hasAncestorClass(ancestor);
    }

    public boolean addSuperClass(NominalType superclass) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        Preconditions.checkState((this.superclass == null ? 1 : 0) != 0);
        if (superclass.hasAncestorClass(this)) {
            return false;
        }
        this.superclass = superclass;
        superclass.getRawNominalType().addSubtype(this);
        return true;
    }

    private void addSubtype(RawNominalType subtype) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        if (!this.isBuiltinObject()) {
            this.subtypes.add(subtype);
        }
    }

    Set<JSType> getSubtypesWithProperty(String pname) {
        if (this.mayHaveProp(pname)) {
            if (this.protoProps.containsKey(pname)) {
                return ImmutableSet.of((Object)this.protoObject);
            }
            return ImmutableSet.of((Object)this.getInstanceAsJSType());
        }
        HashSet<JSType> typesWithProp = new HashSet<JSType>();
        for (RawNominalType subtype : this.subtypes) {
            typesWithProp.addAll(subtype.getSubtypesWithProperty(pname));
        }
        return typesWithProp;
    }

    boolean isPropDefinedOnSubtype(String pname) {
        return !this.getSubtypesWithProperty(pname).isEmpty();
    }

    boolean hasAncestorInterface(RawNominalType ancestor) {
        Preconditions.checkState((boolean)ancestor.isInterface());
        if (this == ancestor) {
            return true;
        }
        if (this.interfaces == null) {
            return false;
        }
        for (NominalType superInter : this.interfaces) {
            if (!superInter.hasAncestorInterface(ancestor)) continue;
            return true;
        }
        return false;
    }

    boolean inheritsFromIObjectReflexive() {
        if (this.isBuiltinWithName("IObject")) {
            return true;
        }
        if (this.interfaces != null) {
            for (NominalType interf : this.interfaces) {
                if (!interf.inheritsFromIObjectReflexive()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean inheritsFromIObject() {
        return !this.isBuiltinWithName("IObject") && this.inheritsFromIObjectReflexive();
    }

    public boolean addInterfaces(ImmutableSet<NominalType> interfaces) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        Preconditions.checkState((this.interfaces == null ? 1 : 0) != 0);
        Preconditions.checkNotNull(interfaces);
        if (this.isInterface()) {
            for (NominalType interf : interfaces) {
                if (!interf.hasAncestorInterface(this)) continue;
                this.interfaces = ImmutableSet.of();
                return false;
            }
        }
        for (NominalType interf : interfaces) {
            if (interf.getRawNominalType().inheritsFromIObjectReflexive()) {
                this.objectKind = ObjectKind.UNRESTRICTED;
            }
            interf.getRawNominalType().addSubtype(this);
        }
        this.interfaces = interfaces;
        return true;
    }

    public NominalType getSuperClass() {
        return this.superclass;
    }

    public ImmutableSet<NominalType> getInterfaces() {
        return this.interfaces == null ? ImmutableSet.of() : this.interfaces;
    }

    Set<RawNominalType> getSubtypes() {
        return this.subtypes;
    }

    boolean isSubtypeOf(RawNominalType other) {
        if (this == other || other.isBuiltinObject()) {
            return true;
        }
        if (other.isInterface()) {
            for (NominalType i : this.getInterfaces()) {
                if (!i.isRawSubtypeOf(other.getAsNominalType())) continue;
                return true;
            }
        }
        return this.isClass() && this.superclass != null && this.superclass.isRawSubtypeOf(other.getAsNominalType());
    }

    Property getOwnProp(String pname) {
        Property p = (Property)this.classProps.get(pname);
        if (p != null) {
            return p;
        }
        p = (Property)this.randomProps.get(pname);
        if (p != null) {
            return p;
        }
        return (Property)this.protoProps.get(pname);
    }

    public JSType getProtoPropDeclaredType(String pname) {
        Property p;
        Node defSite;
        if (this.protoProps.containsKey(pname) && (defSite = (p = (Property)this.protoProps.get(pname)).getDefSite()) != null && defSite.isGetProp()) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
            JSType declType = p.getDeclaredType();
            if (!(declType == null || declType.isFunctionType() && jsdoc == null)) {
                return declType;
            }
        }
        return null;
    }

    public boolean hasAbstractMethod(String pname) {
        Property p = this.getPropFromClass(pname);
        JSType ptype = p == null ? null : p.getType();
        return ptype != null && ptype.isFunctionType() && ptype.getFunType().isAbstract();
    }

    private Property getPropFromClass(String pname) {
        Preconditions.checkState((boolean)this.isClass());
        Property p = this.getOwnProp(pname);
        if (p != null) {
            return p;
        }
        if (this.superclass != null && (p = this.superclass.getProp(pname)) != null) {
            return p;
        }
        return null;
    }

    private Property getPropFromInterface(String pname) {
        Preconditions.checkState((boolean)this.isInterface());
        Property p = this.getOwnProp(pname);
        if (p != null) {
            return p;
        }
        if (this.interfaces != null) {
            for (NominalType interf : this.interfaces) {
                p = interf.getProp(pname);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    Property getProp(String pname) {
        if (this.isInterface()) {
            return this.getPropFromInterface(pname);
        }
        return this.getPropFromClass(pname);
    }

    public boolean mayHaveOwnProp(String pname) {
        return this.getOwnProp(pname) != null;
    }

    public boolean mayHaveProp(String pname) {
        return this.getProp(pname) != null;
    }

    public JSType getInstancePropDeclaredType(String pname) {
        Property p = this.getProp(pname);
        if (p == null) {
            return null;
        }
        if (p.getDeclaredType() == null && this.superclass != null) {
            return this.superclass.getPropDeclaredType(pname);
        }
        return p.getDeclaredType();
    }

    public Set<String> getAllOwnProps() {
        LinkedHashSet<String> ownProps = new LinkedHashSet<String>();
        ownProps.addAll(this.classProps.keySet());
        ownProps.addAll(this.protoProps.keySet());
        return ownProps;
    }

    public Set<String> getAllOwnClassProps() {
        return this.classProps.keySet();
    }

    ImmutableSet<String> getAllPropsOfInterface() {
        if (!this.isFrozen) {
            return null;
        }
        if (this.isClass()) {
            Preconditions.checkState((boolean)this.name.equals("Object"));
            return this.getAllPropsOfClass();
        }
        if (this.allProps == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (this.interfaces != null) {
                for (NominalType interf : this.interfaces) {
                    builder.addAll(interf.getAllPropsOfInterface());
                }
            }
            this.allProps = builder.addAll(this.protoProps.keySet()).build();
        }
        return this.allProps;
    }

    ImmutableSet<String> getAllPropsOfClass() {
        Preconditions.checkState((boolean)this.isClass());
        Preconditions.checkState((boolean)this.isFrozen);
        if (this.allProps == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (this.superclass != null) {
                builder.addAll(this.superclass.getAllPropsOfClass());
            }
            this.allProps = builder.addAll(this.classProps.keySet()).addAll(this.protoProps.keySet()).build();
        }
        return this.allProps;
    }

    public void addPropertyWhichMayNotBeOnAllInstances(String pname, JSType type) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        if (this.classProps.containsKey(pname) || this.protoProps.containsKey(pname)) {
            return;
        }
        if (this.objectKind == ObjectKind.UNRESTRICTED) {
            this.randomProps = this.randomProps.with(pname, Property.make(type == null ? this.commonTypes.UNKNOWN : type, type));
        }
    }

    public void addClassProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = this.commonTypes.UNKNOWN;
        }
        this.classProps = this.classProps.with(pname, isConstant ? Property.makeConstant(defSite, type, type) : Property.makeWithDefsite(defSite, type, type));
        if (this.protoProps.containsKey(pname)) {
            this.addProtoProperty(pname, defSite, type, isConstant);
        }
        if (this.randomProps.containsKey(pname)) {
            this.randomProps = this.randomProps.without(pname);
        }
    }

    public void addUndeclaredClassProperty(String pname, JSType type, Node defSite) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        if (this.mayHaveProp(pname)) {
            return;
        }
        this.classProps = this.classProps.with(pname, Property.makeWithDefsite(defSite, type, null));
    }

    public void addProtoProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = this.commonTypes.UNKNOWN;
        }
        if (this.classProps.containsKey(pname) && ((Property)this.classProps.get(pname)).getDeclaredType() == null) {
            this.classProps = this.classProps.without(pname);
        }
        if (this.randomProps.containsKey(pname)) {
            this.randomProps = this.randomProps.without(pname);
        }
        if (defSite == null && this.protoProps.containsKey(pname)) {
            defSite = ((Property)this.protoProps.get(pname)).getDefSite();
        }
        Property newProp = isConstant ? Property.makeConstant(defSite, type, type) : (this.isStructuralInterface() && type != null && !type.isUnknown() && this.commonTypes.UNDEFINED.isSubtypeOf(type) ? Property.makeOptional(defSite, type, type) : Property.makeWithDefsite(defSite, type, type));
        this.protoProps = this.protoProps.with(pname, newProp);
    }

    public void addUndeclaredProtoProperty(String pname, Node defSite, JSType inferredType) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        Property existingProp = (Property)this.protoProps.get(pname);
        if (existingProp != null && existingProp.isDeclared()) {
            return;
        }
        if (existingProp != null) {
            inferredType = JSType.join(existingProp.getType(), inferredType);
        }
        this.protoProps = this.protoProps.with(pname, Property.makeWithDefsite(defSite, inferredType, null));
        if (this.randomProps.containsKey(pname)) {
            this.randomProps = this.randomProps.without(pname);
        }
    }

    public boolean hasCtorProp(String pname) {
        return super.hasProp(pname);
    }

    public void addCtorProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        super.addProperty(pname, defSite, type, isConstant);
    }

    public void addUndeclaredCtorProperty(String pname, Node defSite, JSType inferredType) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0);
        Property existingProp = this.getNsProp(pname);
        if (existingProp != null && !existingProp.isDeclared()) {
            inferredType = JSType.join(existingProp.getType(), inferredType);
        }
        super.addUndeclaredProperty(pname, defSite, inferredType, false);
    }

    public JSType getCtorPropDeclaredType(String pname) {
        return super.getPropDeclaredType(pname);
    }

    public void freeze() {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0, (String)"Raw type already frozen: %s", (Object)this.defSite);
        Preconditions.checkNotNull((Object)this.ctorFn, (String)"Null constructor function for raw type: %s", (Object)this.defSite);
        if (this.interfaces == null) {
            this.interfaces = ImmutableSet.of();
        }
        if (this.isInterface()) {
            for (Map.Entry entry : this.protoProps.entrySet()) {
                Property prop = (Property)entry.getValue();
                if (prop.isDeclared()) continue;
                this.protoProps = this.protoProps.with((String)entry.getKey(), Property.makeWithDefsite(prop.getDefSite(), this.commonTypes.UNKNOWN, this.commonTypes.UNKNOWN));
            }
        }
        for (String pname : this.randomProps.keySet()) {
            if (this.superclass != null && this.superclass.mayHaveProp(pname)) {
                this.randomProps = this.randomProps.without(pname);
                continue;
            }
            for (NominalType interf : this.interfaces) {
                if (!interf.mayHaveProp(pname)) continue;
                this.randomProps = this.randomProps.without(pname);
            }
        }
        NominalType protoNT = this.superclass;
        if (protoNT == null) {
            NominalType builtinObj;
            protoNT = builtinObj = (NominalType)Preconditions.checkNotNull((Object)this.commonTypes.getObjectType(), (Object)"Missing externs for the builtin Object type");
        }
        if (protoNT.isGeneric()) {
            protoNT = protoNT.instantiateGenericsWithUnknown();
        }
        JSType ctorJstype = this.commonTypes.fromFunctionType(this.ctorFn);
        this.protoObject = JSType.fromObjectType(ObjectType.makeObjectType(this.commonTypes, protoNT, this.protoProps.with("constructor", Property.make(ctorJstype, ctorJstype)), null, null, false, ObjectKind.UNRESTRICTED));
        this.addCtorProperty("prototype", null, this.protoObject, false);
        this.isFrozen = true;
    }

    StringBuilder appendTo(StringBuilder builder) {
        builder.append(this.name);
        return builder;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    protected JSType computeJSType() {
        Preconditions.checkState((boolean)this.isFrozen, (String)"Unexpected not-frozen type: %s", (Object)this);
        Preconditions.checkState((this.namespaceType == null ? 1 : 0) != 0);
        return JSType.fromObjectType(ObjectType.makeObjectType(this.commonTypes, this.commonTypes.getFunctionType(), null, this.ctorFn, this, this.ctorFn.isLoose(), ObjectKind.UNRESTRICTED));
    }

    public NominalType getAsNominalType() {
        return this.wrappedAsNominal;
    }

    public JSType getInstanceAsJSType() {
        return this.wrappedAsJSType;
    }

    public JSType getInstanceWithNullability(boolean includeNull) {
        return includeNull ? this.wrappedAsNullableJSType : this.wrappedAsJSType;
    }

    public void fixSubtypesAfterDeserialization() {
        if (this.superclass != null) {
            this.superclass.getRawNominalType().addSubtype(this);
        }
        for (NominalType superInterface : this.interfaces) {
            superInterface.getRawNominalType().addSubtype(this);
        }
    }

    public void unfreezeForDeserialization() {
        this.isFrozen = false;
    }

    public void refreezeAfterDeserialization() {
        this.isFrozen = true;
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.subtypes = new LinkedHashSet<RawNominalType>();
    }

    private static enum Kind {
        CLASS,
        INTERFACE,
        RECORD;

    }
}

