/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.TypeWithProperties;
import java.util.Collection;
import java.util.HashSet;

final class TypeWithPropertiesStatics {
    private TypeWithPropertiesStatics() {
    }

    static JSType getProp(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return null;
        }
        JSType ptype = null;
        for (TypeWithProperties t : types) {
            if (!t.mayHaveProp(qname)) continue;
            JSType tmp = t.getProp(qname);
            ptype = ptype == null ? tmp : JSType.join(ptype, tmp);
        }
        return ptype;
    }

    static JSType getDeclaredProp(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return null;
        }
        JSType ptype = null;
        for (TypeWithProperties t : types) {
            JSType declType;
            if (!t.mayHaveProp(qname) || (declType = t.getDeclaredProp(qname)) == null) continue;
            ptype = ptype == null ? declType : JSType.join(ptype, declType);
        }
        return ptype;
    }

    static Collection<JSType> getSubtypesWithProperty(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return ImmutableSet.of();
        }
        HashSet<JSType> typesWithProp = new HashSet<JSType>();
        for (TypeWithProperties t : types) {
            typesWithProp.addAll(t.getSubtypesWithProperty(qname));
        }
        return typesWithProp;
    }

    static boolean mayHaveProp(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return false;
        }
        for (TypeWithProperties t : types) {
            if (!t.mayHaveProp(qname)) continue;
            return true;
        }
        return false;
    }

    static boolean hasProp(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return false;
        }
        for (TypeWithProperties t : types) {
            if (t.hasProp(qname)) continue;
            return false;
        }
        return true;
    }

    static boolean hasConstantProp(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return false;
        }
        for (TypeWithProperties t : types) {
            if (!t.hasConstantProp(qname)) continue;
            return true;
        }
        return false;
    }
}

