/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.javascript.refactoring.CodeReplacement;
import com.google.javascript.refactoring.SuggestedFix;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ApplySuggestedFixes {
    private static final Ordering<CodeReplacement> ORDER_CODE_REPLACEMENTS = Ordering.natural().onResultOf((Function)new Function<CodeReplacement, Integer>(){

        public Integer apply(CodeReplacement replacement) {
            return replacement.getStartPosition();
        }
    }).compound((Comparator)Ordering.natural().onResultOf((Function)new Function<CodeReplacement, Integer>(){

        public Integer apply(CodeReplacement replacement) {
            return replacement.getLength();
        }
    })).compound((Comparator)Ordering.natural().onResultOf((Function)new Function<CodeReplacement, String>(){

        public String apply(CodeReplacement replacement) {
            return replacement.getSortKey();
        }
    }));

    public static void applySuggestedFixesToFiles(Iterable<SuggestedFix> fixes) throws IOException {
        HashSet filenames = new HashSet();
        for (SuggestedFix suggestedFix : fixes) {
            filenames.addAll(suggestedFix.getReplacements().keySet());
        }
        HashMap<String, String> filenameToCodeMap = new HashMap<String, String>();
        for (String filename : filenames) {
            filenameToCodeMap.put(filename, Files.asCharSource((File)new File(filename), (Charset)StandardCharsets.UTF_8).read());
        }
        Map<String, String> map = ApplySuggestedFixes.applySuggestedFixesToCode(fixes, filenameToCodeMap);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Files.asCharSink((File)new File(entry.getKey()), (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)entry.getValue());
        }
    }

    public static Map<String, String> applySuggestedFixesToCode(Iterable<SuggestedFix> fixes, Map<String, String> filenameToCodeMap) {
        ReplacementMap map = new ReplacementMap();
        for (SuggestedFix fix : fixes) {
            map.putIfNoOverlap(fix);
        }
        ImmutableMap.Builder newCodeMap = ImmutableMap.builder();
        for (Map.Entry<String, Set<CodeReplacement>> entry : map.entrySet()) {
            String filename = entry.getKey();
            if (!filenameToCodeMap.containsKey(filename)) {
                throw new IllegalArgumentException("filenameToCodeMap missing code for file: " + filename);
            }
            Set<CodeReplacement> replacements = entry.getValue();
            String newCode = ApplySuggestedFixes.applyCodeReplacements(replacements, filenameToCodeMap.get(filename));
            newCodeMap.put((Object)filename, (Object)newCode);
        }
        return newCodeMap.build();
    }

    public static String applyCodeReplacements(Iterable<CodeReplacement> replacements, String code) {
        List sortedReplacements = ORDER_CODE_REPLACEMENTS.sortedCopy(replacements);
        ApplySuggestedFixes.validateNoOverlaps(sortedReplacements);
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        for (CodeReplacement replacement : sortedReplacements) {
            sb.append(code, lastIndex, replacement.getStartPosition());
            sb.append(replacement.getNewContent());
            lastIndex = replacement.getEndPosition();
        }
        if (lastIndex <= code.length()) {
            sb.append(code, lastIndex, code.length());
        }
        return sb.toString();
    }

    private static void validateNoOverlaps(List<CodeReplacement> replacements) {
        Preconditions.checkState((boolean)ORDER_CODE_REPLACEMENTS.isOrdered(replacements));
        if (ApplySuggestedFixes.containsOverlaps(replacements)) {
            throw new IllegalArgumentException("Found overlap between code replacements!\n" + Joiner.on((String)"\n\n").join(replacements));
        }
    }

    private static boolean containsOverlaps(List<CodeReplacement> replacements) {
        Preconditions.checkState((boolean)ORDER_CODE_REPLACEMENTS.isOrdered(replacements));
        int start = -1;
        for (CodeReplacement replacement : replacements) {
            if (replacement.getStartPosition() < start) {
                return true;
            }
            start = Math.max(start, replacement.getEndPosition());
        }
        return false;
    }

    private ApplySuggestedFixes() {
    }

    private static class ReplacementMap {
        private final SetMultimap<String, CodeReplacement> map = HashMultimap.create();

        ReplacementMap() {
        }

        void putIfNoOverlap(SuggestedFix fix) {
            if (this.canPut(fix)) {
                this.map.putAll(fix.getReplacements());
            }
        }

        private boolean canPut(SuggestedFix fix) {
            for (String filename : fix.getReplacements().keySet()) {
                List replacements = new ArrayList(this.map.get((Object)filename));
                replacements.addAll(fix.getReplacements().get((Object)filename));
                replacements = ORDER_CODE_REPLACEMENTS.sortedCopy(replacements);
                if (!ApplySuggestedFixes.containsOverlaps(replacements)) continue;
                return false;
            }
            return true;
        }

        Set<Map.Entry<String, Set<CodeReplacement>>> entrySet() {
            return Multimaps.asMap(this.map).entrySet();
        }
    }
}

