/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.base.Preconditions;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.List;

public class IR {
    private IR() {
    }

    public static Node empty() {
        return new Node(Token.EMPTY);
    }

    public static Node importNode(Node name, Node importSpecs, Node moduleIdentifier) {
        Preconditions.checkState((name.isName() || name.isEmpty() ? 1 : 0) != 0, (Object)name);
        Preconditions.checkState((importSpecs.isImportSpec() || importSpecs.isImportStar() || importSpecs.isEmpty() ? 1 : 0) != 0, (Object)importSpecs);
        Preconditions.checkState((boolean)moduleIdentifier.isString(), (Object)moduleIdentifier);
        return new Node(Token.IMPORT, name, importSpecs, moduleIdentifier);
    }

    public static Node importStar(String name) {
        return Node.newString(Token.IMPORT_STAR, name);
    }

    public static Node function(Node name, Node params, Node body) {
        Preconditions.checkState((boolean)name.isName());
        Preconditions.checkState((boolean)params.isParamList());
        Preconditions.checkState((boolean)body.isNormalBlock());
        return new Node(Token.FUNCTION, name, params, body);
    }

    public static Node arrowFunction(Node name, Node params, Node body) {
        Preconditions.checkState((boolean)name.isName());
        Preconditions.checkState((boolean)params.isParamList());
        Preconditions.checkState((body.isNormalBlock() || IR.mayBeExpression(body) ? 1 : 0) != 0);
        Node func = new Node(Token.FUNCTION, name, params, body);
        func.setIsArrowFunction(true);
        return func;
    }

    public static Node paramList() {
        return new Node(Token.PARAM_LIST);
    }

    public static Node paramList(Node param) {
        Preconditions.checkState((param.isName() || param.isRest() ? 1 : 0) != 0);
        return new Node(Token.PARAM_LIST, param);
    }

    public static Node paramList(Node ... params) {
        Node paramList = IR.paramList();
        for (Node param : params) {
            Preconditions.checkState((param.isName() || param.isRest() ? 1 : 0) != 0);
            paramList.addChildToBack(param);
        }
        return paramList;
    }

    public static Node root(Node ... rootChildren) {
        Node root = new Node(Token.ROOT);
        for (Node child : rootChildren) {
            Preconditions.checkState((child.getToken() == Token.ROOT || child.getToken() == Token.SCRIPT ? 1 : 0) != 0);
            root.addChildToBack(child);
        }
        return root;
    }

    public static Node block() {
        Node block = new Node(Token.BLOCK);
        return block;
    }

    public static Node block(Node stmt) {
        Preconditions.checkState((boolean)IR.mayBeStatement(stmt));
        Node block = new Node(Token.BLOCK, stmt);
        return block;
    }

    public static Node block(Node ... stmts) {
        Node block = IR.block();
        for (Node stmt : stmts) {
            Preconditions.checkState((boolean)IR.mayBeStatement(stmt));
            block.addChildToBack(stmt);
        }
        return block;
    }

    public static Node block(List<Node> stmts) {
        Node paramList = IR.block();
        for (Node stmt : stmts) {
            Preconditions.checkState((boolean)IR.mayBeStatement(stmt));
            paramList.addChildToBack(stmt);
        }
        return paramList;
    }

    private static Node blockUnchecked(Node stmt) {
        return new Node(Token.BLOCK, stmt);
    }

    public static Node script() {
        Node block = new Node(Token.SCRIPT);
        return block;
    }

    public static Node script(Node ... stmts) {
        Node block = IR.script();
        for (Node stmt : stmts) {
            Preconditions.checkState((boolean)IR.mayBeStatementNoReturn(stmt));
            block.addChildToBack(stmt);
        }
        return block;
    }

    public static Node script(List<Node> stmts) {
        Node paramList = IR.script();
        for (Node stmt : stmts) {
            Preconditions.checkState((boolean)IR.mayBeStatementNoReturn(stmt));
            paramList.addChildToBack(stmt);
        }
        return paramList;
    }

    public static Node var(Node lhs, Node value) {
        return IR.declaration(lhs, value, Token.VAR);
    }

    public static Node let(Node lhs, Node value) {
        return IR.declaration(lhs, value, Token.LET);
    }

    public static Node constNode(Node lhs, Node value) {
        return IR.declaration(lhs, value, Token.CONST);
    }

    public static Node var(Node lhs) {
        return IR.declaration(lhs, Token.VAR);
    }

    public static Node declaration(Node lhs, Token type) {
        Preconditions.checkState((lhs.isName() || lhs.isDestructuringPattern() || lhs.isDestructuringLhs() ? 1 : 0) != 0, (Object)lhs);
        if (lhs.isDestructuringPattern()) {
            lhs = new Node(Token.DESTRUCTURING_LHS, lhs);
        }
        return new Node(type, lhs);
    }

    public static Node declaration(Node lhs, Node value, Token type) {
        if (lhs.isName()) {
            Preconditions.checkState((!lhs.hasChildren() ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((lhs.isArrayPattern() || lhs.isObjectPattern() ? 1 : 0) != 0);
            lhs = new Node(Token.DESTRUCTURING_LHS, lhs);
        }
        Preconditions.checkState((boolean)IR.mayBeExpression(value), (String)"%s can't be an expression", (Object)value);
        lhs.addChildToBack(value);
        return new Node(type, lhs);
    }

    public static Node returnNode() {
        return new Node(Token.RETURN);
    }

    public static Node returnNode(Node expr) {
        Preconditions.checkState((boolean)IR.mayBeExpression(expr));
        return new Node(Token.RETURN, expr);
    }

    public static Node yield() {
        return new Node(Token.YIELD);
    }

    public static Node await(Node expr) {
        Preconditions.checkState((boolean)IR.mayBeExpression(expr));
        return new Node(Token.AWAIT, expr);
    }

    public static Node yield(Node expr) {
        Preconditions.checkState((boolean)IR.mayBeExpression(expr));
        return new Node(Token.YIELD, expr);
    }

    public static Node throwNode(Node expr) {
        Preconditions.checkState((boolean)IR.mayBeExpression(expr));
        return new Node(Token.THROW, expr);
    }

    public static Node exprResult(Node expr) {
        Preconditions.checkState((boolean)IR.mayBeExpression(expr), (Object)expr);
        return new Node(Token.EXPR_RESULT, expr);
    }

    public static Node ifNode(Node cond, Node then) {
        Preconditions.checkState((boolean)IR.mayBeExpression(cond));
        Preconditions.checkState((boolean)then.isNormalBlock());
        return new Node(Token.IF, cond, then);
    }

    public static Node ifNode(Node cond, Node then, Node elseNode) {
        Preconditions.checkState((boolean)IR.mayBeExpression(cond));
        Preconditions.checkState((boolean)then.isNormalBlock());
        Preconditions.checkState((boolean)elseNode.isNormalBlock());
        return new Node(Token.IF, cond, then, elseNode);
    }

    public static Node doNode(Node body, Node cond) {
        Preconditions.checkState((boolean)body.isNormalBlock());
        Preconditions.checkState((boolean)IR.mayBeExpression(cond));
        return new Node(Token.DO, body, cond);
    }

    public static Node whileNode(Node cond, Node body) {
        Preconditions.checkState((boolean)body.isNormalBlock());
        Preconditions.checkState((boolean)IR.mayBeExpression(cond));
        return new Node(Token.WHILE, cond, body);
    }

    public static Node forIn(Node target, Node cond, Node body) {
        Preconditions.checkState((target.isVar() || IR.mayBeExpression(target) ? 1 : 0) != 0);
        Preconditions.checkState((boolean)IR.mayBeExpression(cond));
        Preconditions.checkState((boolean)body.isNormalBlock());
        return new Node(Token.FOR_IN, target, cond, body);
    }

    public static Node forNode(Node init, Node cond, Node incr, Node body) {
        Preconditions.checkState((init.isVar() || IR.mayBeExpressionOrEmpty(init) ? 1 : 0) != 0);
        Preconditions.checkState((boolean)IR.mayBeExpressionOrEmpty(cond));
        Preconditions.checkState((boolean)IR.mayBeExpressionOrEmpty(incr));
        Preconditions.checkState((boolean)body.isNormalBlock());
        return new Node(Token.FOR, init, cond, incr, body);
    }

    public static Node switchNode(Node cond, Node ... cases) {
        Preconditions.checkState((boolean)IR.mayBeExpression(cond));
        Node switchNode = new Node(Token.SWITCH, cond);
        for (Node caseNode : cases) {
            Preconditions.checkState((caseNode.isCase() || caseNode.isDefaultCase() ? 1 : 0) != 0);
            switchNode.addChildToBack(caseNode);
        }
        return switchNode;
    }

    public static Node caseNode(Node expr, Node body) {
        Preconditions.checkState((boolean)IR.mayBeExpression(expr));
        Preconditions.checkState((boolean)body.isNormalBlock());
        body.setIsAddedBlock(true);
        return new Node(Token.CASE, expr, body);
    }

    public static Node defaultCase(Node body) {
        Preconditions.checkState((boolean)body.isNormalBlock());
        body.setIsAddedBlock(true);
        return new Node(Token.DEFAULT_CASE, body);
    }

    public static Node label(Node name, Node stmt) {
        Preconditions.checkState((boolean)name.isLabelName());
        Preconditions.checkState((boolean)IR.mayBeStatement(stmt));
        Node block = new Node(Token.LABEL, name, stmt);
        return block;
    }

    public static Node labelName(String name) {
        Preconditions.checkState((!name.isEmpty() ? 1 : 0) != 0);
        return Node.newString(Token.LABEL_NAME, name);
    }

    public static Node tryFinally(Node tryBody, Node finallyBody) {
        Preconditions.checkState((boolean)tryBody.isNormalBlock());
        Preconditions.checkState((boolean)finallyBody.isNormalBlock());
        Node catchBody = IR.block().useSourceInfoIfMissingFrom(tryBody);
        return new Node(Token.TRY, tryBody, catchBody, finallyBody);
    }

    public static Node tryCatch(Node tryBody, Node catchNode) {
        Preconditions.checkState((boolean)tryBody.isNormalBlock());
        Preconditions.checkState((boolean)catchNode.isCatch());
        Node catchBody = IR.blockUnchecked(catchNode).useSourceInfoIfMissingFrom(catchNode);
        return new Node(Token.TRY, tryBody, catchBody);
    }

    public static Node tryCatchFinally(Node tryBody, Node catchNode, Node finallyBody) {
        Preconditions.checkState((boolean)finallyBody.isNormalBlock());
        Node tryNode = IR.tryCatch(tryBody, catchNode);
        tryNode.addChildToBack(finallyBody);
        return tryNode;
    }

    public static Node catchNode(Node expr, Node body) {
        Preconditions.checkState((boolean)expr.isName());
        Preconditions.checkState((boolean)body.isNormalBlock());
        return new Node(Token.CATCH, expr, body);
    }

    public static Node breakNode() {
        return new Node(Token.BREAK);
    }

    public static Node breakNode(Node name) {
        Preconditions.checkState((boolean)name.isLabelName());
        return new Node(Token.BREAK, name);
    }

    public static Node continueNode() {
        return new Node(Token.CONTINUE);
    }

    public static Node continueNode(Node name) {
        Preconditions.checkState((boolean)name.isLabelName());
        return new Node(Token.CONTINUE, name);
    }

    public static Node call(Node target, Node ... args) {
        Node call = new Node(Token.CALL, target);
        for (Node arg : args) {
            Preconditions.checkState((boolean)IR.mayBeExpression(arg), (Object)arg);
            call.addChildToBack(arg);
        }
        return call;
    }

    public static Node newNode(Node target, Node ... args) {
        Node newcall = new Node(Token.NEW, target);
        for (Node arg : args) {
            Preconditions.checkState((boolean)IR.mayBeExpression(arg));
            newcall.addChildToBack(arg);
        }
        return newcall;
    }

    public static Node name(String name) {
        Preconditions.checkState((name.indexOf(46) == -1 ? 1 : 0) != 0, (String)"Invalid name '%s'. Did you mean to use NodeUtil.newQName?", (Object)name);
        return Node.newString(Token.NAME, name);
    }

    public static Node getprop(Node target, Node prop) {
        Preconditions.checkState((boolean)IR.mayBeExpression(target));
        Preconditions.checkState((boolean)prop.isString());
        return new Node(Token.GETPROP, target, prop);
    }

    public static Node getprop(Node target, Node prop, Node ... moreProps) {
        Preconditions.checkState((boolean)IR.mayBeExpression(target));
        Preconditions.checkState((boolean)prop.isString());
        Node result = new Node(Token.GETPROP, target, prop);
        for (Node moreProp : moreProps) {
            Preconditions.checkState((boolean)moreProp.isString());
            result = new Node(Token.GETPROP, result, moreProp);
        }
        return result;
    }

    public static Node getprop(Node target, String prop, String ... moreProps) {
        Preconditions.checkState((boolean)IR.mayBeExpression(target));
        Node result = new Node(Token.GETPROP, target, IR.string(prop));
        for (String moreProp : moreProps) {
            result = new Node(Token.GETPROP, result, IR.string(moreProp));
        }
        return result;
    }

    public static Node getelem(Node target, Node elem) {
        Preconditions.checkState((boolean)IR.mayBeExpression(target));
        Preconditions.checkState((boolean)IR.mayBeExpression(elem));
        return new Node(Token.GETELEM, target, elem);
    }

    public static Node assign(Node target, Node expr) {
        Preconditions.checkState((boolean)target.isValidAssignmentTarget(), (Object)target);
        Preconditions.checkState((boolean)IR.mayBeExpression(expr), (Object)expr);
        return new Node(Token.ASSIGN, target, expr);
    }

    public static Node hook(Node cond, Node trueval, Node falseval) {
        Preconditions.checkState((boolean)IR.mayBeExpression(cond));
        Preconditions.checkState((boolean)IR.mayBeExpression(trueval));
        Preconditions.checkState((boolean)IR.mayBeExpression(falseval));
        return new Node(Token.HOOK, cond, trueval, falseval);
    }

    public static Node in(Node expr1, Node expr2) {
        return IR.binaryOp(Token.IN, expr1, expr2);
    }

    public static Node comma(Node expr1, Node expr2) {
        return IR.binaryOp(Token.COMMA, expr1, expr2);
    }

    public static Node and(Node expr1, Node expr2) {
        return IR.binaryOp(Token.AND, expr1, expr2);
    }

    public static Node or(Node expr1, Node expr2) {
        return IR.binaryOp(Token.OR, expr1, expr2);
    }

    public static Node not(Node expr1) {
        return IR.unaryOp(Token.NOT, expr1);
    }

    public static Node lt(Node expr1, Node expr2) {
        return IR.binaryOp(Token.LT, expr1, expr2);
    }

    public static Node eq(Node expr1, Node expr2) {
        return IR.binaryOp(Token.EQ, expr1, expr2);
    }

    public static Node ne(Node expr1, Node expr2) {
        return IR.binaryOp(Token.NE, expr1, expr2);
    }

    public static Node sheq(Node expr1, Node expr2) {
        return IR.binaryOp(Token.SHEQ, expr1, expr2);
    }

    public static Node shne(Node expr1, Node expr2) {
        return IR.binaryOp(Token.SHNE, expr1, expr2);
    }

    public static Node voidNode(Node expr1) {
        return IR.unaryOp(Token.VOID, expr1);
    }

    public static Node neg(Node expr1) {
        return IR.unaryOp(Token.NEG, expr1);
    }

    public static Node pos(Node expr1) {
        return IR.unaryOp(Token.POS, expr1);
    }

    public static Node cast(Node expr1, JSDocInfo jsdoc) {
        Node op = IR.unaryOp(Token.CAST, expr1);
        op.setJSDocInfo(jsdoc);
        return op;
    }

    public static Node inc(Node exp, boolean isPost) {
        Node op = IR.unaryOp(Token.INC, exp);
        op.putBooleanProp(32, isPost);
        return op;
    }

    public static Node dec(Node exp, boolean isPost) {
        Node op = IR.unaryOp(Token.DEC, exp);
        op.putBooleanProp(32, isPost);
        return op;
    }

    public static Node add(Node expr1, Node expr2) {
        return IR.binaryOp(Token.ADD, expr1, expr2);
    }

    public static Node sub(Node expr1, Node expr2) {
        return IR.binaryOp(Token.SUB, expr1, expr2);
    }

    public static Node objectlit(Node ... propdefs) {
        Node objectlit = new Node(Token.OBJECTLIT);
        for (Node propdef : propdefs) {
            Preconditions.checkState((propdef.isStringKey() || propdef.isMemberFunctionDef() || propdef.isGetterDef() || propdef.isSetterDef() ? 1 : 0) != 0);
            if (!propdef.isStringKey()) {
                Preconditions.checkState((boolean)propdef.hasOneChild());
            }
            objectlit.addChildToBack(propdef);
        }
        return objectlit;
    }

    public static Node computedProp(Node key, Node value) {
        Preconditions.checkState((boolean)IR.mayBeExpression(key), (Object)key);
        Preconditions.checkState((boolean)IR.mayBeExpression(value), (Object)value);
        return new Node(Token.COMPUTED_PROP, key, value);
    }

    public static Node propdef(Node string, Node value) {
        Preconditions.checkState((boolean)string.isStringKey());
        Preconditions.checkState((!string.hasChildren() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)IR.mayBeExpression(value));
        string.addChildToFront(value);
        return string;
    }

    public static Node arraylit(Node ... exprs) {
        Node arraylit = new Node(Token.ARRAYLIT);
        for (Node expr : exprs) {
            Preconditions.checkState((boolean)IR.mayBeExpressionOrEmpty(expr));
            arraylit.addChildToBack(expr);
        }
        return arraylit;
    }

    public static Node regexp(Node expr) {
        Preconditions.checkState((boolean)expr.isString());
        return new Node(Token.REGEXP, expr);
    }

    public static Node regexp(Node expr, Node flags) {
        Preconditions.checkState((boolean)expr.isString());
        Preconditions.checkState((boolean)flags.isString());
        return new Node(Token.REGEXP, expr, flags);
    }

    public static Node string(String s) {
        return Node.newString(s);
    }

    public static Node stringKey(String s) {
        return Node.newString(Token.STRING_KEY, s);
    }

    public static Node stringKey(String s, Node value) {
        Preconditions.checkState((boolean)IR.mayBeExpression(value));
        Node stringKey = IR.stringKey(s);
        stringKey.addChildToFront(value);
        return stringKey;
    }

    public static Node rest(String name) {
        return new Node(Token.REST, IR.name(name));
    }

    public static Node spread(Node expr) {
        Preconditions.checkState((boolean)IR.mayBeExpression(expr));
        return new Node(Token.SPREAD, expr);
    }

    public static Node superNode() {
        return new Node(Token.SUPER);
    }

    public static Node memberFunctionDef(String name, Node function) {
        Preconditions.checkState((boolean)function.isFunction());
        Node member = Node.newString(Token.MEMBER_FUNCTION_DEF, name);
        member.addChildToBack(function);
        return member;
    }

    public static Node number(double d) {
        return Node.newNumber(d);
    }

    public static Node thisNode() {
        return new Node(Token.THIS);
    }

    public static Node trueNode() {
        return new Node(Token.TRUE);
    }

    public static Node falseNode() {
        return new Node(Token.FALSE);
    }

    public static Node nullNode() {
        return new Node(Token.NULL);
    }

    private static Node binaryOp(Token token, Node expr1, Node expr2) {
        Preconditions.checkState((boolean)IR.mayBeExpression(expr1), (Object)expr1);
        Preconditions.checkState((boolean)IR.mayBeExpression(expr2), (Object)expr2);
        return new Node(token, expr1, expr2);
    }

    private static Node unaryOp(Token token, Node expr) {
        Preconditions.checkState((boolean)IR.mayBeExpression(expr));
        return new Node(token, expr);
    }

    private static boolean mayBeExpressionOrEmpty(Node n) {
        return n.isEmpty() || IR.mayBeExpression(n);
    }

    private static boolean mayBeStatementNoReturn(Node n) {
        switch (n.getToken()) {
            case EMPTY: 
            case FUNCTION: {
                return true;
            }
            case BLOCK: 
            case BREAK: 
            case CLASS: 
            case CONST: 
            case CONTINUE: 
            case DEBUGGER: 
            case DO: 
            case EXPR_RESULT: 
            case FOR: 
            case IF: 
            case LABEL: 
            case LET: 
            case SWITCH: 
            case THROW: 
            case TRY: 
            case VAR: 
            case WHILE: 
            case WITH: {
                return true;
            }
        }
        return false;
    }

    private static boolean mayBeStatement(Node n) {
        if (!IR.mayBeStatementNoReturn(n)) {
            return n.isReturn();
        }
        return true;
    }

    private static boolean mayBeExpression(Node n) {
        switch (n.getToken()) {
            case FUNCTION: 
            case CLASS: {
                return true;
            }
            case ADD: 
            case AND: 
            case ARRAYLIT: 
            case ASSIGN: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_EXPONENT: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case AWAIT: 
            case BITAND: 
            case BITOR: 
            case BITNOT: 
            case BITXOR: 
            case CALL: 
            case CAST: 
            case COMMA: 
            case DEC: 
            case DELPROP: 
            case DIV: 
            case EQ: 
            case EXPONENT: 
            case FALSE: 
            case GE: 
            case GETPROP: 
            case GETELEM: 
            case GT: 
            case HOOK: 
            case IN: 
            case INC: 
            case INSTANCEOF: 
            case LE: 
            case LSH: 
            case LT: 
            case MOD: 
            case MUL: 
            case NAME: 
            case NE: 
            case NEG: 
            case NEW: 
            case NOT: 
            case NUMBER: 
            case NULL: 
            case OBJECTLIT: 
            case OR: 
            case POS: 
            case REGEXP: 
            case RSH: 
            case SHEQ: 
            case SHNE: 
            case SPREAD: 
            case STRING: 
            case SUB: 
            case SUPER: 
            case TEMPLATELIT: 
            case TAGGED_TEMPLATELIT: 
            case THIS: 
            case TYPEOF: 
            case TRUE: 
            case URSH: 
            case VOID: 
            case YIELD: {
                return true;
            }
        }
        return false;
    }
}

