/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.base.Preconditions;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public final class JSDocInfoBuilder {
    private JSDocInfo currentInfo;
    private boolean populated;
    private boolean parseDocumentation;
    private JSDocInfo.Marker currentMarker;
    private final Set<String> licenseTexts;

    public JSDocInfoBuilder(boolean parseDocumentation) {
        this(new JSDocInfo(parseDocumentation), parseDocumentation, false);
    }

    private JSDocInfoBuilder(JSDocInfo info, boolean parseDocumentation, boolean populated) {
        this.currentInfo = info;
        this.parseDocumentation = parseDocumentation;
        this.populated = populated;
        this.licenseTexts = new HashSet<String>();
    }

    public static JSDocInfoBuilder copyFrom(JSDocInfo info) {
        JSDocInfo clone = info.clone();
        if (clone.getVisibility() == JSDocInfo.Visibility.INHERITED) {
            clone.setVisibility(null);
        }
        return new JSDocInfoBuilder(clone, info.isDocumentationIncluded(), true);
    }

    public static JSDocInfoBuilder maybeCopyFrom(@Nullable JSDocInfo info) {
        if (info == null) {
            return new JSDocInfoBuilder(true);
        }
        return JSDocInfoBuilder.copyFrom(info);
    }

    public void recordOriginalCommentString(String sourceComment) {
        if (this.parseDocumentation) {
            this.currentInfo.setOriginalCommentString(sourceComment);
        }
    }

    public void recordOriginalCommentPosition(int position) {
        if (this.parseDocumentation) {
            this.currentInfo.setOriginalCommentPosition(position);
        }
    }

    public boolean shouldParseDocumentation() {
        return this.parseDocumentation;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public boolean isPopulatedWithFileOverview() {
        return this.isPopulated() && (this.currentInfo.hasFileOverview() || this.currentInfo.isExterns() || this.currentInfo.isNoCompile());
    }

    public boolean isDescriptionRecorded() {
        return this.currentInfo.getDescription() != null;
    }

    public JSDocInfo build() {
        return this.build(false);
    }

    public JSDocInfo buildAndReset() {
        JSDocInfo info = this.build(false);
        if (this.currentInfo == null) {
            this.currentInfo = new JSDocInfo(this.parseDocumentation);
            this.populated = false;
        }
        return info;
    }

    public JSDocInfo build(boolean always) {
        if (this.populated || always) {
            Preconditions.checkState((this.currentInfo != null ? 1 : 0) != 0);
            JSDocInfo built = this.currentInfo;
            this.currentInfo = null;
            JSDocInfoBuilder.populateDefaults(built);
            this.populated = false;
            return built;
        }
        return null;
    }

    private static void populateDefaults(JSDocInfo info) {
        if (info.getVisibility() == null) {
            info.setVisibility(JSDocInfo.Visibility.INHERITED);
        }
    }

    public void markAnnotation(String annotation, int lineno, int charno) {
        JSDocInfo.Marker marker = this.currentInfo.addMarker();
        if (marker != null) {
            JSDocInfo.TrimmedStringPosition position = new JSDocInfo.TrimmedStringPosition();
            position.setItem(annotation);
            position.setPositionInformation(lineno, charno, lineno, charno + annotation.length());
            marker.setAnnotation(position);
            this.populated = true;
        }
        this.currentMarker = marker;
    }

    public void markText(String text, int startLineno, int startCharno, int endLineno, int endCharno) {
        if (this.currentMarker != null) {
            JSDocInfo.StringPosition position = new JSDocInfo.StringPosition();
            position.setItem(text);
            position.setPositionInformation(startLineno, startCharno, endLineno, endCharno);
            this.currentMarker.setDescription(position);
        }
    }

    public void markTypeNode(Node typeNode, int lineno, int startCharno, int endLineno, int endCharno, boolean hasLC) {
        if (this.currentMarker != null) {
            JSDocInfo.TypePosition position = new JSDocInfo.TypePosition();
            position.setItem(typeNode);
            position.setHasBrackets(hasLC);
            position.setPositionInformation(lineno, startCharno, endLineno, endCharno);
            this.currentMarker.setType(position);
        }
    }

    public void markName(String name, StaticSourceFile file, int lineno, int charno) {
        if (this.currentMarker != null) {
            JSDocInfo.TrimmedStringPosition position = new JSDocInfo.TrimmedStringPosition();
            position.setItem(name);
            position.setPositionInformation(lineno, charno, lineno, charno + name.length());
            JSDocInfo.NamePosition nodePos = new JSDocInfo.NamePosition();
            Node node = Node.newString(Token.NAME, name, lineno, charno);
            node.setLength(name.length());
            node.setStaticSourceFile(file);
            nodePos.setItem(node);
            nodePos.setPositionInformation(lineno, charno, lineno, charno + name.length());
            this.currentMarker.setNameNode(nodePos);
        }
    }

    public boolean recordBlockDescription(String description) {
        this.populated = true;
        return this.currentInfo.documentBlock(description);
    }

    public boolean recordVisibility(JSDocInfo.Visibility visibility) {
        if (this.currentInfo.getVisibility() == null) {
            this.populated = true;
            this.currentInfo.setVisibility(visibility);
            return true;
        }
        return false;
    }

    public void overwriteVisibility(JSDocInfo.Visibility visibility) {
        this.populated = true;
        this.currentInfo.setVisibility(visibility);
    }

    public boolean recordParameter(String parameterName, JSTypeExpression type) {
        if (!this.hasAnySingletonTypeTags() && this.currentInfo.declareParam(type, parameterName)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordParameterDescription(String parameterName, String description) {
        if (this.currentInfo.documentParam(parameterName, description)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordTemplateTypeName(String name) {
        if (this.currentInfo.declareTemplateTypeName(name)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordTypeTransformation(String name, Node expr) {
        if (this.currentInfo.declareTypeTransformation(name, expr)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordThrowType(JSTypeExpression type) {
        if (type != null && !this.hasAnySingletonTypeTags()) {
            this.currentInfo.declareThrows(type);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordThrowDescription(JSTypeExpression type, String description) {
        if (this.currentInfo.documentThrows(type, description)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean addAuthor(String author) {
        if (this.currentInfo.documentAuthor(author)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean addReference(String reference) {
        if (this.currentInfo.documentReference(reference)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordConsistentIdGenerator() {
        if (!this.currentInfo.isConsistentIdGenerator()) {
            this.currentInfo.setConsistentIdGenerator(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordStableIdGenerator() {
        if (!this.currentInfo.isStableIdGenerator()) {
            this.currentInfo.setStableIdGenerator(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordXidGenerator() {
        if (!this.currentInfo.isXidGenerator()) {
            this.currentInfo.setXidGenerator(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordMappedIdGenerator() {
        if (!this.currentInfo.isMappedIdGenerator()) {
            this.currentInfo.setMappedIdGenerator(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordVersion(String version) {
        if (this.currentInfo.documentVersion(version)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDeprecationReason(String reason) {
        if (this.currentInfo.setDeprecationReason(reason)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isDeprecationReasonRecorded() {
        return this.currentInfo.getDeprecationReason() != null;
    }

    public boolean recordSuppressions(Set<String> suppressions) {
        if (this.currentInfo.setSuppressions(suppressions)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public void addSuppression(String suppression) {
        this.currentInfo.addSuppression(suppression);
        this.populated = true;
    }

    public boolean recordModifies(Set<String> modifies) {
        if (!this.hasAnySingletonSideEffectTags() && this.currentInfo.setModifies(modifies)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordType(JSTypeExpression type) {
        if (type != null && !this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setType(type);
            this.populated = true;
            return true;
        }
        return false;
    }

    public void recordInlineType() {
        this.currentInfo.setInlineType();
    }

    public boolean recordTypedef(JSTypeExpression type) {
        if (type != null && !this.hasAnyTypeRelatedTags() && this.currentInfo.declareTypedefType(type)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordIdGenerator() {
        if (!this.currentInfo.isIdGenerator()) {
            this.currentInfo.setIdGenerator(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordReturnType(JSTypeExpression jsType) {
        if (jsType != null && this.currentInfo.getReturnType() == null && !this.hasAnySingletonTypeTags()) {
            this.currentInfo.setReturnType(jsType);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordReturnDescription(String description) {
        if (this.currentInfo.documentReturn(description)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDefineType(JSTypeExpression type) {
        if (type != null && !this.currentInfo.isConstant() && !this.currentInfo.isDefine() && this.recordType(type)) {
            this.currentInfo.setDefine(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordEnumParameterType(JSTypeExpression type) {
        if (type != null && !this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setEnumParameterType(type);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordThisType(JSTypeExpression type) {
        if (type != null && !this.hasAnySingletonTypeTags() && !this.currentInfo.hasThisType()) {
            this.currentInfo.setThisType(type);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordBaseType(JSTypeExpression jsType) {
        if (jsType != null && !this.hasAnySingletonTypeTags() && !this.currentInfo.hasBaseType()) {
            this.currentInfo.setBaseType(jsType);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean changeBaseType(JSTypeExpression jsType) {
        if (jsType != null && !this.hasAnySingletonTypeTags()) {
            this.currentInfo.setBaseType(jsType);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordConstancy() {
        if (!this.currentInfo.isConstant()) {
            this.currentInfo.setConstant(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordFinality() {
        if (!this.currentInfo.isFinal()) {
            this.currentInfo.setFinal(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDescription(String description) {
        if (description != null && this.currentInfo.getDescription() == null) {
            this.currentInfo.setDescription(description);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordMeaning(String meaning) {
        if (meaning != null && this.currentInfo.getMeaning() == null) {
            this.currentInfo.setMeaning(meaning);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordFileOverview(String description) {
        if (this.currentInfo.documentFileOverview(description)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordLicense(String license) {
        this.currentInfo.setLicense(license);
        this.populated = true;
        return true;
    }

    public boolean addLicense(String license) {
        if (!this.licenseTexts.add(license)) {
            return false;
        }
        String txt = this.currentInfo.getLicense();
        if (txt == null) {
            txt = "";
        }
        this.currentInfo.setLicense(txt + license);
        this.populated = true;
        return true;
    }

    public boolean recordHiddenness() {
        if (!this.currentInfo.isHidden()) {
            this.currentInfo.setHidden(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoCompile() {
        if (!this.currentInfo.isNoCompile()) {
            this.currentInfo.setNoCompile(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoCollapse() {
        if (!this.currentInfo.isNoCollapse()) {
            this.currentInfo.setNoCollapse(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordConstructor() {
        if (!this.hasAnySingletonTypeTags() && !this.currentInfo.isConstructorOrInterface()) {
            this.currentInfo.setConstructor(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordImplicitMatch() {
        if (!(this.hasAnySingletonTypeTags() || this.currentInfo.isInterface() || this.currentInfo.isConstructor())) {
            this.currentInfo.setInterface(true);
            this.currentInfo.setImplicitMatch(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isConstructorRecorded() {
        return this.currentInfo.isConstructor();
    }

    public boolean recordUnrestricted() {
        if (this.hasAnySingletonTypeTags() || this.currentInfo.isInterface() || this.currentInfo.makesDicts() || this.currentInfo.makesStructs() || this.currentInfo.makesUnrestricted()) {
            return false;
        }
        this.currentInfo.setUnrestricted();
        this.populated = true;
        return true;
    }

    public boolean isUnrestrictedRecorded() {
        return this.currentInfo.makesUnrestricted();
    }

    public boolean recordAbstract() {
        if (!(this.hasAnySingletonTypeTags() || this.currentInfo.isInterface() || this.currentInfo.isAbstract() || this.currentInfo.isFinal() || this.currentInfo.getVisibility() == JSDocInfo.Visibility.PRIVATE)) {
            this.currentInfo.setAbstract();
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordStruct() {
        if (this.hasAnySingletonTypeTags() || this.currentInfo.makesDicts() || this.currentInfo.makesStructs() || this.currentInfo.makesUnrestricted()) {
            return false;
        }
        this.currentInfo.setStruct();
        this.populated = true;
        return true;
    }

    public boolean isStructRecorded() {
        return this.currentInfo.makesStructs();
    }

    public boolean recordDict() {
        if (this.hasAnySingletonTypeTags() || this.currentInfo.makesDicts() || this.currentInfo.makesStructs() || this.currentInfo.makesUnrestricted()) {
            return false;
        }
        this.currentInfo.setDict();
        this.populated = true;
        return true;
    }

    public boolean isDictRecorded() {
        return this.currentInfo.makesDicts();
    }

    public boolean recordOverride() {
        if (!this.currentInfo.isOverride()) {
            this.currentInfo.setOverride(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoAlias() {
        if (!this.currentInfo.isNoAlias()) {
            this.currentInfo.setNoAlias(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDeprecated() {
        if (!this.currentInfo.isDeprecated()) {
            this.currentInfo.setDeprecated(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordInterface() {
        if (this.hasAnySingletonTypeTags() || this.currentInfo.isConstructor() || this.currentInfo.isInterface() || this.currentInfo.isAbstract()) {
            return false;
        }
        this.currentInfo.setInterface(true);
        this.populated = true;
        return true;
    }

    public boolean recordExport() {
        if (!this.currentInfo.isExport()) {
            this.currentInfo.setExport(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordExpose() {
        if (!this.currentInfo.isExpose()) {
            this.currentInfo.setExpose(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordImplicitCast() {
        if (!this.currentInfo.isImplicitCast()) {
            this.currentInfo.setImplicitCast(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoSideEffects() {
        if (!this.hasAnySingletonSideEffectTags() && !this.currentInfo.isNoSideEffects()) {
            this.currentInfo.setNoSideEffects(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordExterns() {
        if (!this.currentInfo.isExterns()) {
            this.currentInfo.setExterns(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isInterfaceRecorded() {
        return this.currentInfo.isInterface();
    }

    public boolean hasParameter(String name) {
        return this.currentInfo.hasParameter(name);
    }

    public boolean recordImplementedInterface(JSTypeExpression interfaceName) {
        if (interfaceName != null && this.currentInfo.addImplementedInterface(interfaceName)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordExtendedInterface(JSTypeExpression interfaceType) {
        if (interfaceType != null && this.currentInfo.addExtendedInterface(interfaceType)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordLends(String name) {
        if (!this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setLendsName(name);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isNgInjectRecorded() {
        return this.currentInfo.isNgInject();
    }

    public boolean recordNgInject(boolean ngInject) {
        if (!this.isNgInjectRecorded()) {
            this.currentInfo.setNgInject(ngInject);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isJaggerInjectRecorded() {
        return this.currentInfo.isJaggerInject();
    }

    public boolean recordJaggerInject(boolean inject) {
        if (!this.isJaggerInjectRecorded()) {
            this.currentInfo.setJaggerInject(inject);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isJaggerModuleRecorded() {
        return this.currentInfo.isJaggerModule();
    }

    public boolean recordJaggerModule(boolean jaggerModule) {
        if (!this.isJaggerModuleRecorded()) {
            this.currentInfo.setJaggerModule(jaggerModule);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isJaggerProvideRecorded() {
        return this.currentInfo.isJaggerProvide();
    }

    public boolean recordJaggerProvide(boolean jaggerProvide) {
        if (!this.isJaggerProvideRecorded()) {
            this.currentInfo.setJaggerProvide(jaggerProvide);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isJaggerProvidePromiseRecorded() {
        return this.currentInfo.isJaggerProvidePromise();
    }

    public boolean recordJaggerProvidePromise(boolean jaggerPromise) {
        if (!this.isJaggerProvidePromiseRecorded()) {
            this.currentInfo.setJaggerProvidePromise(jaggerPromise);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isWizactionRecorded() {
        return this.currentInfo.isWizaction();
    }

    public boolean recordWizaction() {
        if (!this.isWizactionRecorded()) {
            this.currentInfo.setWizaction(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isPolymerBehaviorRecorded() {
        return this.currentInfo.isPolymerBehavior();
    }

    public boolean recordPolymerBehavior() {
        if (!this.isPolymerBehaviorRecorded()) {
            this.currentInfo.setPolymerBehavior(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public void mergePropertyBitfieldFrom(JSDocInfo other) {
        this.currentInfo.mergePropertyBitfieldFrom(other);
    }

    public boolean recordDisposesParameter(List<String> parameterNames) {
        for (String parameterName : parameterNames) {
            if ((this.currentInfo.hasParameter(parameterName) || parameterName.equals("*")) && this.currentInfo.setDisposedParameter(parameterName)) {
                this.populated = true;
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean hasAnyTypeRelatedTags() {
        return this.currentInfo.isConstructor() || this.currentInfo.isInterface() || this.currentInfo.isAbstract() || this.currentInfo.getParameterCount() > 0 || this.currentInfo.hasReturnType() || this.currentInfo.hasBaseType() || this.currentInfo.getExtendedInterfacesCount() > 0 || this.currentInfo.getLendsName() != null || this.currentInfo.hasThisType() || this.hasAnySingletonTypeTags();
    }

    private boolean hasAnySingletonTypeTags() {
        return this.currentInfo.hasType() || this.currentInfo.hasTypedefType() || this.currentInfo.hasEnumParameterType();
    }

    private boolean hasAnySingletonSideEffectTags() {
        return this.currentInfo.isNoSideEffects() || this.currentInfo.hasModifies();
    }
}

