/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.UnknownType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UnionTypeBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAX_UNION_SIZE = 30;
    private final JSTypeRegistry registry;
    private final List<JSType> alternates = new ArrayList<JSType>();
    private boolean containsVoidType = false;
    private boolean isAllType = false;
    private boolean isNativeUnknownType = false;
    private boolean areAllUnknownsChecked = true;
    private final int maxUnionSize;
    private int functionTypePosition = -1;
    private JSType result = null;

    public UnionTypeBuilder(JSTypeRegistry registry) {
        this(registry, 30);
    }

    UnionTypeBuilder(JSTypeRegistry registry, int maxUnionSize) {
        this.registry = registry;
        this.maxUnionSize = maxUnionSize;
    }

    ImmutableList<JSType> getAlternates() {
        JSType specialCaseType = this.reduceAlternatesWithoutUnion();
        if (specialCaseType != null) {
            return ImmutableList.of((Object)specialCaseType);
        }
        JSType wildcard = this.getNativeWildcardType();
        if (wildcard != null && this.containsVoidType) {
            return ImmutableList.of((Object)wildcard, (Object)this.registry.getNativeType(JSTypeNative.VOID_TYPE));
        }
        return ImmutableList.copyOf(this.alternates);
    }

    @VisibleForTesting
    int getAlternatesCount() {
        return this.alternates.size();
    }

    private boolean isSubtype(JSType rightType, JSType leftType, boolean isStructural) {
        boolean thatUnresolved;
        boolean thisUnresolved = rightType.isTemplatizedType() && !rightType.toMaybeTemplatizedType().isResolved();
        boolean bl = thatUnresolved = leftType.isTemplatizedType() && !leftType.toMaybeTemplatizedType().isResolved();
        if (isStructural && !thisUnresolved && !thatUnresolved) {
            return rightType.isSubtype(leftType);
        }
        return rightType.isSubtypeWithoutStructuralTyping(leftType);
    }

    public UnionTypeBuilder addAlternate(JSType alternate, boolean isStructural) {
        if (alternate.isNoType()) {
            return this;
        }
        this.isAllType = this.isAllType || alternate.isAllType();
        this.containsVoidType = this.containsVoidType || alternate.isVoidType();
        boolean isAlternateUnknown = alternate instanceof UnknownType;
        boolean bl = this.isNativeUnknownType = this.isNativeUnknownType || isAlternateUnknown;
        if (isAlternateUnknown) {
            boolean bl2 = this.areAllUnknownsChecked = this.areAllUnknownsChecked && alternate.isCheckedUnknownType();
        }
        if (!this.isAllType && !this.isNativeUnknownType) {
            if (alternate.isUnionType()) {
                UnionType union = alternate.toMaybeUnionType();
                ImmutableList<JSType> alternatesWithoutStructuralTyping = union.getAlternatesWithoutStructuralTypingList();
                for (int i = 0; i < alternatesWithoutStructuralTyping.size(); ++i) {
                    JSType unionAlt = (JSType)alternatesWithoutStructuralTyping.get(i);
                    this.addAlternate(unionAlt);
                }
            } else {
                if (this.alternates.size() > this.maxUnionSize) {
                    return this;
                }
                if (alternate.isFunctionType() && this.functionTypePosition != -1) {
                    FunctionType other = this.alternates.get(this.functionTypePosition).toMaybeFunctionType();
                    FunctionType supremum = alternate.toMaybeFunctionType().supAndInfHelper(other, true);
                    this.alternates.set(this.functionTypePosition, supremum);
                    this.result = null;
                    return this;
                }
                int currentIndex = 0;
                Iterator<JSType> it = this.alternates.iterator();
                while (it.hasNext()) {
                    boolean removeCurrent = false;
                    JSType current = it.next();
                    if (alternate.isUnknownType() || current.isUnknownType() || alternate.isNoResolvedType() || current.isNoResolvedType() || alternate.hasAnyTemplateTypes() || current.hasAnyTemplateTypes()) {
                        if (alternate.isEquivalentTo(current, isStructural)) {
                            return this;
                        }
                    } else if (alternate.isTemplatizedType() || current.isTemplatizedType()) {
                        if (!current.isTemplatizedType()) {
                            if (this.isSubtype(alternate, current, isStructural)) {
                                return this;
                            }
                        } else if (!alternate.isTemplatizedType()) {
                            if (this.isSubtype(current, alternate, isStructural)) {
                                removeCurrent = true;
                            }
                        } else {
                            Preconditions.checkState((current.isTemplatizedType() && alternate.isTemplatizedType() ? 1 : 0) != 0);
                            TemplatizedType templatizedAlternate = alternate.toMaybeTemplatizedType();
                            TemplatizedType templatizedCurrent = current.toMaybeTemplatizedType();
                            if (templatizedCurrent.wrapsSameRawType(templatizedAlternate)) {
                                if (alternate.getTemplateTypeMap().checkEquivalenceHelper(current.getTemplateTypeMap(), EquivalenceMethod.IDENTITY, JSType.SubtypingMode.NORMAL)) {
                                    return this;
                                }
                                ObjectType merged = templatizedCurrent.getReferencedObjTypeInternal();
                                return this.addAlternate(merged);
                            }
                        }
                    } else {
                        if (this.isSubtype(alternate, current, isStructural)) {
                            this.mayRegisterDroppedProperties(alternate, current);
                            return this;
                        }
                        if (this.isSubtype(current, alternate, isStructural)) {
                            this.mayRegisterDroppedProperties(current, alternate);
                            removeCurrent = true;
                        }
                    }
                    if (removeCurrent) {
                        it.remove();
                        if (currentIndex == this.functionTypePosition) {
                            this.functionTypePosition = -1;
                        } else if (currentIndex < this.functionTypePosition) {
                            --this.functionTypePosition;
                            --currentIndex;
                        }
                    }
                    ++currentIndex;
                }
                if (alternate.isFunctionType()) {
                    Preconditions.checkState((this.functionTypePosition == -1 ? 1 : 0) != 0);
                    this.functionTypePosition = this.alternates.size();
                }
                this.alternates.add(alternate);
                this.result = null;
            }
        } else {
            this.result = null;
        }
        return this;
    }

    private void mayRegisterDroppedProperties(JSType subtype, JSType supertype) {
        if (subtype.toMaybeRecordType() != null && supertype.toMaybeRecordType() != null) {
            this.registry.registerDroppedPropertiesInUnion(subtype.toMaybeRecordType(), supertype.toMaybeRecordType());
        }
    }

    public UnionTypeBuilder addAlternate(JSType alternate) {
        return this.addAlternate(alternate, false);
    }

    private JSType reduceAlternatesWithoutUnion() {
        JSType wildcard = this.getNativeWildcardType();
        if (wildcard != null) {
            return this.containsVoidType ? null : wildcard;
        }
        int size = this.alternates.size();
        if (size > this.maxUnionSize) {
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (size > 1) {
            return null;
        }
        if (size == 1) {
            return this.alternates.get(0);
        }
        return this.registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    private JSType getNativeWildcardType() {
        if (this.isAllType) {
            return this.registry.getNativeType(JSTypeNative.ALL_TYPE);
        }
        if (this.isNativeUnknownType) {
            if (this.areAllUnknownsChecked) {
                return this.registry.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
            }
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return null;
    }

    public JSType build() {
        if (this.result == null) {
            this.result = this.reduceAlternatesWithoutUnion();
            if (this.result == null) {
                this.result = new UnionType(this.registry, (ImmutableList<JSType>)ImmutableList.copyOf(this.getAlternates()));
            }
        }
        return this.result;
    }
}

