/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.testing.compile.AutoValue_Compiler;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationFailureException;
import com.google.testing.compile.InMemoryJavaFileManager;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public abstract class Compiler {
    public static Compiler javac() {
        return Compiler.compiler(ToolProvider.getSystemJavaCompiler());
    }

    public static Compiler compiler(JavaCompiler javaCompiler) {
        return new AutoValue_Compiler(javaCompiler, (ImmutableList<Processor>)ImmutableList.of(), (ImmutableList<String>)ImmutableList.of());
    }

    abstract JavaCompiler javaCompiler();

    public abstract ImmutableList<Processor> processors();

    public abstract ImmutableList<String> options();

    public final Compiler withProcessors(Processor ... processors) {
        return this.withProcessors((Iterable<? extends Processor>)ImmutableList.copyOf((Object[])processors));
    }

    public final Compiler withProcessors(Iterable<? extends Processor> processors) {
        return this.copy((ImmutableList<Processor>)ImmutableList.copyOf(processors), this.options());
    }

    public final Compiler withOptions(Object ... options) {
        return this.withOptions((Iterable<?>)ImmutableList.copyOf((Object[])options));
    }

    public final Compiler withOptions(Iterable<?> options) {
        return this.copy(this.processors(), (ImmutableList<String>)FluentIterable.from(options).transform(Functions.toStringFunction()).toList());
    }

    public final Compiler withClasspathFrom(ClassLoader classloader) {
        String classpath = Compiler.getClasspathFromClassloader(classloader);
        ImmutableList options = ImmutableList.builder().add((Object)"-classpath").add((Object)classpath).addAll(this.options()).build();
        return this.copy(this.processors(), (ImmutableList<String>)options);
    }

    public final Compilation compile(JavaFileObject ... files) {
        return this.compile((Iterable<? extends JavaFileObject>)ImmutableList.copyOf((Object[])files));
    }

    public final Compilation compile(Iterable<? extends JavaFileObject> files) {
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        InMemoryJavaFileManager fileManager = new InMemoryJavaFileManager(this.javaCompiler().getStandardFileManager(diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8));
        JavaCompiler.CompilationTask task = this.javaCompiler().getTask(null, fileManager, diagnosticCollector, (Iterable<String>)this.options(), (Iterable<String>)ImmutableSet.of(), files);
        task.setProcessors((Iterable<? extends Processor>)this.processors());
        boolean succeeded = task.call();
        Compilation compilation = new Compilation(this, files, succeeded, (Iterable<Diagnostic<? extends JavaFileObject>>)diagnosticCollector.getDiagnostics(), (Iterable<JavaFileObject>)fileManager.getOutputFiles());
        if (compilation.status().equals((Object)Compilation.Status.FAILURE) && compilation.errors().isEmpty()) {
            throw new CompilationFailureException(compilation);
        }
        return compilation;
    }

    private static String getClasspathFromClassloader(ClassLoader currentClassloader) {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        ArrayList<URLClassLoader> classloaders = new ArrayList<URLClassLoader>();
        while (true) {
            if (!(currentClassloader instanceof URLClassLoader)) {
                throw new IllegalArgumentException("Classpath for compilation could not be extracted since given classloader is not an instance of URLClassloader");
            }
            classloaders.add((URLClassLoader)currentClassloader);
            if (currentClassloader == systemClassLoader) break;
            currentClassloader = currentClassloader.getParent();
        }
        LinkedHashSet<String> classpaths = new LinkedHashSet<String>();
        for (URLClassLoader classLoader : classloaders) {
            for (URL url : classLoader.getURLs()) {
                if (!url.getProtocol().equals("file")) {
                    throw new IllegalArgumentException("Given classloader consists of classpaths which are unsupported for compilation.");
                }
                classpaths.add(url.getPath());
            }
        }
        return Joiner.on((char)':').join(classpaths);
    }

    private Compiler copy(ImmutableList<Processor> processors, ImmutableList<String> options) {
        return new AutoValue_Compiler(this.javaCompiler(), processors, options);
    }
}

