/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrentlinkedhashmap;

import com.googlecode.concurrentlinkedhashmap.Weigher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Weighers {
    private Weighers() {
        throw new AssertionError();
    }

    public static <V> Weigher<V> singleton() {
        return SingletonWeigher.INSTANCE;
    }

    public static Weigher<byte[]> byteArray() {
        return ByteArrayWeigher.INSTANCE;
    }

    public static <E> Weigher<Iterable<E>> iterable() {
        IterableWeigher weigher = IterableWeigher.INSTANCE;
        return weigher;
    }

    public static <E> Weigher<Collection<E>> collection() {
        CollectionWeigher weigher = CollectionWeigher.INSTANCE;
        return weigher;
    }

    public static <E> Weigher<List<E>> list() {
        ListWeigher weigher = ListWeigher.INSTANCE;
        return weigher;
    }

    public static <E> Weigher<Set<E>> set() {
        SetWeigher weigher = SetWeigher.INSTANCE;
        return weigher;
    }

    public static <A, B> Weigher<Map<A, B>> map() {
        MapWeigher weigher = MapWeigher.INSTANCE;
        return weigher;
    }

    private static enum MapWeigher implements Weigher<Map>
    {
        INSTANCE;


        @Override
        public int weightOf(Map values) {
            return values.size();
        }
    }

    private static enum SetWeigher implements Weigher<Set>
    {
        INSTANCE;


        @Override
        public int weightOf(Set values) {
            return values.size();
        }
    }

    private static enum ListWeigher implements Weigher<List>
    {
        INSTANCE;


        @Override
        public int weightOf(List values) {
            return values.size();
        }
    }

    private static enum CollectionWeigher implements Weigher<Collection>
    {
        INSTANCE;


        @Override
        public int weightOf(Collection values) {
            return values.size();
        }
    }

    private static enum IterableWeigher implements Weigher<Iterable>
    {
        INSTANCE;


        @Override
        public int weightOf(Iterable values) {
            if (values instanceof Collection) {
                return ((Collection)values).size();
            }
            int size = 0;
            for (Object value : values) {
                ++size;
            }
            return size;
        }
    }

    private static enum ByteArrayWeigher implements Weigher<byte[]>
    {
        INSTANCE;


        @Override
        public int weightOf(byte[] value) {
            return value.length;
        }
    }

    private static enum SingletonWeigher implements Weigher
    {
        INSTANCE;


        public int weightOf(Object value) {
            return 1;
        }
    }
}

