/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.CallVisitor;
import proguard.analysis.DominatorCalculator;
import proguard.analysis.Metrics;
import proguard.analysis.datastructure.CodeLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.analysis.datastructure.callgraph.CallGraph;
import proguard.analysis.datastructure.callgraph.ConcreteCall;
import proguard.analysis.datastructure.callgraph.SymbolicCall;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.LineNumberFinder;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.ExecutingInvocationUnit;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.ParticularReferenceValueFactory;
import proguard.evaluation.exception.EmptyCodeAttributeException;
import proguard.evaluation.exception.ExcessiveComplexityException;
import proguard.evaluation.value.ArrayReferenceValueFactory;
import proguard.evaluation.value.MultiTypedReferenceValue;
import proguard.evaluation.value.MultiTypedReferenceValueFactory;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.util.PartialEvaluatorUtils;

public class CallResolver
implements AttributeVisitor,
ClassVisitor,
InstructionVisitor {
    private static final Logger log = LogManager.getLogger(CallResolver.class);
    private final DominatorCalculator dominatorCalculator;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final CallGraph callGraph;
    private final boolean clearCallValuesAfterVisit;
    private final boolean useDominatorAnalysis;
    private final List<CallVisitor> visitors;
    private final PartialEvaluator particularValueEvaluator;
    private boolean particularValueEvaluationSuccessful;
    private final PartialEvaluator multiTypeValueEvaluator;
    private boolean multiTypeEvaluationSuccessful;
    private final Supplier<Boolean> shouldAnalyzeNextCodeAttribute;
    private final boolean skipIncompleteCalls;

    public static MethodSignature quickResolve(Instruction instruction, ProgramClass clazz) {
        if (!(instruction instanceof ConstantInstruction)) {
            return MethodSignature.UNKNOWN;
        }
        Constant constant = clazz.getConstant(((ConstantInstruction)instruction).constantIndex);
        if (instruction.opcode == -70 && constant instanceof InvokeDynamicConstant) {
            InvokeDynamicConstant invokeDynamicConstant = (InvokeDynamicConstant)constant;
            return new MethodSignature(null, null, invokeDynamicConstant.getType(clazz));
        }
        if (!(constant instanceof AnyMethodrefConstant)) {
            return MethodSignature.UNKNOWN;
        }
        AnyMethodrefConstant methodRef = (AnyMethodrefConstant)constant;
        switch (instruction.opcode) {
            case -72: {
                return new MethodSignature(methodRef.getClassName(clazz), methodRef.getName(clazz), methodRef.getType(clazz));
            }
            case -74: 
            case -73: 
            case -71: {
                return new MethodSignature(null, methodRef.getName(clazz), methodRef.getType(clazz));
            }
        }
        return MethodSignature.UNKNOWN;
    }

    public CallResolver(ClassPool programClassPool, ClassPool libraryClassPool, CallGraph callGraph, boolean clearCallValuesAfterVisit, boolean useDominatorAnalysis, boolean evaluateAllCode, boolean includeSubClasses, int maxPartialEvaluations, Supplier<Boolean> shouldAnalyzeNextCodeAttribute, boolean skipIncompleteCalls, ValueFactory arrayValueFactory, boolean ignoreExceptions, ExecutingInvocationUnit.Builder executingInvocationUnitBuilder, CallVisitor ... visitors) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.callGraph = callGraph;
        this.clearCallValuesAfterVisit = clearCallValuesAfterVisit;
        this.useDominatorAnalysis = useDominatorAnalysis;
        this.shouldAnalyzeNextCodeAttribute = shouldAnalyzeNextCodeAttribute;
        this.skipIncompleteCalls = skipIncompleteCalls;
        this.visitors = Arrays.asList(visitors);
        this.dominatorCalculator = new DominatorCalculator(ignoreExceptions);
        MultiTypedReferenceValueFactory multiTypeValueFactory = includeSubClasses ? new MultiTypedReferenceValueFactory(true, this.programClassPool, this.libraryClassPool) : new MultiTypedReferenceValueFactory();
        BasicInvocationUnit multiTypeValueInvocationUnit = new BasicInvocationUnit(multiTypeValueFactory);
        this.multiTypeValueEvaluator = PartialEvaluator.Builder.create().setValueFactory(multiTypeValueFactory).setInvocationUnit(multiTypeValueInvocationUnit).setEvaluateAllCode(evaluateAllCode).stopAnalysisAfterNEvaluations(maxPartialEvaluations).build();
        ParticularValueFactory particularValueFactory = new ParticularValueFactory(arrayValueFactory, new ParticularReferenceValueFactory());
        ExecutingInvocationUnit particularValueInvocationUnit = executingInvocationUnitBuilder.build(particularValueFactory);
        this.particularValueEvaluator = PartialEvaluator.Builder.create().setValueFactory(particularValueFactory).setInvocationUnit(particularValueInvocationUnit).setEvaluateAllCode(evaluateAllCode).stopAnalysisAfterNEvaluations(maxPartialEvaluations).build();
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.accept(new AllAttributeVisitor(true, this));
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (!this.shouldAnalyzeNextCodeAttribute.get().booleanValue()) {
            return;
        }
        try {
            this.multiTypeEvaluationSuccessful = false;
            this.multiTypeValueEvaluator.visitCodeAttribute0(clazz, method, codeAttribute);
            this.multiTypeEvaluationSuccessful = true;
        }
        catch (ExcessiveComplexityException e) {
            Metrics.increaseCount(Metrics.MetricType.PARTIAL_EVALUATOR_EXCESSIVE_COMPLEXITY);
        }
        catch (EmptyCodeAttributeException e) {
            log.info((Object)e);
        }
        catch (Exception e) {
            log.error("Unexpected exception during multi type analysis", (Throwable)e);
        }
        try {
            this.particularValueEvaluationSuccessful = false;
            this.particularValueEvaluator.visitCodeAttribute0(clazz, method, codeAttribute);
            this.particularValueEvaluationSuccessful = true;
        }
        catch (ExcessiveComplexityException e) {
            Metrics.increaseCount(Metrics.MetricType.PARTIAL_EVALUATOR_EXCESSIVE_COMPLEXITY);
        }
        catch (EmptyCodeAttributeException e) {
            log.info((Object)e);
        }
        catch (Exception e) {
            log.error("Unexpected exception during particular value analysis", (Throwable)e);
        }
        if (this.useDominatorAnalysis) {
            this.dominatorCalculator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        codeAttribute.instructionsAccept(clazz, method, this);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        LineNumberFinder lineNumberFinder = new LineNumberFinder(offset);
        codeAttribute.attributesAccept(clazz, method, lineNumberFinder);
        CodeLocation location = new CodeLocation(clazz, method, offset, lineNumberFinder.lineNumber);
        Constant constant = ((ProgramClass)clazz).getConstant(constantInstruction.constantIndex);
        if (constantInstruction.opcode == -70 && constant instanceof InvokeDynamicConstant) {
            this.handleInvokeDynamic(location, constantInstruction, (InvokeDynamicConstant)constant);
        } else if (constant instanceof AnyMethodrefConstant) {
            AnyMethodrefConstant ref = (AnyMethodrefConstant)constant;
            switch (constantInstruction.opcode) {
                case -72: {
                    this.handleInvokeStatic(location, constantInstruction, (AnyMethodrefConstant)constant);
                    break;
                }
                case -74: 
                case -71: {
                    this.handleVirtualMethods(location, constantInstruction, ref);
                    break;
                }
                case -73: {
                    this.handleInvokeSpecial(location, constantInstruction, ref);
                    break;
                }
                default: {
                    Metrics.increaseCount(Metrics.MetricType.UNSUPPORTED_OPCODE);
                    log.warn("Unsupported invocation opcode " + constantInstruction.opcode + " at " + location);
                }
            }
        }
    }

    private void addCall(CodeLocation location, String targetClass, String targetMethod, String targetDescriptor, int throwsNullptr, Instruction instruction, boolean runtimeTypeDependent) {
        if (this.skipIncompleteCalls && (targetClass == null || targetMethod == null || targetDescriptor == null)) {
            Metrics.increaseCount(Metrics.MetricType.INCOMPLETE_CALL_SKIPPED);
            return;
        }
        boolean alwaysInvoked = true;
        if (this.useDominatorAnalysis) {
            alwaysInvoked = this.dominatorCalculator.dominates(location.offset, -1);
        }
        Call call = this.instantiateCall(location, targetClass, targetMethod, targetDescriptor, throwsNullptr, instruction, !alwaysInvoked, runtimeTypeDependent);
        this.initArgumentsAndReturnValue(call);
        this.visitors.forEach(d -> d.visitCall(call));
        if (this.clearCallValuesAfterVisit) {
            call.clearValues();
        }
        if (this.callGraph != null) {
            this.callGraph.addCall(call);
        }
    }

    private Call instantiateCall(CodeLocation location, String targetClass, String targetMethod, String targetDescriptor, int throwsNullptr, Instruction instruction, boolean controlFlowDependent, boolean runtimeTypeDependent) {
        if (targetClass != null && targetMethod != null && targetDescriptor != null) {
            Method method;
            Clazz containingClass = this.programClassPool.getClass(targetClass);
            if (containingClass == null) {
                containingClass = this.libraryClassPool.getClass(targetClass);
            }
            if (containingClass != null && (method = containingClass.findMethod(targetMethod, targetDescriptor)) != null) {
                Metrics.increaseCount(Metrics.MetricType.CONCRETE_CALL);
                if ((method.getAccessFlags() & 0x400) != 0) {
                    Metrics.increaseCount(Metrics.MetricType.CALL_TO_ABSTRACT_METHOD);
                }
                if (method instanceof ProgramMethod && Arrays.stream(((ProgramMethod)method).attributes).noneMatch(a -> a instanceof CodeAttribute)) {
                    Metrics.increaseCount(Metrics.MetricType.CONCRETE_CALL_NO_CODE_ATTRIBUTE);
                }
                return new ConcreteCall(location, containingClass, method, throwsNullptr, instruction, controlFlowDependent, runtimeTypeDependent);
            }
        }
        Metrics.increaseCount(Metrics.MetricType.SYMBOLIC_CALL);
        return new SymbolicCall(location, new MethodSignature(targetClass, targetMethod, targetDescriptor), throwsNullptr, instruction, controlFlowDependent, runtimeTypeDependent);
    }

    private void initArgumentsAndReturnValue(Call call) {
        MethodSignature target = call.getTarget();
        List<Value> arguments = this.getArguments(call.caller, target, call.isStatic());
        if (!call.isStatic() && !arguments.isEmpty()) {
            call.setInstance(arguments.remove(0));
        }
        call.setArguments(arguments);
        if (target.descriptor.returnType.charAt(0) != 'V' && this.particularValueEvaluationSuccessful) {
            call.setReturnValue(PartialEvaluatorUtils.getStackValue(this.particularValueEvaluator.getStackAfter(call.caller.offset), 0));
        }
    }

    private List<Value> getArguments(CodeLocation location, MethodSignature invokedMethodSig, boolean isStaticCall) {
        if (invokedMethodSig.descriptor.argumentTypes == null) {
            log.error("Argument types list of {} is null!", (Object)invokedMethodSig);
            return Collections.emptyList();
        }
        ArrayList<Value> args = new ArrayList<Value>();
        int stackOffset = 0;
        for (int argNumber = invokedMethodSig.descriptor.argumentTypes.size() - 1; argNumber >= 0; --argNumber) {
            String argType = invokedMethodSig.descriptor.argumentTypes.get(argNumber);
            Value stackTop = PartialEvaluatorUtils.getStackBefore(this.multiTypeValueEvaluator, location.offset, stackOffset);
            if (!(stackTop instanceof MultiTypedReferenceValue) || ((MultiTypedReferenceValue)stackTop).getPotentialTypes().size() <= 1) {
                stackTop = PartialEvaluatorUtils.getStackBefore(this.particularValueEvaluator, location.offset, stackOffset);
            }
            args.add(0, stackTop);
            stackOffset += ClassUtil.internalTypeSize(argType);
        }
        if (!isStaticCall) {
            Value instance = PartialEvaluatorUtils.getStackBefore(this.multiTypeValueEvaluator, location.offset, stackOffset);
            if (!(instance instanceof MultiTypedReferenceValue) || ((MultiTypedReferenceValue)instance).getPotentialTypes().size() <= 1) {
                instance = PartialEvaluatorUtils.getStackBefore(this.particularValueEvaluator, location.offset, stackOffset);
            }
            args.add(0, instance);
        }
        return args;
    }

    private void handleInvokeDynamic(CodeLocation location, Instruction instruction, InvokeDynamicConstant constant) {
        this.addCall(location, null, null, constant.getType(location.clazz), -1, instruction, false);
    }

    private void handleInvokeStatic(CodeLocation location, Instruction instruction, AnyMethodrefConstant constant) {
        this.addCall(location, constant.getClassName(location.clazz), constant.getName(location.clazz), constant.getType(location.clazz), -1, instruction, false);
    }

    private void handleInvokeSpecial(CodeLocation location, Instruction instruction, AnyMethodrefConstant ref) {
        Set<String> targets = this.resolveInvokeSpecial(location.clazz, ref);
        if (targets.isEmpty()) {
            Metrics.increaseCount(Metrics.MetricType.MISSING_METHODS);
        } else {
            String name = ref.getName(location.clazz);
            String descriptor = ref.getType(location.clazz);
            for (String target : targets) {
                this.addCall(location, target, name, descriptor, -1, instruction, false);
            }
        }
    }

    private Set<String> resolveInvokeSpecial(Clazz callingClass, AnyMethodrefConstant ref) {
        String name = ref.getName(callingClass);
        String descriptor = ref.getType(callingClass);
        Clazz c = (callingClass.getAccessFlags() & 0x20) != 0 && !name.equals("<init>") && ref.referencedClass != null && (ref.referencedClass.getAccessFlags() & 0x200) == 0 && callingClass.extends_(ref.referencedClass) && !callingClass.getName().equals(ref.referencedClass.getName()) ? callingClass.getSuperClass() : ref.referencedClass;
        if (c == null) {
            String className = ref.getClassName(callingClass);
            Metrics.increaseCount(Metrics.MetricType.MISSING_CLASS);
            return Collections.singleton(className);
        }
        if (c.findMethod(name, descriptor) != null) {
            return Collections.singleton(c.getName());
        }
        Optional<Object> target = Optional.empty();
        if ((c.getAccessFlags() & 0x200) == 0) {
            target = this.resolveFromSuperclasses(c, name, descriptor);
        } else {
            for (java.lang.reflect.Method m : Object.class.getMethods()) {
                if ((m.getModifiers() & 1) == 0 || !m.getName().equals(name) || !CallResolver.getDescriptor(m).equals(descriptor)) continue;
                target = Optional.of("java/lang/Object");
                break;
            }
        }
        return target.map(Collections::singleton).orElseGet(() -> this.resolveFromSuperinterfaces(c, name, descriptor));
    }

    public static String getDescriptor(java.lang.reflect.Method m) {
        List<String> parameters = Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.toList());
        return ClassUtil.internalMethodDescriptor(m.getReturnType().getName(), parameters);
    }

    private void handleVirtualMethods(CodeLocation location, Instruction instruction, AnyMethodrefConstant ref) {
        String name = ref.getName(location.clazz);
        String descriptor = ref.getType(location.clazz);
        int argumentCount = ClassUtil.internalMethodParameterSize(descriptor, false);
        Value thisPtr = PartialEvaluatorUtils.getStackBefore(this.multiTypeValueEvaluator, location.offset, argumentCount - 1);
        if (!(thisPtr instanceof MultiTypedReferenceValue)) {
            if (this.multiTypeEvaluationSuccessful) {
                Metrics.increaseCount(Metrics.MetricType.PARTIAL_EVALUATOR_VALUE_IMPRECISE);
            }
        } else {
            MultiTypedReferenceValue multiTypeThisPtr = (MultiTypedReferenceValue)thisPtr;
            for (TypedReferenceValue possibleType : multiTypeThisPtr.getPotentialTypes()) {
                Set<String> targetClasses;
                Clazz referencedClass;
                if (possibleType.isNull() == 1) {
                    this.addCall(location, ref.getClassName(location.clazz), ref.getName(location.clazz), ref.getType(location.clazz), 1, instruction, multiTypeThisPtr.getPotentialTypes().size() > 1);
                    continue;
                }
                if (ClassUtil.isInternalArrayType(possibleType.getType())) {
                    referencedClass = this.libraryClassPool.getClass("java/lang/Object");
                } else {
                    referencedClass = possibleType.getReferencedClass();
                    if (referencedClass == null) {
                        referencedClass = this.programClassPool.getClass(ClassUtil.internalClassNameFromClassType(possibleType.getType()));
                    }
                    if (referencedClass == null) {
                        referencedClass = this.libraryClassPool.getClass(ClassUtil.internalClassNameFromClassType(possibleType.getType()));
                    }
                }
                if (referencedClass == null) {
                    Metrics.increaseCount(Metrics.MetricType.MISSING_CLASS);
                }
                if ((targetClasses = this.resolveVirtual(location.clazz, referencedClass, ref)).isEmpty()) {
                    if (referencedClass != null) {
                        Metrics.increaseCount(Metrics.MetricType.MISSING_METHODS);
                    }
                    targetClasses = Collections.singleton(ClassUtil.internalClassNameFromClassType(possibleType.getType()));
                }
                for (String targetClass : targetClasses) {
                    this.addCall(location, targetClass, name, descriptor, multiTypeThisPtr.isNull(), instruction, multiTypeThisPtr.getPotentialTypes().size() > 1);
                }
            }
        }
    }

    private Set<String> resolveVirtual(Clazz callingClass, Clazz thisPtrType, AnyMethodrefConstant ref) {
        if (thisPtrType == null) {
            return Collections.emptySet();
        }
        String name = ref.getName(callingClass);
        String descriptor = ref.getType(callingClass);
        return this.resolveFromSuperclasses(thisPtrType, name, descriptor).map(Collections::singleton).orElseGet(() -> this.resolveFromSuperinterfaces(thisPtrType, name, descriptor));
    }

    private Optional<String> resolveFromSuperclasses(Clazz start, String name, String descriptor) {
        for (Clazz curr = start; curr != null; curr = curr.getSuperClass()) {
            Method targetMethod = curr.findMethod(name, descriptor);
            if (targetMethod == null || (targetMethod.getAccessFlags() & 0x400) != 0) continue;
            return Optional.of(curr.getName());
        }
        return Optional.empty();
    }

    private Set<String> resolveFromSuperinterfaces(Clazz start, String name, String descriptor) {
        HashSet<Clazz> superInterfaces = new HashSet<Clazz>();
        this.getSuperinterfaces(start, superInterfaces);
        Set applicableInterfaces = superInterfaces.stream().filter(i -> {
            Method m = i.findMethod(name, descriptor);
            return m != null && (m.getAccessFlags() & 0x40A) == 0;
        }).collect(Collectors.toSet());
        for (Clazz iface : new HashSet(applicableInterfaces)) {
            superInterfaces.clear();
            this.getSuperinterfaces(iface, superInterfaces);
            superInterfaces.forEach(applicableInterfaces::remove);
        }
        return applicableInterfaces.stream().map(Clazz::getName).collect(Collectors.toSet());
    }

    private void getSuperinterfaces(Clazz start, Set<Clazz> accumulator) {
        for (int i = 0; i < start.getInterfaceCount(); ++i) {
            Clazz iface = start.getInterface(i);
            if (iface == null) {
                Metrics.increaseCount(Metrics.MetricType.MISSING_CLASS);
                continue;
            }
            accumulator.add(iface);
            this.getSuperinterfaces(iface, accumulator);
        }
        if (start.getSuperClass() != null) {
            this.getSuperinterfaces(start.getSuperClass(), accumulator);
        }
    }

    public static class Builder {
        private final ClassPool programClassPool;
        private final ClassPool libraryClassPool;
        private final CallGraph callGraph;
        private final CallVisitor[] visitors;
        private boolean clearCallValuesAfterVisit = true;
        private boolean useDominatorAnalysis = false;
        private boolean evaluateAllCode = false;
        private boolean includeSubClasses = false;
        private int maxPartialEvaluations = 50;
        private Supplier<Boolean> shouldAnalyzeNextCodeAttribute = () -> true;
        private boolean skipIncompleteCalls = true;
        private ValueFactory arrayValueFactory = new ArrayReferenceValueFactory();
        private boolean ignoreExceptions = true;
        private ExecutingInvocationUnit.Builder executingInvocationUnitBuilder = new ExecutingInvocationUnit.Builder();

        public Builder(ClassPool programClassPool, ClassPool libraryClassPool, CallGraph callGraph, CallVisitor ... visitors) {
            this.programClassPool = programClassPool;
            this.libraryClassPool = libraryClassPool;
            this.callGraph = callGraph;
            this.visitors = visitors;
        }

        public Builder setClearCallValuesAfterVisit(boolean clearCallValuesAfterVisit) {
            this.clearCallValuesAfterVisit = clearCallValuesAfterVisit;
            return this;
        }

        public Builder setUseDominatorAnalysis(boolean useDominatorAnalysis) {
            this.useDominatorAnalysis = useDominatorAnalysis;
            return this;
        }

        public Builder setEvaluateAllCode(boolean evaluateAllCode) {
            this.evaluateAllCode = evaluateAllCode;
            return this;
        }

        public Builder setIncludeSubClasses(boolean includeSubClasses) {
            this.includeSubClasses = includeSubClasses;
            return this;
        }

        public Builder setMaxPartialEvaluations(int maxPartialEvaluations) {
            this.maxPartialEvaluations = maxPartialEvaluations;
            return this;
        }

        public Builder setShouldAnalyzeNextCodeAttribute(Supplier<Boolean> shouldAnalyzeNextCodeAttribute) {
            this.shouldAnalyzeNextCodeAttribute = shouldAnalyzeNextCodeAttribute;
            return this;
        }

        public Builder setSkipIncompleteCalls(boolean skipIncompleteCalls) {
            this.skipIncompleteCalls = skipIncompleteCalls;
            return this;
        }

        public Builder setArrayValueFactory(ValueFactory arrayValueFactory) {
            this.arrayValueFactory = arrayValueFactory;
            return this;
        }

        public Builder setIgnoreExceptions(boolean ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        public Builder setExecutingInvocationUnitBuilder(ExecutingInvocationUnit.Builder executingInvocationUnitBuilder) {
            this.executingInvocationUnitBuilder = executingInvocationUnitBuilder;
            return this;
        }

        public CallResolver build() {
            return new CallResolver(this.programClassPool, this.libraryClassPool, this.callGraph, this.clearCallValuesAfterVisit, this.useDominatorAnalysis, this.evaluateAllCode, this.includeSubClasses, this.maxPartialEvaluations, this.shouldAnalyzeNextCodeAttribute, this.skipIncompleteCalls, this.arrayValueFactory, this.ignoreExceptions, this.executingInvocationUnitBuilder, this.visitors);
        }
    }
}

