/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;

public interface InstructionVisitor {
    default public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + instruction.getClass().getName());
    }

    default public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        this.visitAnyInstruction(clazz, method, codeAttribute, offset, simpleInstruction);
    }

    default public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        this.visitAnyInstruction(clazz, method, codeAttribute, offset, variableInstruction);
    }

    default public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        this.visitAnyInstruction(clazz, method, codeAttribute, offset, constantInstruction);
    }

    default public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        this.visitAnyInstruction(clazz, method, codeAttribute, offset, branchInstruction);
    }

    default public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        this.visitAnyInstruction(clazz, method, codeAttribute, offset, switchInstruction);
    }

    default public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
        this.visitAnySwitchInstruction(clazz, method, codeAttribute, offset, tableSwitchInstruction);
    }

    default public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.visitAnySwitchInstruction(clazz, method, codeAttribute, offset, lookUpSwitchInstruction);
    }
}

