/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.tagset;

import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import com.hankcs.hanlp.model.perceptron.common.IIdStringMap;
import com.hankcs.hanlp.model.perceptron.common.IStringIdMap;
import com.hankcs.hanlp.model.perceptron.common.TaskType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class TagSet
implements IIdStringMap,
IStringIdMap,
Iterable<Map.Entry<String, Integer>>,
ICacheAble {
    private Map<String, Integer> stringIdMap = new TreeMap<String, Integer>();
    private ArrayList<String> idStringMap = new ArrayList();
    private int[] allTags;
    public TaskType type;

    public TagSet(TaskType type) {
        this.type = type;
    }

    public int add(String tag) {
        Integer id = this.stringIdMap.get(tag);
        if (id == null) {
            id = this.stringIdMap.size();
            this.stringIdMap.put(tag, id);
            this.idStringMap.add(tag);
        }
        return id;
    }

    public int size() {
        return this.stringIdMap.size();
    }

    public int sizeIncludingBos() {
        return this.size() + 1;
    }

    public int bosId() {
        return this.size();
    }

    public void lock() {
        this.allTags = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            this.allTags[i] = i;
        }
    }

    @Override
    public String stringOf(int id) {
        return this.idStringMap.get(id);
    }

    @Override
    public int idOf(String string) {
        Integer id = this.stringIdMap.get(string);
        if (id == null) {
            id = -1;
        }
        return id;
    }

    @Override
    public Iterator<Map.Entry<String, Integer>> iterator() {
        return this.stringIdMap.entrySet().iterator();
    }

    public int[] allTags() {
        return this.allTags;
    }

    @Override
    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.type.ordinal());
        out.writeInt(this.size());
        for (String tag : this.idStringMap) {
            out.writeUTF(tag);
        }
    }

    @Override
    public boolean load(ByteArray byteArray) {
        this.idStringMap.clear();
        this.stringIdMap.clear();
        int size = byteArray.nextInt();
        for (int i = 0; i < size; ++i) {
            String tag = byteArray.nextUTF();
            this.idStringMap.add(tag);
            this.stringIdMap.put(tag, i);
        }
        this.lock();
        return true;
    }

    public void load(DataInputStream in) throws IOException {
        this.idStringMap.clear();
        this.stringIdMap.clear();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String tag = in.readUTF();
            this.idStringMap.add(tag);
            this.stringIdMap.put(tag, i);
        }
        this.lock();
    }

    public Collection<String> tags() {
        return this.idStringMap;
    }
}

