/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.cache;

import com.helger.commons.cache.AbstractCache;
import java.util.function.Function;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CacheWithConversion<KEYTYPE, VALUETYPE>
extends AbstractCache<KEYTYPE, VALUETYPE> {
    public CacheWithConversion(@Nonnull String string) {
        this(-1, string);
    }

    public CacheWithConversion(@CheckForSigned int n, @Nonnull String string) {
        super(n, string);
    }

    @Nonnull
    public final VALUETYPE getFromCache(@Nonnull KEYTYPE KEYTYPE, @Nonnull Function<KEYTYPE, VALUETYPE> function) {
        Object object = super.getFromCacheNoStats(KEYTYPE);
        if (object == null) {
            object = this.m_aRWLock.writeLocked(() -> {
                Object object2 = super.getFromCacheNoStatsNotLocked(KEYTYPE);
                if (object2 == null) {
                    object2 = function.apply(KEYTYPE);
                    if (object2 == null) {
                        throw new IllegalStateException("The converter returned a null object for the key '" + KEYTYPE + "'");
                    }
                    super.putInCacheNotLocked(KEYTYPE, object2);
                    this.m_aCacheAccessStats.cacheMiss();
                } else {
                    this.m_aCacheAccessStats.cacheHit();
                }
                return object2;
            });
        } else {
            this.m_aCacheAccessStats.cacheHit();
        }
        return object;
    }
}

