/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.equals;

import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ECollectionBaseType;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.equals.EqualsImplementationRegistry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EqualsHelper {
    private static final EqualsHelper s_aInstance = new EqualsHelper();

    private EqualsHelper() {
    }

    public static <T> boolean identityEqual(@Nullable T t, @Nullable T t2) {
        return t == t2;
    }

    public static boolean equals(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    public static boolean equals(byte by, byte by2) {
        return by == by2;
    }

    public static boolean equals(char c, char c2) {
        return c == c2;
    }

    public static boolean equals(double d, double d2) {
        return d == d2 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean equals(float f, float f2) {
        return f == f2 || Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean equals(int n, int n2) {
        return n == n2;
    }

    public static boolean equals(long l, long l2) {
        return l == l2;
    }

    public static boolean equals(short s, short s2) {
        return s == s2;
    }

    public static boolean equals(@Nullable Object object, @Nullable Object object2) {
        return EqualsImplementationRegistry.areEqual(object, object2);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static boolean equalsIgnoreCase(@Nullable String string, @Nullable String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    private static boolean _areChildrenEqual(@Nullable Object object, @Nullable Object object2) {
        if (CollectionHelper.isCollectionObject(object) && CollectionHelper.isCollectionObject(object2)) {
            return EqualsHelper.equalsCollection(object, object2);
        }
        return EqualsImplementationRegistry.areEqual(object, object2);
    }

    public static boolean equalsCollection(@Nullable Object object, @Nullable Object object2) {
        if (EqualsHelper.identityEqual(object, object2)) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        ECollectionBaseType eCollectionBaseType = CollectionHelper.getCollectionBaseTypeOfObject(object);
        ECollectionBaseType eCollectionBaseType2 = CollectionHelper.getCollectionBaseTypeOfObject(object2);
        if (eCollectionBaseType == null) {
            throw new IllegalArgumentException("The first parameter is not a container type: " + object);
        }
        if (eCollectionBaseType2 == null) {
            throw new IllegalArgumentException("The second parameter is not a container type: " + object2);
        }
        if (!eCollectionBaseType.equals((Object)eCollectionBaseType2)) {
            return false;
        }
        switch (eCollectionBaseType) {
            case COLLECTION: {
                Collection collection = (Collection)object;
                Collection collection2 = (Collection)object2;
                if (collection.isEmpty() && collection2.isEmpty()) {
                    return true;
                }
                if (collection.size() != collection2.size()) {
                    return false;
                }
                Iterator iterator = collection.iterator();
                Iterator iterator2 = collection2.iterator();
                while (iterator.hasNext()) {
                    Object e;
                    Object e2 = iterator.next();
                    if (EqualsHelper._areChildrenEqual(e2, e = iterator2.next())) continue;
                    return false;
                }
                return true;
            }
            case SET: {
                Set set = (Set)object;
                Set set2 = (Set)object2;
                if (set.isEmpty() && set2.isEmpty()) {
                    return true;
                }
                if (set.size() != set2.size()) {
                    return false;
                }
                for (Object e : set) {
                    if (set2.contains(e)) continue;
                    return false;
                }
                return true;
            }
            case MAP: {
                Map map = (Map)object;
                Map map2 = (Map)object2;
                if (map.isEmpty() && map2.isEmpty()) {
                    return true;
                }
                if (map.size() != map2.size()) {
                    return false;
                }
                for (Map.Entry entry : map.entrySet()) {
                    Object v;
                    Object v2 = entry.getValue();
                    if (EqualsHelper._areChildrenEqual(v2, v = map2.get(entry.getKey()))) continue;
                    return false;
                }
                return true;
            }
            case ARRAY: {
                Class<?> clazz = object.getClass().getComponentType();
                Class<?> clazz2 = object2.getClass().getComponentType();
                if (CollectionHelper.isCollectionClass(clazz) && CollectionHelper.isCollectionClass(clazz2)) {
                    Object[] objectArray = (Object[])object;
                    Object[] objectArray2 = (Object[])object2;
                    if (objectArray.length != objectArray2.length) {
                        return false;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object3 = objectArray[i];
                        Object object4 = objectArray2[i];
                        if (EqualsHelper._areChildrenEqual(object3, object4)) continue;
                        return false;
                    }
                    return true;
                }
                return EqualsImplementationRegistry.areEqual(object, object2);
            }
            case ITERATOR: {
                Iterator iterator = (Iterator)object;
                Iterator iterator3 = (Iterator)object2;
                while (iterator.hasNext()) {
                    Object e;
                    if (!iterator3.hasNext()) {
                        return false;
                    }
                    Object e3 = iterator.next();
                    if (EqualsHelper._areChildrenEqual(e3, e = iterator3.next())) continue;
                    return false;
                }
                return !iterator3.hasNext();
            }
            case ITERABLE: {
                Iterable iterable = (Iterable)object;
                Iterable iterable2 = (Iterable)object2;
                return EqualsHelper.equalsCollection(iterable.iterator(), iterable2.iterator());
            }
            case ENUMERATION: {
                Enumeration enumeration = (Enumeration)object;
                Enumeration enumeration2 = (Enumeration)object2;
                while (enumeration.hasMoreElements()) {
                    Object e;
                    if (!enumeration2.hasMoreElements()) {
                        return false;
                    }
                    Object e4 = enumeration.nextElement();
                    if (EqualsHelper._areChildrenEqual(e4, e = enumeration2.nextElement())) continue;
                    return false;
                }
                return !enumeration2.hasMoreElements();
            }
        }
        throw new IllegalStateException("Unhandled container type " + (Object)((Object)eCollectionBaseType) + "!");
    }

    public static boolean equalsAsList(@Nullable Object object, @Nullable Object object2) {
        if (EqualsHelper.identityEqual(object, object2)) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        CommonsArrayList<?> commonsArrayList = CollectionHelper.getAsList(object);
        CommonsArrayList<?> commonsArrayList2 = CollectionHelper.getAsList(object2);
        return EqualsHelper.equalsCollection(commonsArrayList, commonsArrayList2);
    }
}

