/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error.list;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.multimap.IMultiMapListBased;
import com.helger.commons.collection.multimap.MultiLinkedHashMapArrayListBased;
import com.helger.commons.error.IError;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.IErrorBaseList;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.regex.RegExHelper;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;

@MustImplementEqualsAndHashcode
public interface IErrorList
extends IErrorBaseList<IError>,
IHasSize {
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IError> getAllItems();

    default public boolean hasNoEntryForField(@Nullable String string) {
        return this.containsNone(iError -> iError.hasErrorFieldName(string));
    }

    default public boolean hasNoEntryForFields(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.hasEntryForField(string)) continue;
                return false;
            }
        }
        return true;
    }

    default public boolean hasEntryForField(@Nullable String string) {
        return this.containsAny(iError -> iError.hasErrorFieldName(string));
    }

    default public boolean hasEntryForField(@Nullable String string, @Nullable IErrorLevel iErrorLevel) {
        return iErrorLevel != null && this.containsAny(iError -> iError.hasErrorFieldName(string) && iError.hasErrorLevel(iErrorLevel));
    }

    default public boolean hasErrorForField(@Nullable String string) {
        return this.containsAny(iError -> iError.hasErrorFieldName(string) && iError.isError());
    }

    default public boolean hasEntryForFields(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.hasEntryForField(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    @ReturnsMutableCopy
    default public IErrorList getListOfField(@Nullable String string) {
        return this.getSubList(iError -> iError.hasErrorFieldName(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public IErrorList getListOfFields(String ... stringArray) {
        if (ArrayHelper.isEmpty(stringArray)) {
            return this.getSubList(iError -> false);
        }
        return this.getSubList(iError -> iError.hasErrorFieldName() && ArrayHelper.contains(stringArray, iError.getErrorFieldName()));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public IErrorList getListOfFieldsStartingWith(String ... stringArray) {
        if (ArrayHelper.isEmpty(stringArray)) {
            return this.getSubList(iError -> false);
        }
        return this.getSubList(iError -> iError.hasErrorFieldName() && ArrayHelper.containsAny(stringArray, string -> iError.getErrorFieldName().startsWith((String)string)));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public IErrorList getListOfFieldsRegExp(@Nonnull @RegEx @Nonempty String string) {
        return this.getSubList(iError -> iError.hasErrorFieldName() && RegExHelper.stringMatchesPattern(string, iError.getErrorFieldName()));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public IErrorList getListWithoutField() {
        return this.getSubList(iError -> iError.hasNoErrorFieldName());
    }

    @Nonnull
    default public IErrorList getAllFailures() {
        return this.getSubList(iError -> iError.isFailure());
    }

    @Nonnull
    default public IErrorList getAllErrors() {
        return this.getSubList(iError -> iError.isError());
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getSubList(@Nullable Predicate<? super IError> var1);

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<String> getAllTexts(@Nonnull Locale locale) {
        return this.getAllDataItems(iError -> iError.getErrorText(locale));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <T> ICommonsList<T> getAllDataItems(@Nonnull Function<? super IError, T> function) {
        return new CommonsArrayList<Object>(this, iError -> function.apply((IError)iError));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public IMultiMapListBased<String, IError> getGroupedByID() {
        return this.getGrouped(IError::getErrorID);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public IMultiMapListBased<String, IError> getGroupedByFieldName() {
        return this.getGrouped(IError::getErrorFieldName);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <T> IMultiMapListBased<T, IError> getGrouped(@Nonnull Function<? super IError, T> function) {
        MultiLinkedHashMapArrayListBased multiLinkedHashMapArrayListBased = new MultiLinkedHashMapArrayListBased();
        this.forEach((? super T iError) -> multiLinkedHashMapArrayListBased.putSingle(function.apply((IError)iError), iError));
        return multiLinkedHashMapArrayListBased;
    }
}

