/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error.location;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.location.IErrorLocation;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ErrorLocation
implements IErrorLocation {
    public static final ErrorLocation NO_LOCATION = new ErrorLocation(null);
    private final String m_sResourceID;
    private final int m_nColumnNumber;
    private final int m_nLineNumber;

    public ErrorLocation(@Nullable String string) {
        this(string, -1, -1);
    }

    public ErrorLocation(@Nullable String string, int n, int n2) {
        this.m_sResourceID = string;
        this.m_nLineNumber = n;
        this.m_nColumnNumber = n2;
    }

    @Override
    @Nullable
    public String getResourceID() {
        return this.m_sResourceID;
    }

    @Override
    public int getLineNumber() {
        return this.m_nLineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.m_nColumnNumber;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ErrorLocation errorLocation = (ErrorLocation)object;
        return EqualsHelper.equals(this.m_sResourceID, errorLocation.m_sResourceID) && this.m_nLineNumber == errorLocation.m_nLineNumber && this.m_nColumnNumber == errorLocation.m_nColumnNumber;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sResourceID).append(this.m_nLineNumber).append(this.m_nColumnNumber).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("ResourceID", this.m_sResourceID).appendIf("LineNumber", this.m_nLineNumber, n -> n >= 0).appendIf("ColumnNumber", this.m_nColumnNumber, n -> n >= 0).getToString();
    }
}

