/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemHelper;
import java.io.File;
import java.io.IOException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FilenameHelper {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final char ILLEGAL_FILENAME_CHAR_REPLACEMENT = '_';
    public static final String PATH_CURRENT = ".";
    public static final String PATH_PARENT = "..";
    public static final char UNIX_SEPARATOR = '/';
    public static final String UNIX_SEPARATOR_STR = Character.toString('/');
    public static final char WINDOWS_SEPARATOR = '\\';
    public static final String WINDOWS_SEPARATOR_STR = Character.toString('\\');
    public static final String UNIX_UNC_PREFIX = "//";
    public static final String WINDOWS_UNC_PREFIX = "\\\\";
    public static final String WINDOWS_UNC_PREFIX_LOCAL1 = "\\\\.\\";
    public static final String WINDOWS_UNC_PREFIX_LOCAL2 = "\\\\?\\";
    public static final char HIDDEN_FILE_PREFIX = '.';
    private static final Logger s_aLogger = LoggerFactory.getLogger(FilenameHelper.class);
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'\u0000', '<', '>', '?', '*', ':', '|', '\"'};
    private static final String[] ILLEGAL_PREFIXES = new String[]{"CLOCK$", "CON", "PRN", "AUX", "NUL", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final char[] ILLEGAL_SUFFIXES = new char[]{'.', ' ', '\t'};
    private static final FilenameHelper s_aInstance;

    private FilenameHelper() {
    }

    public static int getIndexOfExtension(@Nullable String string) {
        if (string == null) {
            return -1;
        }
        int n = string.lastIndexOf(46);
        int n2 = FilenameHelper.getIndexOfLastSeparator(string);
        return n2 > n ? -1 : n;
    }

    @Nullable
    public static String getWithoutExtension(@Nullable File file) {
        return file == null ? null : FilenameHelper.getWithoutExtension(file.getPath());
    }

    @Nullable
    public static String getWithoutExtension(@Nullable String string) {
        int n = FilenameHelper.getIndexOfExtension(string);
        return n == -1 ? string : string.substring(0, n);
    }

    @Nonnull
    public static String getExtension(@Nullable File file) {
        return file == null ? "" : FilenameHelper.getExtension(file.getName());
    }

    @Nonnull
    public static String getExtension(@Nullable String string) {
        int n = FilenameHelper.getIndexOfExtension(string);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static boolean hasExtension(@Nullable File file, String ... stringArray) {
        ValueEnforcer.notNull(stringArray, "Extensions");
        String string = FilenameHelper.getExtension(file);
        for (String string2 : stringArray) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtension(@Nullable String string, String ... stringArray) {
        ValueEnforcer.notNull(stringArray, "Extensions");
        String string2 = FilenameHelper.getExtension(string);
        for (String string3 : stringArray) {
            if (!string2.equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }

    public static int getIndexOfLastSeparator(@Nullable String string) {
        return string == null ? -1 : Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
    }

    @Nullable
    public static String getWithoutPath(@Nullable File file) {
        return file == null ? null : file.getName();
    }

    @Nullable
    public static String getWithoutPath(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = FilenameHelper.getIndexOfLastSeparator(string);
        return n == -1 ? string : string.substring(n + 1);
    }

    @Nullable
    public static String getPath(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = FilenameHelper.getIndexOfLastSeparator(string);
        return n == -1 ? "" : string.substring(0, n + 1);
    }

    @Nullable
    public static String getBaseName(@Nullable File file) {
        return file == null ? null : FilenameHelper.getWithoutExtension(file.getName());
    }

    @Nullable
    public static String getBaseName(@Nullable String string) {
        return FilenameHelper.getWithoutExtension(FilenameHelper.getWithoutPath(string));
    }

    @Nullable
    public static String getPathUsingUnixSeparator(@Nullable File file) {
        return file == null ? null : FilenameHelper.getPathUsingUnixSeparator(file.getPath());
    }

    @Nullable
    public static String getPathUsingUnixSeparator(@Nullable String string) {
        return string == null ? null : StringHelper.replaceAll(string, '\\', '/');
    }

    @Nullable
    public static String getPathUsingWindowsSeparator(@Nullable File file) {
        return file == null ? null : FilenameHelper.getPathUsingWindowsSeparator(file.getPath());
    }

    @Nullable
    public static String getPathUsingWindowsSeparator(@Nullable String string) {
        return string == null ? null : StringHelper.replaceAll(string, '/', '\\');
    }

    public static boolean isEqualIgnoreFileSeparator(@Nullable String string, @Nullable String string2) {
        return EqualsHelper.equals(FilenameHelper.getPathUsingUnixSeparator(string), FilenameHelper.getPathUsingUnixSeparator(string2));
    }

    @Nullable
    public static String getSecureFilename(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(0);
        return n == -1 ? string : string.substring(0, n);
    }

    public static boolean isValidFilename(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        if (FilenameHelper.containsPathSeparatorChar(string)) {
            return false;
        }
        if (StringHelper.endsWithAny(string, ILLEGAL_SUFFIXES)) {
            return false;
        }
        for (char c : ILLEGAL_CHARACTERS) {
            if (string.indexOf(c) == -1) continue;
            return false;
        }
        for (char c : (Object)ILLEGAL_PREFIXES) {
            if (!string.equalsIgnoreCase((String)c)) continue;
            return false;
        }
        Object object = string.toUpperCase(SystemHelper.getSystemLocale());
        for (String string2 : ILLEGAL_PREFIXES) {
            if (!((String)object).startsWith(string2 + PATH_CURRENT)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFilenameWithPaths(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        File file = new File(string);
        while (file != null) {
            String string2 = file.getName();
            File file2 = file.getParentFile();
            if (string2.length() == 0 && file2 == null) break;
            if (!FilenameHelper.isValidFilename(string2)) {
                return false;
            }
            file = file2;
        }
        return true;
    }

    @Nullable
    @Nonempty
    public static String getAsSecureValidFilename(@Nullable String string) {
        String string2 = FilenameHelper.getSecureFilename(string);
        if (StringHelper.hasText(string2)) {
            while (string2.length() > 0 && StringHelper.endsWithAny(string2, ILLEGAL_SUFFIXES)) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            for (char c : ILLEGAL_CHARACTERS) {
                string2 = StringHelper.replaceAll(string2, c, '_');
            }
            for (char c : (Object)ILLEGAL_PREFIXES) {
                if (!string2.equalsIgnoreCase((String)c)) continue;
                string2 = '_' + string2;
                break;
            }
            Object object = string2.toUpperCase(SystemHelper.getSystemLocale());
            for (String string3 : ILLEGAL_PREFIXES) {
                if (!((String)object).startsWith(string3 + PATH_CURRENT)) continue;
                string2 = '_' + string2;
                break;
            }
        }
        return StringHelper.hasNoText(string2) ? null : string2;
    }

    public static boolean isSecureFilenameCharacter(char c) {
        return c >= ' ' && c < '\u0080';
    }

    @Nullable
    @Nonempty
    public static String getAsSecureValidASCIIFilename(@Nullable String string) {
        return FilenameHelper.getAsSecureValidASCIIFilename(string, '_');
    }

    @Nullable
    @Nonempty
    public static String getAsSecureValidASCIIFilename(@Nullable String string, char c) {
        String string2 = FilenameHelper.getAsSecureValidFilename(string);
        if (string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (char c2 : string2.toCharArray()) {
            if (FilenameHelper.isSecureFilenameCharacter(c2)) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isPathSeparatorChar(char c) {
        return c == '/' || c == '\\';
    }

    public static boolean startsWithPathSeparatorChar(@Nullable CharSequence charSequence) {
        return FilenameHelper.isPathSeparatorChar(StringHelper.getFirstChar(charSequence));
    }

    public static boolean endsWithPathSeparatorChar(@Nullable CharSequence charSequence) {
        return FilenameHelper.isPathSeparatorChar(StringHelper.getLastChar(charSequence));
    }

    public static boolean containsPathSeparatorChar(@Nullable String string) {
        return string != null && (string.indexOf(47) >= 0 || string.indexOf(92) >= 0);
    }

    public static boolean isSystemInternalDirectory(@Nullable File file) {
        return file != null && FilenameHelper.isSystemInternalDirectory(file.getName());
    }

    public static boolean isSystemInternalDirectory(@Nullable CharSequence charSequence) {
        return charSequence != null && (charSequence.equals(PATH_CURRENT) || charSequence.equals(PATH_PARENT));
    }

    public static boolean isUNCPath(@Nonnull File file) {
        String string = file.getAbsolutePath();
        return FilenameHelper.isUNCPath(string);
    }

    public static boolean isUNCPath(@Nonnull String string) {
        return string.startsWith(WINDOWS_UNC_PREFIX) || string.startsWith(UNIX_UNC_PREFIX);
    }

    public static boolean isWindowsLocalUNCPath(@Nonnull File file) {
        String string = file.getAbsolutePath();
        return FilenameHelper.isWindowsLocalUNCPath(string);
    }

    public static boolean isWindowsLocalUNCPath(@Nonnull String string) {
        return string.startsWith(WINDOWS_UNC_PREFIX_LOCAL1) || string.startsWith(WINDOWS_UNC_PREFIX_LOCAL2);
    }

    @Nonnull
    public static String getCleanPath(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        if (!FilenameHelper.isUNCPath(file)) {
            try {
                return FilenameHelper.getPathUsingUnixSeparator(FileHelper.getCanonicalPath(file));
            }
            catch (IOException iOException) {
                s_aLogger.warn("Using getCleanPath on an invalid file '" + file + "'", (Throwable)iOException);
            }
        }
        return FilenameHelper.getCleanPath(file.getAbsolutePath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String getCleanPath(@Nullable String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        String string2 = "";
        String string3 = FilenameHelper.getSecureFilename(string);
        boolean bl = false;
        if (FilenameHelper.isUNCPath(string3)) {
            string2 = string2 + string3.substring(0, 2);
            string3 = string3.substring(2);
            bl = string2.startsWith(WINDOWS_SEPARATOR_STR);
        }
        int n3 = string3.indexOf("://");
        boolean bl2 = false;
        if (n3 > -1) {
            n2 = string3.indexOf(47, n3 + 3);
            if (n2 < 0) return string3;
            string2 = string2 + string3.substring(0, n2 + 1);
            string3 = string3.substring(n2 + 1);
            bl2 = true;
        } else {
            n2 = string3.indexOf(58);
            if (n2 >= 0) {
                string2 = string2 + string3.substring(0, n2 + 1);
                string3 = string3.substring(n2 + 1);
                bl2 = true;
            }
        }
        if (StringHelper.startsWith((CharSequence)(string3 = FilenameHelper.getPathUsingUnixSeparator(string3)), '/')) {
            if (string2.length() == 0) {
                bl2 = true;
            }
            string2 = string2 + (bl ? (char)'\\' : '/');
            string3 = string3.substring(1);
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        int n4 = 0;
        String[] stringArray = StringHelper.getExplodedArray('/', string3);
        for (n = stringArray.length - 1; n >= 0; --n) {
            String string4 = stringArray[n];
            if (string4.length() == 0 || PATH_CURRENT.equals(string4)) continue;
            if (PATH_PARENT.equals(string4)) {
                ++n4;
                continue;
            }
            if (n4 > 0) {
                --n4;
                continue;
            }
            commonsArrayList.add(0, string4);
        }
        if (bl2) return string2 + StringHelper.getImploded(bl ? (char)'\\' : (char)'/', commonsArrayList);
        for (n = 0; n < n4; ++n) {
            commonsArrayList.add(0, PATH_PARENT);
        }
        return string2 + StringHelper.getImploded(bl ? (char)'\\' : (char)'/', commonsArrayList);
    }

    @Nonnull
    public static String getCleanConcatenatedUrlPath(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "URL");
        ValueEnforcer.notNull(string2, "Path");
        if (StringHelper.hasNoText(string2)) {
            return FilenameHelper.getCleanPath(string);
        }
        String string3 = StringHelper.endsWith((CharSequence)string, '/') ? string : string + '/';
        String string4 = StringHelper.startsWith((CharSequence)string2, '/') ? string2.substring(1) : string2;
        return FilenameHelper.getCleanPath(string3 + string4);
    }

    @Nullable
    @CheckReturnValue
    public static String ensurePathStartingWithSeparator(@Nullable String string) {
        return string == null ? null : (FilenameHelper.startsWithPathSeparatorChar(string) ? string : File.separator + string);
    }

    @Nullable
    @CheckReturnValue
    public static String ensurePathEndingWithoutSeparator(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        while (FilenameHelper.endsWithPathSeparatorChar(string2)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Nullable
    @CheckReturnValue
    public static String ensurePathEndingWithSeparator(@Nullable String string) {
        return string == null ? null : (FilenameHelper.endsWithPathSeparatorChar(string) ? string : string + File.separator);
    }

    @Nullable
    public static String getRelativeToParentDirectory(@Nonnull File file, @Nullable File file2) {
        ValueEnforcer.notNull(file, "File");
        String string = FilenameHelper.getCleanPath(file);
        if (file2 == null) {
            return string;
        }
        String string2 = StringHelper.trimStart(string, FilenameHelper.getCleanPath(file2));
        if (string2.equals(string)) {
            return null;
        }
        if (FilenameHelper.startsWithPathSeparatorChar(string2)) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    @Nullable
    public static String getAbsoluteWithEnsuredParentDirectory(@Nonnull File file, @Nonnull String string) {
        ValueEnforcer.notNull(file, "ParentDirectory");
        ValueEnforcer.notNull(string, "FilePath");
        File file2 = new File(string);
        String string2 = string;
        if (file2.isAbsolute()) {
            if (!file.isAbsolute()) {
                s_aLogger.error("Cannot express absolute child file ('" + file2 + "') relative to a relative parent file ('" + file + "')!");
                return null;
            }
            string2 = FilenameHelper.getRelativeToParentDirectory(file2, file);
        }
        if (string2 == null) {
            return null;
        }
        String string3 = FilenameHelper.getCleanPath(file);
        String string4 = FilenameHelper.getCleanPath(new File(string3, string2));
        if (!string4.startsWith(string3)) {
            return null;
        }
        return string4;
    }

    public static boolean isHiddenFilename(@Nullable File file) {
        return file != null && FilenameHelper.isHiddenFilename(file.getName());
    }

    public static boolean isHiddenFilename(@Nullable String string) {
        return StringHelper.hasText(string) && string.charAt(0) == '.';
    }

    static {
        if (!FilenameHelper.isSecureFilenameCharacter('_')) {
            throw new InitializationException("The illegal filename replacement character must be a valid ASCII character!");
        }
        s_aInstance = new FilenameHelper();
    }
}

