/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource.inmemory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.resource.inmemory.AbstractMemoryReadableResource;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;

public class ReadableResourceInputStream
extends AbstractMemoryReadableResource {
    private final InputStream m_aIS;

    public ReadableResourceInputStream(@Nonnull InputStream inputStream) {
        this.m_aIS = ValueEnforcer.notNull(inputStream, "InputStream");
    }

    @Override
    @Nonnull
    @Nonempty
    public String getResourceID() {
        return "input-stream";
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        return this.m_aIS;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("inputStream", this.m_aIS).getToString();
    }
}

