/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streamprovider;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStreamAndReader;
import com.helger.commons.io.stream.ByteBufferInputStream;
import com.helger.commons.string.ToStringGenerator;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class ByteBufferInputStreamProvider
implements IHasInputStreamAndReader {
    private final ByteBuffer m_aBuffer;

    public ByteBufferInputStreamProvider(@Nonnull ByteBuffer byteBuffer) {
        this.m_aBuffer = ValueEnforcer.notNull(byteBuffer, "Buffer");
    }

    @Nonnull
    public ByteBuffer getByteBuffer() {
        return this.m_aBuffer;
    }

    @Override
    @Nonnull
    public final ByteBufferInputStream getInputStream() {
        return new ByteBufferInputStream(this.m_aBuffer);
    }

    public String toString() {
        return new ToStringGenerator(null).append("buffer", this.m_aBuffer).getToString();
    }
}

