/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.locale;

import com.helger.commons.CGlobal;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.CommonsHashSet;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.string.StringHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LocaleCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LocaleCache.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, Locale> m_aLocales = new CommonsHashMap<String, Locale>();

    private LocaleCache() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static LocaleCache getInstance() {
        LocaleCache localeCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return localeCache;
    }

    @Nullable
    public Locale getLocale(@Nullable String string) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray('_', string, 3);
            if (stringArray.length == 3) {
                return this.getLocale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (stringArray.length == 2) {
                return this.getLocale(stringArray[0], stringArray[1], "");
            }
        }
        return this.getLocale(string, "", "");
    }

    @Nullable
    public Locale getLocale(@Nullable String string, @Nullable String string2) {
        return this.getLocale(string, string2, "");
    }

    @Nonnull
    private static String _buildLocaleString(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(string);
        }
        if (string2.length() > 0) {
            stringBuilder.append('_').append(string2);
        }
        if (string3.length() > 0) {
            stringBuilder.append('_').append(string3);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public Locale getLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4;
        String string5;
        String string6 = StringHelper.getNotNull(LocaleHelper.getValidLanguageCode(string));
        String string7 = LocaleCache._buildLocaleString(string6, string5 = StringHelper.getNotNull(LocaleHelper.getValidCountryCode(string2)), string4 = StringHelper.getNotNull(string3));
        if (string7.length() == 0) {
            return null;
        }
        Locale locale = this.m_aRWLock.readLocked(() -> (Locale)this.m_aLocales.get(string7));
        if (locale == null) {
            locale = this.m_aRWLock.writeLocked(() -> this.m_aLocales.computeIfAbsent(string7, string4 -> new Locale(string6, string5, string4)));
        }
        return locale;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Locale> getAllLocales() {
        return this.m_aRWLock.readLocked(() -> {
            ICommonsList<Locale> iCommonsList = this.m_aLocales.copyOfValues();
            iCommonsList.remove(CGlobal.LOCALE_ALL);
            iCommonsList.remove(CGlobal.LOCALE_INDEPENDENT);
            return iCommonsList;
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<Locale> getAllLanguages() {
        CommonsHashSet<Locale> commonsHashSet = new CommonsHashSet<Locale>();
        for (Locale locale : this.getAllLocales()) {
            String string = locale.getLanguage();
            if (!StringHelper.hasText(string)) continue;
            commonsHashSet.add(this.getLocale(string, null, null));
        }
        return commonsHashSet;
    }

    public boolean containsLocale(@Nullable String string) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray('_', string, 3);
            if (stringArray.length == 3) {
                return this.containsLocale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (stringArray.length == 2) {
                return this.containsLocale(stringArray[0], stringArray[1], "");
            }
        }
        return this.containsLocale(string, "", "");
    }

    public boolean containsLocale(@Nullable String string, @Nullable String string2) {
        return this.containsLocale(string, string2, "");
    }

    @Nonnull
    private static String _createLocaleKey(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = StringHelper.getNotNull(LocaleHelper.getValidLanguageCode(string));
        String string5 = StringHelper.getNotNull(LocaleHelper.getValidCountryCode(string2));
        String string6 = StringHelper.getNotNull(string3);
        return LocaleCache._buildLocaleString(string4, string5, string6);
    }

    public boolean containsLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = LocaleCache._createLocaleKey(string, string2, string3);
        if (string4.length() == 0) {
            return false;
        }
        return this.m_aRWLock.readLocked(() -> this.m_aLocales.containsKey(string4));
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _initialAdd(@Nonnull Locale locale) {
        this.m_aLocales.put(locale.toString(), locale);
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aLocales.clear();
            this._initialAdd(CGlobal.LOCALE_ALL);
            this._initialAdd(CGlobal.LOCALE_INDEPENDENT);
            for (Locale object : Locale.getAvailableLocales()) {
                this._initialAdd(object);
            }
            for (String string : Locale.getISOCountries()) {
                this._initialAdd(new Locale("", string));
            }
            for (String string : Locale.getISOLanguages()) {
                this._initialAdd(new Locale(string, ""));
            }
        });
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Reinitialized " + LocaleCache.class.getName());
        }
    }

    private static final class SingletonHolder {
        private static final LocaleCache s_aInstance = new LocaleCache();

        private SingletonHolder() {
        }
    }
}

