/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.keepalive;

import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.ConnectionImpl;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;

public abstract class KeepAlive
extends Thread {
    protected final Logger log;
    protected final ConnectionImpl conn;
    protected int keepAliveInterval = 0;

    protected KeepAlive(ConnectionImpl conn, String name) {
        this.conn = conn;
        this.log = conn.getTransport().getConfig().getLoggerFactory().getLogger(this.getClass());
        this.setName(name);
        this.setDaemon(true);
    }

    public synchronized int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public synchronized void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
        if (keepAliveInterval > 0 && this.getState() == Thread.State.NEW) {
            this.start();
        }
        this.notify();
    }

    protected synchronized int getPositiveInterval() throws InterruptedException {
        while (this.keepAliveInterval <= 0) {
            this.wait();
        }
        return this.keepAliveInterval;
    }

    @Override
    public void run() {
        block5: {
            this.log.debug("Starting {}, sending keep-alive every {} seconds", (Object)this.getClass().getSimpleName(), (Object)this.keepAliveInterval);
            try {
                while (!this.isInterrupted()) {
                    int hi = this.getPositiveInterval();
                    if (this.conn.getTransport().isRunning()) {
                        this.log.debug("Sending keep-alive since {} seconds elapsed", (Object)hi);
                        this.doKeepAlive();
                    }
                    Thread.sleep(hi * 1000);
                }
            }
            catch (InterruptedException hi) {
            }
            catch (Exception e) {
                if (this.isInterrupted()) break block5;
                this.conn.getTransport().die(e);
            }
        }
        this.log.debug("Stopping {}", (Object)this.getClass().getSimpleName());
    }

    protected abstract void doKeepAlive() throws TransportException, ConnectionException;
}

