package org.beetl.sql.core.kit;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveHashMap<K,V> extends LinkedHashMap<String, Object> {

	private static final long serialVersionUID = 9178606903603606031L;
	
	private final Map<String, String> lowerCaseMap = new HashMap<String, String>();

    @Override
    public boolean containsKey(Object key) {
        Object realKey = lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
        return super.containsKey(realKey);
    }

    @Override
    public Object get(Object key) {
        Object realKey = lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
        return super.get(realKey);
    }
    
    @Override
    public Set keySet() {
    		return lowerCaseMap.keySet();
    }

    @Override
    public Object put(String key, Object value) {
    	
        /*
         * 保持map和lowerCaseMap同步
         * 在put新值之前remove旧的映射关系
         */
        Object oldKey = lowerCaseMap.put(key.toLowerCase(Locale.ENGLISH), key);
        Object oldValue = super.remove(oldKey);
        super.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<? extends String, ?> entry : m.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.put(key, value);
        }
    }

    @Override
    public Object remove(Object key) {
        Object realKey = lowerCaseMap.remove(key.toString().toLowerCase(Locale.ENGLISH));
        return super.remove(realKey);
    }
    
    public static void main(String[] args){
    		CaseInsensitiveHashMap map = new CaseInsensitiveHashMap();
    		map.put("m", 1);
    		map.put("a", 1);
    		map.put("z", 1);
    		
    		System.out.println(map.keySet());
	}
}
