/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.beetl.sql.core.kit.CaseInsensitiveHashMap;
import org.beetl.sql.core.kit.StringKit;
import org.beetl.sql.ext.gen.JavaType;

public class JPAEntityHelper {
    private static final Map<Class<?>, EntityTable> entityTableMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityTable getEntityTable(Class<?> entityClass) {
        EntityTable entityTable = null;
        Class<?> clazz = entityClass;
        synchronized (clazz) {
            entityTable = entityTableMap.get(entityClass);
            if (entityTable == null) {
                JPAEntityHelper.initEntityNameMap(entityClass);
                entityTable = entityTableMap.get(entityClass);
            }
        }
        if (entityTable == null) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u5bf9\u5e94\u7684\u8868\u540d!");
        }
        return entityTable;
    }

    public static Set<EntityColumn> getColumns(Class<?> entityClass) {
        return JPAEntityHelper.getEntityTable(entityClass).getEntityClassColumns();
    }

    public static Set<EntityColumn> getPKColumns(Class<?> entityClass) {
        return JPAEntityHelper.getEntityTable(entityClass).getEntityClassPKColumns();
    }

    public static Map<String, String> getColumnAlias(Class<?> entityClass) {
        Set<EntityColumn> columnList = JPAEntityHelper.getColumns(entityClass);
        HashMap<String, String> alias = new HashMap<String, String>(columnList.size());
        for (EntityColumn column : columnList) {
            alias.put(column.getColumn(), column.getProperty());
        }
        return alias;
    }

    public static String getSelectColumns(Class<?> entityClass) {
        Set<EntityColumn> columnList = JPAEntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        boolean skipAlias = Map.class.isAssignableFrom(entityClass);
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn());
            if (!skipAlias && !entityColumn.getColumn().equalsIgnoreCase(entityColumn.getProperty())) {
                selectBuilder.append(" ").append(entityColumn.getProperty().toUpperCase()).append(",");
                continue;
            }
            selectBuilder.append(",");
        }
        return selectBuilder.substring(0, selectBuilder.length() - 1);
    }

    public static String getAllColumns(Class<?> entityClass) {
        Set<EntityColumn> columnList = JPAEntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn()).append(",");
        }
        return selectBuilder.substring(0, selectBuilder.length() - 1);
    }

    public static String getPrimaryKeyWhere(Class<?> entityClass) {
        Set<EntityColumn> entityColumns = JPAEntityHelper.getPKColumns(entityClass);
        StringBuilder whereBuilder = new StringBuilder();
        for (EntityColumn column : entityColumns) {
            whereBuilder.append(column.getColumn()).append(" = ?").append(" AND ");
        }
        return whereBuilder.substring(0, whereBuilder.length() - 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void initEntityNameMap(Class<?> entityClass) {
        Table table;
        if (entityTableMap.get(entityClass) != null) {
            return;
        }
        EntityTable entityTable = null;
        if (entityClass.isAnnotationPresent(Table.class) && !(table = entityClass.getAnnotation(Table.class)).name().equals("")) {
            entityTable = new EntityTable();
            entityTable.setTable(table);
        }
        List<Field> fieldList = JPAEntityHelper.getAllField(entityClass, null);
        HashSet<EntityColumn> columnSet = new HashSet<EntityColumn>();
        HashSet<EntityColumn> pkColumnSet = new HashSet<EntityColumn>();
        CaseInsensitiveHashMap<String, String> cols = new CaseInsensitiveHashMap<String, String>();
        CaseInsensitiveHashMap<String, String> props = new CaseInsensitiveHashMap<String, String>();
        EntityColumn perIdEntityColumn = null;
        for (Field field : fieldList) {
            try {
                if (field.isAnnotationPresent(Transient.class)) continue;
                EntityColumn entityColumn = new EntityColumn();
                PropertyDescriptor p = new PropertyDescriptor(field.getName(), entityClass);
                Method method = p.getReadMethod();
                if (field.isAnnotationPresent(Id.class) || method.isAnnotationPresent(Id.class)) {
                    entityColumn.setId(true);
                    entityTable.setIdColumn(entityColumn);
                } else if (field.getName().toUpperCase().equals("ID")) {
                    perIdEntityColumn = entityColumn;
                }
                String columnName = null;
                String jdbcType = null;
                Column column = null;
                if (field.isAnnotationPresent(Column.class)) {
                    column = field.getAnnotation(Column.class);
                } else if (method.isAnnotationPresent(Column.class)) {
                    column = method.getAnnotation(Column.class);
                }
                if (column != null) {
                    columnName = column.name();
                    jdbcType = column.columnDefinition();
                }
                if (StringKit.isBlank(columnName)) {
                    columnName = field.getName();
                }
                if (StringKit.isBlank(jdbcType)) {
                    jdbcType = JPAEntityHelper.getPropertyJdbcType(p);
                }
                entityColumn.setProperty(field.getName());
                entityColumn.setColumn(columnName.toUpperCase());
                entityColumn.setJavaType(field.getType());
                entityColumn.setJdbcType(jdbcType);
                if (field.isAnnotationPresent(OrderBy.class)) {
                    OrderBy orderBy = field.getAnnotation(OrderBy.class);
                    if (orderBy.value().equals("")) {
                        entityColumn.setOrderBy("ASC");
                    } else {
                        entityColumn.setOrderBy(orderBy.value());
                    }
                }
                if (field.isAnnotationPresent(SequenceGenerator.class)) {
                    SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
                    if (sequenceGenerator.sequenceName().equals("")) {
                        throw new RuntimeException(entityClass + "\u5b57\u6bb5" + field.getName() + "\u7684\u6ce8\u89e3@SequenceGenerator\u672a\u6307\u5b9asequenceName!");
                    }
                    entityColumn.setSequenceName(sequenceGenerator.sequenceName());
                } else if (field.isAnnotationPresent(GeneratedValue.class)) {
                    GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                    if (generatedValue.generator().equals("UUID")) {
                        if (!field.getType().equals(String.class)) throw new RuntimeException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u4e3aUUID\uff0c\u4f46\u8be5\u5b57\u6bb5\u7c7b\u578b\u4e0d\u662fString");
                        entityColumn.setUuid(true);
                    } else if (generatedValue.generator().equals("JDBC")) {
                        if (!Number.class.isAssignableFrom(field.getType())) throw new RuntimeException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u4e3aUUID\uff0c\u4f46\u8be5\u5b57\u6bb5\u7c7b\u578b\u4e0d\u662fString");
                        entityColumn.setIdentity(true);
                        entityColumn.setGenerator("JDBC");
                    }
                }
                columnSet.add(entityColumn);
                if (entityColumn.isId()) {
                    pkColumnSet.add(entityColumn);
                }
                cols.put(entityColumn.getProperty(), entityColumn.getColumn());
                props.put(entityColumn.getColumn(), entityColumn.getProperty());
            }
            catch (IntrospectionException ex) {
                Logger.getLogger(JPAEntityHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (entityTable.getIdColumn() == null) {
            perIdEntityColumn.setId(true);
            entityTable.setIdColumn(perIdEntityColumn);
        }
        entityTable.colsMap = cols;
        entityTable.propsMap = props;
        entityTable.entityClassColumns = columnSet;
        if (pkColumnSet.size() == 0) {
            entityTable.entityClassPKColumns = columnSet;
        } else {
            entityTable.entityClassPKColumns = pkColumnSet;
        }
        entityTableMap.put(entityClass, entityTable);
    }

    public static String getPropertyJdbcType(PropertyDescriptor p) {
        Column column;
        String columnDefine;
        Column columnAnnotation;
        String methodName = null;
        Method method = p.getReadMethod();
        if (method.isAnnotationPresent(Column.class) && null != (columnAnnotation = method.getAnnotation(Column.class)) && StringKit.isNotBlank(columnDefine = (column = columnAnnotation).columnDefinition())) {
            methodName = columnDefine;
        }
        if (StringKit.isBlank(methodName)) {
            methodName = JavaType.javaTypeToJdbcType(p.getPropertyType());
        }
        return methodName;
    }

    public static void main(String[] args) {
        System.out.println(JPAEntityHelper.camelhumpToUnderline("userName"));
        System.out.println(JPAEntityHelper.camelhumpToUnderline("userPassWord"));
        System.out.println(JPAEntityHelper.camelhumpToUnderline("ISO9001"));
        System.out.println(JPAEntityHelper.camelhumpToUnderline("hello_world"));
    }

    public static String camelhumpToUnderline(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
        for (int i = 0; i < size; ++i) {
            char c = chars[i];
            if (JPAEntityHelper.isUppercaseAlpha(c)) {
                sb.append('_').append(c);
                continue;
            }
            sb.append(JPAEntityHelper.toUpperAscii(c));
        }
        return sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
    }

    public static String underlineToCamelhump(String str) {
        Matcher matcher = Pattern.compile("_[a-z]").matcher(str);
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (matcher.find()) {
            builder.replace(matcher.start() - i, matcher.end() - i, matcher.group().substring(1).toUpperCase());
            ++i;
        }
        if (Character.isUpperCase(builder.charAt(0))) {
            builder.replace(0, 1, String.valueOf(Character.toLowerCase(builder.charAt(0))));
        }
        return builder.toString();
    }

    public static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static char toUpperAscii(char c) {
        if (JPAEntityHelper.isUppercaseAlpha(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    private static List<Field> getAllField(Class<?> entityClass, List<Field> fieldList) {
        Field[] fields;
        if (fieldList == null) {
            fieldList = new ArrayList<Field>();
        }
        if (entityClass.equals(Object.class)) {
            return fieldList;
        }
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldList.add(field);
        }
        Class<?> superClass = entityClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class) && (superClass.isAnnotationPresent(Entity.class) || !Map.class.isAssignableFrom(superClass) && !Collection.class.isAssignableFrom(superClass))) {
            return JPAEntityHelper.getAllField(entityClass.getSuperclass(), fieldList);
        }
        return fieldList;
    }

    public static class EntityColumn {
        private String property;
        private String column;
        private Class<?> javaType;
        private String jdbcType;
        private String sequenceName;
        private boolean id = false;
        private boolean uuid = false;
        private boolean identity = false;
        private String generator;
        private String orderBy;

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }

        public void setJavaType(Class<?> javaType) {
            this.javaType = javaType;
        }

        public String getSequenceName() {
            return this.sequenceName;
        }

        public void setSequenceName(String sequenceName) {
            this.sequenceName = sequenceName;
        }

        public boolean isId() {
            return this.id;
        }

        public void setId(boolean id) {
            this.id = id;
        }

        public boolean isUuid() {
            return this.uuid;
        }

        public void setUuid(boolean uuid) {
            this.uuid = uuid;
        }

        public boolean isIdentity() {
            return this.identity;
        }

        public void setIdentity(boolean identity) {
            this.identity = identity;
        }

        public String getGenerator() {
            return this.generator;
        }

        public void setGenerator(String generator) {
            this.generator = generator;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityColumn that = (EntityColumn)o;
            if (this.id != that.id) {
                return false;
            }
            if (this.identity != that.identity) {
                return false;
            }
            if (this.uuid != that.uuid) {
                return false;
            }
            if (this.column != null ? !this.column.equals(that.column) : that.column != null) {
                return false;
            }
            if (this.generator != null ? !this.generator.equals(that.generator) : that.generator != null) {
                return false;
            }
            if (this.javaType != null ? !this.javaType.equals(that.javaType) : that.javaType != null) {
                return false;
            }
            if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
                return false;
            }
            if (this.property != null ? !this.property.equals(that.property) : that.property != null) {
                return false;
            }
            return !(this.sequenceName != null ? !this.sequenceName.equals(that.sequenceName) : that.sequenceName != null);
        }

        public int hashCode() {
            int result = this.property != null ? this.property.hashCode() : 0;
            result = 31 * result + (this.column != null ? this.column.hashCode() : 0);
            result = 31 * result + (this.javaType != null ? this.javaType.hashCode() : 0);
            result = 31 * result + (this.sequenceName != null ? this.sequenceName.hashCode() : 0);
            result = 31 * result + (this.id ? 1 : 0);
            result = 31 * result + (this.uuid ? 1 : 0);
            result = 31 * result + (this.identity ? 1 : 0);
            result = 31 * result + (this.generator != null ? this.generator.hashCode() : 0);
            result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
            return result;
        }

        public String getJdbcType() {
            return this.jdbcType;
        }

        public void setJdbcType(String jdbcType) {
            this.jdbcType = jdbcType;
        }
    }

    public static class EntityTable {
        private String name;
        private String catalog;
        private String schema;
        private Set<EntityColumn> entityClassColumns;
        private Set<EntityColumn> entityClassPKColumns;
        private Map<String, String> colsMap;
        private Map<String, String> propsMap;
        private EntityColumn idColumn;

        public void setTable(Table table) {
            this.name = table.name();
            this.catalog = table.catalog();
            this.schema = table.schema();
        }

        public String getName() {
            return this.name;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getPrefix() {
            if (this.catalog != null && this.catalog.length() > 0) {
                return this.catalog;
            }
            if (this.schema != null && this.schema.length() > 0) {
                return this.catalog;
            }
            return "";
        }

        public Set<EntityColumn> getEntityClassColumns() {
            return this.entityClassColumns;
        }

        public Set<EntityColumn> getEntityClassPKColumns() {
            return this.entityClassPKColumns;
        }

        public EntityColumn getIdColumn() {
            return this.idColumn;
        }

        public void setIdColumn(EntityColumn idColumn) {
            this.idColumn = idColumn;
        }

        public Map<String, String> getColsMap() {
            return this.colsMap;
        }

        public Map<String, String> getPropsMap() {
            return this.propsMap;
        }
    }
}

