/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.util.Map;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.KeyWordHandler;

public class SQLiteStyle
extends AbstractDBStyle {
    public SQLiteStyle() {
        this.keyWordHandler = new KeyWordHandler(){

            @Override
            public String getTable(String tableName) {
                return "`" + tableName + "`";
            }

            @Override
            public String getCol(String colName) {
                return "`" + colName + "`";
            }
        };
    }

    @Override
    public String getPageSQL(String sql) {
        return sql + this.getOrderBy() + " \nlimit " + this.HOLDER_START + "_pageSize" + this.HOLDER_END + " offset " + this.HOLDER_START + "_pageOffset" + this.HOLDER_END;
    }

    @Override
    public void initPagePara(Map<String, Object> param, long start, long size) {
        param.put("_pageOffset", start - (long)(this.offsetStartZero ? 0 : 1));
        param.put("_pageSize", size);
    }

    @Override
    public String getName() {
        return "sqlite";
    }
}

