/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.engine;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.engine.StringSqlTemplateLoader;

public class Beetl {
    GroupTemplate gt = null;
    Properties ps = null;

    public Beetl(SQLLoader loader, Properties other) {
        try {
            this.ps = this.loadDefaultConfig();
            Properties ext = this.loadExtConfig();
            this.ps.putAll((Map<?, ?>)ext);
            this.ps.putAll((Map<?, ?>)other);
            boolean product = Boolean.parseBoolean(this.ps.getProperty("PRODUCT_MODE"));
            StringSqlTemplateLoader resourceLoader = new StringSqlTemplateLoader(loader, product);
            Configuration cfg = new Configuration(this.ps);
            this.gt = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
            loader.setAutoCheck(!product);
            String charset = this.ps.getProperty("CHARSET");
            if (charset == null || charset.length() == 0) {
                charset = Charset.defaultCharset().name();
            }
            loader.setCharset(charset);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Properties loadDefaultConfig() {
        Properties ps = new Properties();
        InputStream ins = this.getClass().getResourceAsStream("/btsql.properties");
        if (ins == null) {
            return ps;
        }
        try {
            ps.load(ins);
        }
        catch (IOException e) {
            throw new RuntimeException("\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u9519:/btsql.properties");
        }
        return ps;
    }

    public Properties loadExtConfig() {
        Properties ps = new Properties();
        InputStream ins = Thread.currentThread().getContextClassLoader().getResourceAsStream("btsql-ext.properties");
        if (ins == null) {
            return ps;
        }
        try {
            ps.load(ins);
            ins.close();
        }
        catch (IOException e) {
            throw new RuntimeException("\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u9519:/btsql.properties");
        }
        return ps;
    }

    public GroupTemplate getGroupTemplate() {
        return this.gt;
    }

    public Properties getPs() {
        return this.ps;
    }
}

