/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.kit;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveHashMap<K, V>
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 9178606903603606031L;
    private final Map<String, String> lowerCaseMap = new HashMap<String, String>();

    @Override
    public boolean containsKey(Object key) {
        String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
        return super.containsKey(realKey);
    }

    @Override
    public Object get(Object key) {
        String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
        return super.get(realKey);
    }

    @Override
    public Set keySet() {
        return this.lowerCaseMap.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        String oldKey = this.lowerCaseMap.put(key.toLowerCase(Locale.ENGLISH), key);
        Object oldValue = super.remove(oldKey);
        super.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.put(key, value);
        }
    }

    @Override
    public Object remove(Object key) {
        String realKey = this.lowerCaseMap.remove(key.toString().toLowerCase(Locale.ENGLISH));
        return super.remove(realKey);
    }

    public static void main(String[] args) {
        CaseInsensitiveHashMap map = new CaseInsensitiveHashMap();
        map.put("m", (Object)1);
        map.put("a", (Object)1);
        map.put("z", (Object)1);
        System.out.println(map.keySet());
    }
}

