/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.orm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.orm.LazyEntity;
import org.beetl.sql.core.orm.MappingEntity;

public class LazyMappingEntity
extends MappingEntity {
    @Override
    public void map(List list, SQLManager sm) {
        if (list.size() == 0) {
            return;
        }
        this.init(list.get(0));
        for (Object obj : list) {
            this.mapClassItem(obj, sm);
        }
    }

    @Override
    protected void mapClassItem(Object obj, final SQLManager sm) {
        if (this.sqlId != null) {
            final HashMap<String, Object> paras = new HashMap<String, Object>();
            for (Map.Entry entry : this.mapkey.entrySet()) {
                String attr = (String)entry.getKey();
                String targetAttr = (String)entry.getValue();
                Object value = BeanKit.getBeanProperty(obj, attr);
                paras.put(targetAttr, value);
            }
            LazyEntity lazy = new LazyEntity(){

                @Override
                public Object get() {
                    List ret = sm.select(LazyMappingEntity.this.sqlId, LazyMappingEntity.this.targetClass, paras);
                    return LazyMappingEntity.this.retValue(ret);
                }
            };
            this.setTailAttr(obj, lazy);
        } else {
            if (this.mapkey.size() == 1) {
                String tableName = sm.getNc().getTableName(this.targetClass);
                TableDesc tableDesc = sm.getMetaDataManager().getTable(tableName);
                ClassDesc classDesc = tableDesc.getClassDesc(this.targetClass, sm.getNc());
                if (classDesc.getIdAttrs().size() == 1 && classDesc.getIdAttrs().containsAll(this.mapkey.values())) {
                    String foreignAttr = (String)this.mapkey.keySet().iterator().next();
                    final Object value = BeanKit.getBeanProperty(obj, foreignAttr);
                    LazyEntity lazy = new LazyEntity(){

                        @Override
                        public Object get() {
                            Object ret = sm.single(LazyMappingEntity.this.targetClass, value);
                            return ret;
                        }
                    };
                    this.setTailAttr(obj, lazy);
                    return;
                }
            }
            final Object ins = this.getIns(this.targetClass);
            for (Map.Entry entry : this.mapkey.entrySet()) {
                String attr = (String)entry.getKey();
                String targetAttr = (String)entry.getValue();
                Object value = BeanKit.getBeanProperty(obj, attr);
                BeanKit.setBeanProperty(ins, value, targetAttr);
            }
            LazyEntity lazy = new LazyEntity(){

                @Override
                public Object get() {
                    List<Object> ret = sm.template(ins);
                    return LazyMappingEntity.this.retValue(ret);
                }
            };
            this.setTailAttr(obj, lazy);
        }
    }

    private Object retValue(List ret) {
        if (this.isSingle) {
            if (ret.isEmpty()) {
                return null;
            }
            return ret.get(0);
        }
        return ret;
    }
}

