/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.coll;

import com.ibm.icu.impl.Norm2AllModes;
import com.ibm.icu.impl.Normalizer2Impl;
import com.ibm.icu.impl.Trie2_32;
import com.ibm.icu.impl.coll.CollationData;
import com.ibm.icu.impl.coll.CollationSettings;
import com.ibm.icu.impl.coll.SharedObject;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollationTailoring {
    public CollationData data;
    public SharedObject.Reference<CollationSettings> settings;
    public String rules = "";
    public ULocale actualLocale = ULocale.ROOT;
    public VersionInfo version = ZERO_VERSION;
    private static final VersionInfo ZERO_VERSION = VersionInfo.getInstance(0, 0, 0, 0);
    CollationData ownedData;
    Trie2_32 trie;
    UnicodeSet unsafeBackwardSet;
    public Map<Integer, Integer> maxExpansions;

    CollationTailoring(SharedObject.Reference<CollationSettings> baseSettings) {
        if (baseSettings != null) {
            assert (baseSettings.readOnly().reorderCodes.length == 0);
            assert (baseSettings.readOnly().reorderTable == null);
            this.settings = baseSettings.clone();
        } else {
            this.settings = new SharedObject.Reference<CollationSettings>(new CollationSettings());
        }
    }

    void ensureOwnedData() {
        if (this.ownedData == null) {
            Normalizer2Impl nfcImpl = Norm2AllModes.getNFCInstance().impl;
            this.ownedData = new CollationData(nfcImpl);
        }
        this.data = this.ownedData;
    }

    static VersionInfo makeBaseVersion(VersionInfo ucaVersion) {
        return VersionInfo.getInstance(VersionInfo.UCOL_BUILDER_VERSION.getMajor(), (ucaVersion.getMajor() << 3) + ucaVersion.getMinor(), ucaVersion.getMilli() << 6, 0);
    }

    void setVersion(VersionInfo baseVersion, VersionInfo rulesVersion) {
        this.version = VersionInfo.getInstance(VersionInfo.UCOL_BUILDER_VERSION.getMajor(), baseVersion.getMinor(), (baseVersion.getMilli() & 0xC0) + (rulesVersion.getMajor() + (rulesVersion.getMajor() >> 6) & 0x3F), (rulesVersion.getMinor() << 3) + (rulesVersion.getMinor() >> 5) + rulesVersion.getMilli() + (rulesVersion.getMicro() << 4) + (rulesVersion.getMicro() >> 4));
    }

    int getUCAVersion() {
        return this.version.getMinor() << 4 | this.version.getMilli() >> 6;
    }
}

