/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.BodyHtmlStylesContainer;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlPageBreak;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlPageBreakType;
import com.itextpdf.html2pdf.attach.impl.layout.PageContextProcessor;
import com.itextpdf.html2pdf.attach.impl.layout.PageContextProperties;
import com.itextpdf.html2pdf.attach.impl.layout.RunningElement;
import com.itextpdf.html2pdf.css.resolve.ICssResolver;
import com.itextpdf.html2pdf.html.node.INode;
import com.itextpdf.kernel.events.Event;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.RootLayoutArea;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.List;
import java.util.Map;

public class HtmlDocumentRenderer
extends DocumentRenderer {
    private static final boolean TRIM_LAST_BLANK_PAGE = true;
    private PageContextProcessor firstPageProc;
    private PageContextProcessor leftPageProc;
    private PageContextProcessor rightPageProc;
    private boolean evenPagesAreLeft = true;
    private PageMarginBoxesDrawingHandler handler;
    private IRenderer waitingElement;
    private boolean shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement = true;
    private boolean anythingAddedToCurrentArea = false;
    private int estimatedNumberOfPages;

    public HtmlDocumentRenderer(Document document, boolean immediateFlush) {
        super(document, immediateFlush);
    }

    public void processPageRules(INode rootNode, ICssResolver cssResolver, ProcessorContext context) {
        PageContextProperties firstPageProps = PageContextProperties.resolve(rootNode, cssResolver, context.getCssContext(), "first", "right");
        PageContextProperties leftPageProps = PageContextProperties.resolve(rootNode, cssResolver, context.getCssContext(), "left");
        PageContextProperties rightPageProps = PageContextProperties.resolve(rootNode, cssResolver, context.getCssContext(), "right");
        PageSize defaultPageSize = this.document.getPdfDocument().getDefaultPageSize();
        float[] defaultPageMargins = new float[]{this.document.getTopMargin(), this.document.getRightMargin(), this.document.getBottomMargin(), this.document.getRightMargin()};
        this.firstPageProc = new PageContextProcessor(firstPageProps, context, defaultPageSize, defaultPageMargins);
        this.leftPageProc = new PageContextProcessor(leftPageProps, context, defaultPageSize, defaultPageMargins);
        this.rightPageProc = new PageContextProcessor(rightPageProps, context, defaultPageSize, defaultPageMargins);
        this.handler = new PageMarginBoxesDrawingHandler().setHtmlDocumentRenderer(this);
        this.document.getPdfDocument().addEventHandler("EndPdfPage", (IEventHandler)this.handler);
    }

    public void addChild(IRenderer renderer) {
        if (this.waitingElement != null) {
            if (Boolean.TRUE.equals(renderer.getProperty(0x100001))) {
                this.waitingElement.setProperty(81, (Object)true);
            }
            IRenderer element = this.waitingElement;
            this.waitingElement = null;
            super.addChild(element);
            if (!HtmlDocumentRenderer.isRunningElementsOnly(element)) {
                this.shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement = false;
            }
        }
        this.waitingElement = renderer;
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)renderer.getProperty(99);
        Integer position = (Integer)renderer.getProperty(52);
        if (position != null && position == 3 || floatPropertyValue != null && !floatPropertyValue.equals((Object)FloatPropertyValue.NONE)) {
            this.waitingElement = null;
            super.addChild(renderer);
        }
    }

    public void close() {
        PdfPage lastPage;
        if (this.waitingElement != null) {
            IRenderer r = this.waitingElement;
            this.waitingElement = null;
            super.addChild(r);
        }
        super.close();
        PdfDocument pdfDocument = this.document.getPdfDocument();
        if (pdfDocument.getNumberOfPages() > 1 && (lastPage = pdfDocument.getLastPage()).getContentStreamCount() == 1 && lastPage.getContentStream(0).getOutputStream().getCurrentPos() <= 0L) {
            pdfDocument.removePage(pdfDocument.getNumberOfPages());
        }
        this.document.getPdfDocument().removeEventHandler("EndPdfPage", (IEventHandler)this.handler);
        for (int i = 1; i <= this.document.getPdfDocument().getNumberOfPages(); ++i) {
            PdfPage page = this.document.getPdfDocument().getPage(i);
            if (page.isFlushed()) continue;
            this.handler.processPage(this.document.getPdfDocument(), i);
        }
    }

    public IRenderer getNextRenderer() {
        if (this.waitingElement != null) {
            super.addChild(this.waitingElement);
            this.waitingElement = null;
        }
        HtmlDocumentRenderer relayoutRenderer = new HtmlDocumentRenderer(this.document, this.immediateFlush);
        PageSize defaultPageSize = this.document.getPdfDocument().getDefaultPageSize();
        float[] defaultPageMargins = new float[]{this.document.getTopMargin(), this.document.getRightMargin(), this.document.getBottomMargin(), this.document.getRightMargin()};
        relayoutRenderer.firstPageProc = this.firstPageProc.reset(defaultPageSize, defaultPageMargins);
        relayoutRenderer.leftPageProc = this.leftPageProc.reset(defaultPageSize, defaultPageMargins);
        relayoutRenderer.rightPageProc = this.rightPageProc.reset(defaultPageSize, defaultPageMargins);
        relayoutRenderer.estimatedNumberOfPages = this.currentPageNumber;
        relayoutRenderer.handler = this.handler.setHtmlDocumentRenderer(relayoutRenderer);
        return relayoutRenderer;
    }

    protected LayoutArea updateCurrentArea(LayoutResult overflowResult) {
        AreaBreak areaBreak;
        AreaBreak areaBreak2 = areaBreak = overflowResult != null ? overflowResult.getAreaBreak() : null;
        if (areaBreak instanceof HtmlPageBreak) {
            HtmlPageBreakType htmlPageBreakType = ((HtmlPageBreak)areaBreak).getBreakType();
            if (this.shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement && this.currentArea != null && overflowResult.getStatus() == 3 && this.currentArea.isEmptyArea() && this.currentArea.getPageNumber() == 1) {
                this.document.getPdfDocument().removePage(1);
                this.currentPageNumber = 0;
                overflowResult = null;
                this.currentArea = null;
                this.shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement = false;
                if (HtmlPageBreakType.LEFT.equals((Object)htmlPageBreakType) && !this.isPageLeft(1) || HtmlPageBreakType.RIGHT.equals((Object)htmlPageBreakType) && !this.isPageRight(1)) {
                    this.evenPagesAreLeft = !this.evenPagesAreLeft;
                }
            }
            boolean bl = this.anythingAddedToCurrentArea = this.anythingAddedToCurrentArea || overflowResult != null && overflowResult.getStatus() == 2;
            if (HtmlPageBreakType.ALWAYS.equals((Object)htmlPageBreakType)) {
                RootLayoutArea nextArea = this.currentArea;
                if (this.anythingAddedToCurrentArea || this.currentArea == null) {
                    nextArea = super.updateCurrentArea(overflowResult);
                }
                this.anythingAddedToCurrentArea = false;
                return nextArea;
            }
            if (HtmlPageBreakType.LEFT.equals((Object)htmlPageBreakType)) {
                RootLayoutArea nextArea = this.currentArea;
                if (this.anythingAddedToCurrentArea || this.currentArea == null || !this.isPageLeft(this.currentPageNumber)) {
                    do {
                        nextArea = super.updateCurrentArea(overflowResult);
                    } while (!this.isPageLeft(this.currentPageNumber));
                }
                this.anythingAddedToCurrentArea = false;
                return nextArea;
            }
            if (HtmlPageBreakType.RIGHT.equals((Object)htmlPageBreakType)) {
                RootLayoutArea nextArea = this.currentArea;
                if (this.anythingAddedToCurrentArea || this.currentArea == null || !this.isPageRight(this.currentPageNumber)) {
                    do {
                        nextArea = super.updateCurrentArea(overflowResult);
                    } while (!this.isPageRight(this.currentPageNumber));
                }
                this.anythingAddedToCurrentArea = false;
                return nextArea;
            }
        }
        this.anythingAddedToCurrentArea = false;
        return super.updateCurrentArea(overflowResult);
    }

    protected void shrinkCurrentAreaAndProcessRenderer(IRenderer renderer, List<IRenderer> resultRenderers, LayoutResult result) {
        if (renderer != null) {
            this.anythingAddedToCurrentArea = true;
        }
        super.shrinkCurrentAreaAndProcessRenderer(renderer, resultRenderers, result);
    }

    protected PageSize addNewPage(PageSize customPageSize) {
        int numberOfPages = this.document.getPdfDocument().getNumberOfPages();
        PageContextProcessor nextProcessor = this.getPageProcessor(numberOfPages + 1);
        PdfPage addedPage = customPageSize != null ? this.document.getPdfDocument().addNewPage(customPageSize) : this.document.getPdfDocument().addNewPage(nextProcessor.getPageSize());
        nextProcessor.processNewPage(addedPage);
        float[] margins = nextProcessor.computeLayoutMargins();
        float[] htmlStylesWidth = this.applyHtmlBodyMarginsBorders(addedPage, margins, false);
        float[] simulatedMarginForBody = new float[4];
        for (int i = 0; i < 4; ++i) {
            simulatedMarginForBody[i] = margins[i] + htmlStylesWidth[i];
        }
        float[] bodyStylesWidth = this.applyHtmlBodyMarginsBorders(addedPage, simulatedMarginForBody, true);
        this.setProperty(46, Float.valueOf(margins[0] + htmlStylesWidth[0] + bodyStylesWidth[0]));
        this.setProperty(45, Float.valueOf(margins[1] + htmlStylesWidth[1] + bodyStylesWidth[1]));
        this.setProperty(43, Float.valueOf(margins[2] + htmlStylesWidth[2] + bodyStylesWidth[2]));
        this.setProperty(44, Float.valueOf(margins[3] + htmlStylesWidth[3] + bodyStylesWidth[3]));
        return new PageSize(addedPage.getTrimBox());
    }

    private float[] applyHtmlBodyMarginsBorders(PdfPage page, float[] defaultMargins, boolean body) {
        int htmlOrBodyStylingProperty = body ? 0x10000A : 0x10000B;
        BodyHtmlStylesContainer styles = (BodyHtmlStylesContainer)this.document.getProperty(htmlOrBodyStylingProperty);
        if (styles == null) {
            return new float[4];
        }
        if (styles.hasBordersToDraw()) {
            Div pageBordersSimulation = new Div().setFillAvailableArea(true);
            for (Map.Entry<Integer, Object> entry : styles.properties.entrySet()) {
                pageBordersSimulation.setProperty(entry.getKey().intValue(), entry.getValue());
            }
            pageBordersSimulation.getAccessibilityProperties().setRole("Artifact");
            Canvas canvas = new Canvas(new PdfCanvas(page), page.getDocument(), page.getTrimBox().applyMargins(defaultMargins[0], defaultMargins[1], defaultMargins[2], defaultMargins[3], false));
            canvas.enableAutoTagging(page);
            canvas.add((IBlockElement)pageBordersSimulation);
            canvas.close();
        }
        return styles.getTotalWidth();
    }

    int getEstimatedNumberOfPages() {
        return this.estimatedNumberOfPages;
    }

    private PageContextProcessor getPageProcessor(int pageNum) {
        if (pageNum == 1 && this.evenPagesAreLeft) {
            return this.firstPageProc;
        }
        if (this.isPageLeft(pageNum)) {
            return this.leftPageProc;
        }
        return this.rightPageProc;
    }

    private boolean isPageLeft(int pageNum) {
        boolean pageIsEven = pageNum % 2 == 0;
        return this.evenPagesAreLeft == pageIsEven;
    }

    private boolean isPageRight(int pageNum) {
        return !this.isPageLeft(pageNum);
    }

    private static boolean isRunningElementsOnly(IRenderer waitingElement) {
        boolean res = waitingElement instanceof ParagraphRenderer && !waitingElement.getChildRenderers().isEmpty();
        if (res) {
            List childRenderers = waitingElement.getChildRenderers();
            int i = 0;
            while (res && i < childRenderers.size()) {
                res = childRenderers.get(i++) instanceof RunningElement.RunningElementRenderer;
            }
        }
        return res;
    }

    private static class PageMarginBoxesDrawingHandler
    implements IEventHandler {
        private HtmlDocumentRenderer htmlDocumentRenderer;

        private PageMarginBoxesDrawingHandler() {
        }

        PageMarginBoxesDrawingHandler setHtmlDocumentRenderer(HtmlDocumentRenderer htmlDocumentRenderer) {
            this.htmlDocumentRenderer = htmlDocumentRenderer;
            return this;
        }

        public void handleEvent(Event event) {
            if (event instanceof PdfDocumentEvent) {
                PdfPage page = ((PdfDocumentEvent)event).getPage();
                PdfDocument pdfDoc = ((PdfDocumentEvent)event).getDocument();
                int pageNumber = pdfDoc.getPageNumber(page);
                this.processPage(pdfDoc, pageNumber);
            }
        }

        void processPage(PdfDocument pdfDoc, int pageNumber) {
            PageContextProcessor pageProcessor = this.htmlDocumentRenderer.getPageProcessor(pageNumber);
            pageProcessor.processPageEnd(pageNumber, pdfDoc, this.htmlDocumentRenderer);
        }
    }
}

