/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.layout.property.UnitValue;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PageSizeParser {
    private static final Map<String, PageSize> pageSizeConstants = new HashMap<String, PageSize>();

    PageSizeParser() {
    }

    static PageSize fetchPageSize(String pageSizeStr, float em, float rem, PageSize defaultPageSize) {
        PageSize pageSize = (PageSize)defaultPageSize.clone();
        if (pageSizeStr == null || "auto".equals(pageSizeStr)) {
            return pageSize;
        }
        String[] pageSizeChunks = pageSizeStr.split(" ");
        String firstChunk = pageSizeChunks[0];
        if (PageSizeParser.isLengthValue(firstChunk)) {
            PageSize pageSizeBasedOnLength = PageSizeParser.parsePageLengthValue(pageSizeChunks, em, rem);
            if (pageSizeBasedOnLength != null) {
                pageSize = pageSizeBasedOnLength;
            } else {
                Logger logger = LoggerFactory.getLogger(PageSizeParser.class);
                logger.error(MessageFormatUtil.format((String)"Page size value {0} is invalid.", (Object[])new Object[]{pageSizeStr}));
            }
        } else {
            boolean b2;
            Boolean landscape = null;
            PageSize namedPageSize = null;
            if (PageSizeParser.isLandscapePortraitValue(firstChunk)) {
                landscape = "landscape".equals(firstChunk);
            } else {
                namedPageSize = pageSizeConstants.get(firstChunk);
            }
            if (pageSizeChunks.length > 1) {
                String secondChunk = pageSizeChunks[1];
                if (PageSizeParser.isLandscapePortraitValue(secondChunk)) {
                    landscape = "landscape".equals(secondChunk);
                } else {
                    namedPageSize = pageSizeConstants.get(secondChunk);
                }
            }
            boolean b1 = pageSizeChunks.length == 1 && (namedPageSize != null || landscape != null);
            boolean bl = b2 = namedPageSize != null && landscape != null;
            if (b1 || b2) {
                if (namedPageSize != null) {
                    pageSize = namedPageSize;
                }
                if (Boolean.TRUE.equals(landscape)) {
                    pageSize = pageSize.rotate();
                }
            } else {
                Logger logger = LoggerFactory.getLogger(PageSizeParser.class);
                logger.error(MessageFormatUtil.format((String)"Page size value {0} is invalid.", (Object[])new Object[]{pageSizeStr}));
            }
        }
        return pageSize;
    }

    private static PageSize parsePageLengthValue(String[] pageSizeChunks, float em, float rem) {
        Float height;
        Float width = PageSizeParser.tryParsePageLengthValue(pageSizeChunks[0], em, rem);
        if (width == null) {
            return null;
        }
        if (pageSizeChunks.length > 1) {
            height = PageSizeParser.tryParsePageLengthValue(pageSizeChunks[1], em, rem);
            if (height == null) {
                return null;
            }
        } else {
            height = width;
        }
        return new PageSize(width.floatValue(), height.floatValue());
    }

    private static Float tryParsePageLengthValue(String valueChunk, float em, float rem) {
        UnitValue unitValue = CssUtils.parseLengthValueToPt(valueChunk, em, rem);
        if (unitValue == null || unitValue.isPercentValue()) {
            return null;
        }
        return Float.valueOf(unitValue.getValue());
    }

    private static boolean isLengthValue(String pageSizeChunk) {
        return CssUtils.isMetricValue(pageSizeChunk) || CssUtils.isRelativeValue(pageSizeChunk);
    }

    private static boolean isLandscapePortraitValue(String pageSizeChunk) {
        return "landscape".equals(pageSizeChunk) || "portrait".equals(pageSizeChunk);
    }

    static {
        pageSizeConstants.put("a5", PageSize.A5);
        pageSizeConstants.put("a4", PageSize.A4);
        pageSizeConstants.put("a3", PageSize.A3);
        pageSizeConstants.put("b5", PageSize.B5);
        pageSizeConstants.put("b4", PageSize.B4);
        pageSizeConstants.put("jis-b5", new PageSize(516.0f, 729.0f));
        pageSizeConstants.put("jis-b4", new PageSize(729.0f, 1032.0f));
        pageSizeConstants.put("letter", PageSize.LETTER);
        pageSizeConstants.put("legal", PageSize.LEGAL);
        pageSizeConstants.put("ledger", PageSize.LEDGER);
    }
}

