/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.TextArea;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.layout.IPropertyContainer;

public class TextAreaTagWorker
implements ITagWorker,
IDisplayAware {
    private static final String DEFAULT_TEXTAREA_NAME = "TextArea";
    private TextArea textArea;
    private String display;

    public TextAreaTagWorker(IElementNode element, ProcessorContext context) {
        String name = element.getAttribute("id");
        if (name == null) {
            name = DEFAULT_TEXTAREA_NAME;
        }
        name = context.getFormFieldNameResolver().resolveFormName(name);
        this.textArea = new TextArea(name);
        Integer rows = CssUtils.parseInteger(element.getAttribute("rows"));
        Integer cols = CssUtils.parseInteger(element.getAttribute("cols"));
        this.textArea.setProperty(0x100008, rows);
        this.textArea.setProperty(0x100007, cols);
        this.textArea.setProperty(0x100003, !context.isCreateAcroForm());
        this.display = element.getStyles() != null ? element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        if (content.startsWith("\r\n")) {
            content = content.substring(2);
        } else if (content.startsWith("\r") || content.startsWith("\n")) {
            content = content.substring(1);
        }
        this.textArea.setProperty(0x100005, content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.textArea;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }
}

